<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'То :attribute должны быть приняты.',
    'active_url' => 'То :attribute недействительный URL-адрес.',
    'after' => 'То :attribute должна быть дата после :date.',
    'after_or_equal' => 'То :attribute должна быть датой после или равной :date.',
    'alpha' => 'То :attribute должен содержать только буквы.',
    'alpha_dash' => 'То :attribute должен содержать только буквы, цифры, дефисы и символы подчеркивания.',
    'alpha_num' => 'То :attribute должен содержать только буквы и цифры.',
    'array' => 'То :attribute должен быть массив.',
    'before' => 'То :attribute должна быть дата до :date.',
    'before_or_equal' => 'То :attribute должна быть датой до или равной :date.',
    'between' => [
        'numeric' => 'То :attribute должно быть между :min и :max.',
        'file' => 'То :attribute должен быть между :min и :max килобайтами.',
        'string' => 'То :attribute должно быть между символами :min и :max.',
        'array' => 'То :attribute должно быть между :min и :max элементами.',
    ],
    'boolean' => 'То :attribute field must be true or false.',
    'confirmed' => 'То :attribute подтверждение не совпадает.',
    'current_password' => 'Пароль неверен.',
    'date' => 'То :attribute не верная дата.',
    'date_equals' => 'То :attribute должна быть дата, равная :date.',
    'date_format' => 'То :attribute не соответствует формату :format.',
    'different' => 'То :attribute и :other должен быть другим.',
    'digits' => 'То :attribute должно быть :цифры цифры.',
    'digits_between' => 'То :attribute должно быть между цифрами :min и :max.',
    'dimensions' => 'То :attribute имеет недопустимые размеры изображения.',
    'distinct' => 'То :attribute поле имеет повторяющееся значение.',
    'email' => 'То :attribute must be a valid email address.',
    'ends_with' => 'То :attribute должен заканчиваться одним из следующих символов: :values.',
    'exists' => 'Выбранный :attribute является недействительным.',
    'file' => 'То :attribute должен быть файл.',
    'filled' => 'То :attribute field must have a value.',
    'gt' => [
        'numeric' => 'То :attribute должно быть больше :value.',
        'file' => 'То :attribute должно быть больше :value килобайт.',
        'string' => 'То :attribute должно быть больше, чем :value символов.',
        'array' => 'То :attribute должно быть больше, чем :value элементов.',
    ],
    'gte' => [
        'numeric' => 'То :attribute должно быть больше или равно :value.',
        'file' => 'То :attribute должен быть больше или равен :value килобайт.',
        'string' => 'То :attribute должно быть больше или равно :value символов.',
        'array' => 'То :attribute должны иметь элементы :value или более.',
    ],
    'image' => 'То :attribute must be an image.',
    'in' => 'То выбран :attribute является недействительным.',
    'in_array' => 'То :attribute поле не существует в :other.',
    'integer' => 'То :attribute должно быть целым числом.',
    'ip' => 'То :attribute должен быть действительным IP-адресом.',
    'ipv4' => 'То :attribute должен быть действительным адресом IPv4.',
    'ipv6' => 'То :attribute должен быть действительным адресом IPv6.',
    'json' => 'То :attribute должна быть допустимой строкой JSON.',
    'lt' => [
        'numeric' => 'То :attribute должно быть меньше :value.',
        'file' => 'То :attribute должно быть меньше :value килобайт.',
        'string' => 'То :attribute должно быть меньше символов :value.',
        'array' => 'То :attribute должно быть меньше чем :value элементов.',
    ],
    'lte' => [
        'numeric' => 'То :attribute должно быть меньше или равно :value.',
        'file' => 'То :attribute must be less than or equal :value kilobytes.',
        'string' => 'То :attribute должно быть меньше или равно :value символов.',
        'array' => 'То :attribute не должно быть более :value элементов.',
    ],
    'max' => [
        'numeric' => 'То :attribute не должен быть больше :max.',
        'file' => 'То :attribute не должен превышать :max килобайт.',
        'string' => 'То :attribute не должен превышать :max символов.',
        'array' => 'То :attribute не должно быть более :max элементов.',
    ],
    'mimes' => 'То :attribute должен быть файлом типа: :values.',
    'mimetypes' => 'То :attribute должен быть файлом типа: :values.',
    'min' => [
        'numeric' => 'То :attribute должно быть не менее :min.',
        'file' => 'То :attribute должно быть не менее :min килобайт.',
        'string' => 'То :attribute должно быть не менее :min символов.',
        'array' => 'То :attribute должно быть не менее :min элементов.',
    ],
    'multiple_of' => 'То :attribute должно быть кратно :value.',
    'not_in' => 'То выбран :attribute является недействительным.',
    'not_regex' => 'То :attribute формат недействителен.',
    'numeric' => 'То :attribute должно быть числом.',
    'password' => 'Пароль неверен.',
    'present' => 'То :attribute поле должно присутствовать.',
    'regex' => 'То :attribute формат недействителен.',
    'required' => 'То :attribute Поле, обязательное для заполнения.',
    'required_if' => 'То :attribute поле обязательно, когда :other равно :value.',
    'required_unless' => 'То :attribute field is required unless :other is in :values.',
    'required_with' => 'То :attribute Поле обязательно, когда присутствует :values.',
    'required_with_all' => 'То :attribute Поле обязательно, когда присутствуют :values.',
    'required_without' => 'То :attribute поле обязательно, когда :values ​​нет.',
    'required_without_all' => 'То :attribute Поле является обязательным, если ни одно из значений :value отсутствует.',
    'prohibited' => 'То :attribute поле запрещено.',
    'prohibited_if' => 'То :attribute поле запрещено, когда :other равно :value.',
    'prohibited_unless' => 'То :attribute поле запрещено, если только :other не находится в :values.',
    'same' => 'То :attribute и :other должны совпадать.',
    'size' => [
        'numeric' => 'То :attribute должно быть: размер.',
        'file' => 'То :attribute должно быть :size килобайт.',
        'string' => 'То :attribute должно быть :size символов.',
        'array' => 'То :attribute должен содержать элементы :size.',
    ],
    'starts_with' => 'То :attribute должен начинаться с одного из следующих: :values.',
    'string' => 'То :attribute должна быть строка.',
    'timezone' => 'То :attribute должен быть допустимым часовым поясом.',
    'unique' => 'То :attribute уже использовано.',
    'uploaded' => 'То :attribute не удалось загрузить.',
    'url' => 'То :attribute должен быть действительным URL.',
    'uuid' => 'То :attribute должен быть допустимым UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],

        //doctor opd charge keys
        'doctor_id' => [
            'unique' => 'Имя доктора уже занято.',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'email' => __('messages.user.email'),
        'last_name' => __('messages.user.last_name'),
        'first_name' => __('messages.user.first_name'),
        'password' => __('messages.department'),
        'gender' => __('messages.user.gender'),
        'city' => __('messages.user.city'),
        'zip' => __('messages.user.zip'),
        'name' => __('messages.common.name'),
        'status' => __('messages.account.status'),
        'description' => __('messages.account.description'),
        'patient_id' => __('messages.invoice.patient_id'),
        'receipt_no' => __('messages.advanced_payment.receipt_no'),
        'amount' => __('messages.advanced_payment.amount'),
        'date' => __('messages.advanced_payment.date'),
        'vehicle_number' => __('messages.ambulance.vehicle_number'),
        'vehicle_model' => __('messages.ambulance.vehicle_model'),
        'driver_contact' => __('messages.ambulance.driver_contact'),
        'year_made' => __('messages.ambulance.year_made'),
        'driver_license' => __('messages.ambulance.driver_license'),
        'doctor_id' => __('messages.ipd_patient.doctor_id'),
        'opd_date' => __('messages.appointment.opd_date'),
        'bed_type' => __('messages.bed.bed_type'),
        'charge' => __('messages.bed.charge'),
        'bed_id' => __('messages.bed.bed_id'),
        'case_id' => __('messages.bed_assign.case_id'),
        'assign_date' => __('messages.bed_assign.assign_date'),
        'discharge_date' => __('messages.bed_assign.discharge_date'),
        'title' => __('messages.document.title'),
        'bill_date' => __('messages.bill.bill_date'),
        'qty' => __('messages.bill.qty'),
        'price' => __('messages.bill.price'),
        'blood_group' => __('messages.user.blood_group'),
        'remained_bags' => __('messages.hospital_blood_bank.remained_bags'),
        'bags' => __('messages.blood_donation.bags'),
        'last_donate_date' => __('messages.blood_donation.last_donate_date'),
        'issue_date' => __('messages.blood_issue.issue_date'),
        'remarks' => __('messages.blood_issue.remarks'),
        'charge_type' => __('messages.charge_category.charge_type'),
        'code' => __('messages.charge.code'),
        'standard_charge' => __('messages.charge.standard_charge'),
        'currency_name' => __('messages.currency.currency_name'),
        'currency_code' => __('messages.currency.currency_code'),
        'currency_icon' => __('messages.currency.currency_icon'),
        'sr_no' => __('messages.employee_payroll.sr_no'),
        'payroll_id' => __('messages.employee_payroll.payroll_id'),
        'type' => __('messages.account.type'),
        'month' => __('messages.employee_payroll.month'),
        'year' => __('messages.employee_payroll.year'),
        'net_salary' => __('messages.employee_payroll.net_salary'),
        'basic_salary' => __('messages.employee_payroll.basic_salary'),
        'message' => __('messages.enquiry.message'),
        'expense_head' => __('messages.expense.expense_head'),
        'invoice_number' => __('messages.expense.invoice_number'),
        'short_description' => __('messages.short_description'),
        'about_us_title' => __('messages.front_setting.about_us_title'),
        'about_us_mission' => __('messages.front_setting.about_us_mission'),
        'about_us_image' => __('messages.front_setting.about_us_image'),
        'income_head' => __('messages.incomes.income_head'),
        'service_tax' => __('messages.insurance.service_tax'),
        'insurance_no' => __('messages.insurance.insurance_no'),
        'insurance_code' => __('messages.insurance.insurance_code'),
        'discount' => __('messages.insurance.discount'),
        'disease_name' => __('messages.insurance.diseases_name'),
        'disease_charge' => __('messages.insurance.diseases_charge'),
        'invoice_date' => __('messages.invoice.invoice_date'),
        'quantity' => __('messages.service.quantity'),
        'total_payments' => __('messages.dashboard.total_payments'),
        'gross_total' => __('messages.ipd_bill.gross_total'),
        'discount_in_percentage' => __('messages.ipd_bill.discount_in_percentage'),
        'tax_in_percentage' => __('messages.ipd_bill.tax_in_percentage'),
        'other_charges' => __('messages.ipd_bill.other_charges'),
        'net_payable_amount' => __('messages.ipd_bill.net_payable_amount'),
        'charge_type_id' => __('messages.ipd_patient_charges.charge_type_id'),
        'charge_category_id' => __('messages.ipd_patient_charges.charge_category_id'),
        'charge_id' => __('messages.ipd_patient_charges.charge_id'),
        'applied_charge' => __('messages.ipd_patient_charges.applied_charge'),
        'instruction' => __('messages.ipd_patient_consultant_register.instruction'),
        'instruction_date' => __('messages.ipd_patient_consultant_register.instruction_date'),
        'report_type' => __('messages.ipd_patient_diagnosis.report_type'),
        'report_date' => __('messages.ipd_patient_diagnosis.report_date'),
        'bed_type_id' => __('messages.ipd_patient.bed_type_id'),
        'weight' => __('messages.ipd_patient.weight'),
        'height' => __('messages.ipd_patient.height'),
        'bp' => __('messages.ipd_patient.bp'),
        'payment_mode' => __('messages.ipd_payments.payment_mode'),
        'notes' => __('messages.document.notes'),
        'category_id' => __('messages.ipd_patient_prescription.category_id'),
        'issued_by' => __('messages.issued_item.issued_by'),
        'issued_date' => __('messages.issued_item.issued_date'),
        'return_date' => __('messages.issued_item.return_date'),
        'unit' => __('messages.item.unit'),
        'consultation_title' => __('messages.live_consultation.consultation_title'),
        'consultation_date' => __('messages.live_consultation.consultation_date'),
        'consultation_duration_minutes' => __('messages.live_consultation.consultation_duration_minutes'),
        'type_number' => __('messages.live_consultation.type_number'),
        'to' => __('messages.common.to'),
        'subject' => __('messages.email.subject'),
        'selling_price' => __('messages.medicine.selling_price'),
        'buying_price' => __('messages.medicine.buying_price'),
        'side_effects' => __('messages.medicine.side_effects'),
        'salt_composition' => __('messages.medicine.salt_composition'),
        'appointment_date' => __('messages.opd_patient.appointment_date'),
        'rate' => __('messages.package.rate'),
        'test_name' => __('messages.radiology_test.test_name'),
        'short_name' => __('messages.radiology_test.short_name'),
        'test_type' => __('messages.radiology_test.test_type'),
        'policy_no' => __('messages.patient_admission.policy_no'),
        'fee' => __('messages.case.fee'),
        'payment_date' => __('messages.payment.payment_date'),
        'pay_to' => __('messages.payment.pay_to'),
        'from_title' => __('messages.postal.from_title'),
        'to_title' => __('messages.postal.to_title'),
        'reference_no' => __('messages.postal.reference_no'),
        'subcategory' => __('messages.radiology_test.subcategory'),
        'available_on' => __('messages.schedule.available_on'),
        'available_from' => __('messages.schedule.available_from'),
        'available_to' => __('messages.schedule.available_to'),
        'per_patient_time' => __('messages.schedule.per_patient_time'),
        'app_name' => __('messages.setting.app_name'),
        'company_name' => __('messages.setting.company_name'),
        'favicon' => __('messages.setting.favicon'),
        'zoom_api_key' => __('messages.live_consultation.zoom_api_key'),
        'zoom_api_secret' => __('messages.live_consultation.zoom_api_secret'),
        'dose_given_date' => __('messages.vaccinated_patient.dose_given_date'),
        'manufactured_by' => __('messages.vaccination.manufactured_by'),
        'brand' => __('messages.vaccination.brand'),
        'purpose' => __('messages.visitor.purpose'),
        'no_of_person' => __('messages.visitor.number_of_person'),
        'in_time' => __('messages.visitor.in_time'),
        'out_time' => __('messages.visitor.out_time'),
        'field_name' => __('messages.custom_field.field_name')
    ],

];
