<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'L\':attribute doit être accepté.',
    'active_url' => 'L\':attribute n\'est pas une URL valide.',
    'after' => 'L\':attribute doit être une date après: date.',
    'after_or_equal' => 'L\':attribute doit être une date postérieure ou égale à: date.',
    'alpha' => 'L\':attribute ne peut contenir que des lettres.',
    'alpha_dash' => 'L\':attribute ne peut contenir que des lettres, des chiffres, des tirets et des traits de soulignement.',
    'alpha_num' => 'L\':attribute ne peut contenir que des lettres et des chiffres.',
    'array' => 'L\':attribute doit être un tableau.',
    'before' => 'L\':attribute doit être une date antérieure à: date.',
    'before_or_equal' => 'L\':attribute doit être une date antérieure ou égale à: date.',
    'between' => [
        'numeric' => 'L\':attribute doit être compris entre: min et: max.',
        'file' => 'L\':attribute doit être compris entre: min et: max kilo-octets.',
        'string' => 'L\':attribute doit être compris entre: min et: max caractères.',
        'array' => 'L\':attribute doit avoir entre: min et: max éléments.',
    ],
    'boolean' => 'Le champ d\':attribute doit être vrai ou faux.',
    'confirmed' => 'La confirmation d\':attribute ne correspond pas.',
    'date' => 'L\':attribute n\'est pas une date valide.',
    'date_equals' => 'L\':attribute doit être une date égale à: date.',
    'date_format' => 'L\':attribute ne correspond pas au format: format.',
    'different' => 'L\':attribute et :autre doivent être différents.',
    'digits' => 'L\':attribute doit être :chiffres chiffres.',
    'digits_between' => 'L\':attribute doit être compris entre :min et :max :chiffres.',
    'dimensions' => 'L\':attribute a des dimensions d\'image non valides.',
    'distinct' => 'L\':attribute a des dimensions d\'image non valides..',
    'email' => 'L\':attribute doit être une adresse e-mail valide.',
    'ends_with' => 'L\':attribute doit se terminer par l\'une des valeurs suivantes: :values.',
    'exists' => 'L\':attribute sélectionné n\'est pas valide.',
    'file' => 'L\':attribute doit être un fichier.',
    'filled' => 'Le champ d\':attribute doit avoir une valeur.',
    'gt' => [
        'numeric' => 'L\':attribute doit être supérieur à: value.',
        'file' => 'L\':attribute doit être supérieur à: value kilo-octets.',
        'string' => 'L\':attribute doit être supérieur à les caractères de: value.',
        'array' => 'L\':attribute doit avoir plus de éléments de: value.',
    ],
    'gte' => [
        'numeric' => 'L\':attribute doit être supérieur ou égal à: value.',
        'file' => 'The :attribute must be greater than or equal :value kilobytes.',
        'string' => 'L\':attribute doit être supérieur ou égal à caractères de :value.',
        'array' => 'L\':attribute doit avoir des éléments de :value ou plus.',
    ],
    'image' => 'L\':attribute doit être une image.',
    'in' => 'L\':attribute sélectionné n\'est pas valide.',
    'in_array' => 'The :attribute field does not exist in :other.',
    'integer' => 'L\':attribute doit être un entier.',
    'ip' => 'L\':attribute doit être une adresse IP valide.',
    'ipv4' => 'L\':attribute doit être une adresse IPv4 valide.',
    'ipv6' => 'L\':attribute doit être une adresse IPv6 valide.',
    'json' => 'L\':attribute doit être une chaîne JSON valide.',
    'lt' => [
        'numeric' => 'L\':attribute doit être inférieur à: value.',
        'file' => 'L\':attribute doit être inférieur à: value en kilo-octets.',
        'string' => 'L\':attribute doit être inférieur à les caractères de: value.',
        'array' => 'L\':attribute doit avoir moins de éléments de: value.',
    ],
    'lte' => [
        'numeric' => 'L\':attribute doit être inférieur ou égal à: value.',
        'file' => 'L\':attribute doit être inférieur ou égal à: value kilo-octets.',
        'string' => 'L\':attribute doit être inférieur ou égal à caractères de value.',
        'array' => 'L\':attribute ne doit pas avoir plus de éléments de: value.',
    ],
    'max' => [
        'numeric' => 'L\':attribute ne doit pas être supérieur à: max.',
        'file' => 'L\':attribute ne doit pas être supérieur à kilo-octets: max.',
        'string' => 'L\':attribute ne doit pas être supérieur à caractères: max.',
        'array' => 'L\':attribute ne peut pas avoir plus de: max éléments.',
    ],
    'mimes' => 'L\':attribute doit être un fichier de type:: values.',
    'mimetypes' => 'L\':attribute doit être un fichier de type:: values.',
    'min' => [
        'numeric' => 'L\':attribute doit être au moins: min.',
        'file' => 'L\':attribute doit être d\'au moins: min kilo-octets.',
        'string' => 'L\':attribute doit contenir au moins: min caractères.',
        'array' => 'L\':attribute doit avoir au moins: min éléments.',
    ],
    'not_in' => 'L\':attribute sélectionné n\'est pas valide.',
    'not_regex' => 'Le format d\':attribute n\'est pas valide.',
    'numeric' => 'L\':attribute doit être un nombre.',
    'password' => 'Le mot de passe est incorrect.',
    'present' => 'Le champ d\':attribute doit être présent.',
    'regex' => 'The :attribute format is invalid.',
    'required' => 'Le champ d\':attribute est obligatoire.',
    'required_if' => 'Le champ: :attribute est obligatoire lorsque :other est: value.',
    'required_unless' => 'Le champ: :attribute est obligatoire sauf si :other est dans: values.',
    'required_with' => 'Le champ: :attribute est obligatoire lorsque :values est présent.',
    'required_with_all' => 'Le champ: :attribute est obligatoire lorsque: des :values sont présentes.',
    'required_without' => 'Le champ: :attribute est obligatoire lorsque :values n\'est pas présent.',
    'required_without_all' => 'Le champ d\':attribute est obligatoire lorsqu\'aucune des: values n\'est présente.',
    'same' => 'L\':attribute et :other doivent correspondre.',
    'size' => [
        'numeric' => 'L\':attribute doit être: size.',
        'file' => 'L\':attribute doit être: size kilo-octets.',
        'string' => 'L\':attribute doit être caractères de: size.',
        'array' => 'L\':attribute doit contenir des éléments de: size.',
    ],
    'starts_with' => 'L\':attribute doit commencer par l\'une des valeurs suivantes:: values.',
    'string' => 'L\':attribute doit être une chaîne.',
    'timezone' => 'L\':attribute doit être une zone valide.',
    'unique' => 'L\':attribute a déjà été pris.',
    'uploaded' => 'L\':attribute n\'a pas pu être téléchargé.',
    'url' => 'Le format d\':attribute n\'est pas valide.',
    'uuid' => 'L\':attribute doit être un UUID valide.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'message personnalisé',
        ],

        //doctor opd charge keys
        'doctor_id' => [
            'unique' => 'Le nom du médecin a déjà été pris.',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'email' => __('messages.user.email'),
        'last_name' => __('messages.user.last_name'),
        'first_name' => __('messages.user.first_name'),
        'password' => __('messages.department'),
        'gender' => __('messages.user.gender'),
        'city' => __('messages.user.city'),
        'zip' => __('messages.user.zip'),
        'name' => __('messages.common.name'),
        'status' => __('messages.account.status'),
        'description' => __('messages.account.description'),
        'patient_id' => __('messages.invoice.patient_id'),
        'receipt_no' => __('messages.advanced_payment.receipt_no'),
        'amount' => __('messages.advanced_payment.amount'),
        'date' => __('messages.advanced_payment.date'),
        'vehicle_number' => __('messages.ambulance.vehicle_number'),
        'vehicle_model' => __('messages.ambulance.vehicle_model'),
        'driver_contact' => __('messages.ambulance.driver_contact'),
        'year_made' => __('messages.ambulance.year_made'),
        'driver_license' => __('messages.ambulance.driver_license'),
        'doctor_id' => __('messages.ipd_patient.doctor_id'),
        'opd_date' => __('messages.appointment.opd_date'),
        'bed_type' => __('messages.bed.bed_type'),
        'charge' => __('messages.bed.charge'),
        'bed_id' => __('messages.bed.bed_id'),
        'case_id' => __('messages.bed_assign.case_id'),
        'assign_date' => __('messages.bed_assign.assign_date'),
        'discharge_date' => __('messages.bed_assign.discharge_date'),
        'title' => __('messages.document.title'),
        'bill_date' => __('messages.bill.bill_date'),
        'qty' => __('messages.bill.qty'),
        'price' => __('messages.bill.price'),
        'blood_group' => __('messages.user.blood_group'),
        'remained_bags' => __('messages.hospital_blood_bank.remained_bags'),
        'bags' => __('messages.blood_donation.bags'),
        'last_donate_date' => __('messages.blood_donation.last_donate_date'),
        'issue_date' => __('messages.blood_issue.issue_date'),
        'remarks' => __('messages.blood_issue.remarks'),
        'charge_type' => __('messages.charge_category.charge_type'),
        'code' => __('messages.charge.code'),
        'standard_charge' => __('messages.charge.standard_charge'),
        'currency_name' => __('messages.currency.currency_name'),
        'currency_code' => __('messages.currency.currency_code'),
        'currency_icon' => __('messages.currency.currency_icon'),
        'sr_no' => __('messages.employee_payroll.sr_no'),
        'payroll_id' => __('messages.employee_payroll.payroll_id'),
        'type' => __('messages.account.type'),
        'month' => __('messages.employee_payroll.month'),
        'year' => __('messages.employee_payroll.year'),
        'net_salary' => __('messages.employee_payroll.net_salary'),
        'basic_salary' => __('messages.employee_payroll.basic_salary'),
        'message' => __('messages.enquiry.message'),
        'expense_head' => __('messages.expense.expense_head'),
        'invoice_number' => __('messages.expense.invoice_number'),
        'short_description' => __('messages.short_description'),
        'about_us_title' => __('messages.front_setting.about_us_title'),
        'about_us_mission' => __('messages.front_setting.about_us_mission'),
        'about_us_image' => __('messages.front_setting.about_us_image'),
        'income_head' => __('messages.incomes.income_head'),
        'service_tax' => __('messages.insurance.service_tax'),
        'insurance_no' => __('messages.insurance.insurance_no'),
        'insurance_code' => __('messages.insurance.insurance_code'),
        'discount' => __('messages.insurance.discount'),
        'disease_name' => __('messages.insurance.diseases_name'),
        'disease_charge' => __('messages.insurance.diseases_charge'),
        'invoice_date' => __('messages.invoice.invoice_date'),
        'quantity' => __('messages.service.quantity'),
        'total_payments' => __('messages.dashboard.total_payments'),
        'gross_total' => __('messages.ipd_bill.gross_total'),
        'discount_in_percentage' => __('messages.ipd_bill.discount_in_percentage'),
        'tax_in_percentage' => __('messages.ipd_bill.tax_in_percentage'),
        'other_charges' => __('messages.ipd_bill.other_charges'),
        'net_payable_amount' => __('messages.ipd_bill.net_payable_amount'),
        'charge_type_id' => __('messages.ipd_patient_charges.charge_type_id'),
        'charge_category_id' => __('messages.ipd_patient_charges.charge_category_id'),
        'charge_id' => __('messages.ipd_patient_charges.charge_id'),
        'applied_charge' => __('messages.ipd_patient_charges.applied_charge'),
        'instruction' => __('messages.ipd_patient_consultant_register.instruction'),
        'instruction_date' => __('messages.ipd_patient_consultant_register.instruction_date'),
        'report_type' => __('messages.ipd_patient_diagnosis.report_type'),
        'report_date' => __('messages.ipd_patient_diagnosis.report_date'),
        'bed_type_id' => __('messages.ipd_patient.bed_type_id'),
        'weight' => __('messages.ipd_patient.weight'),
        'height' => __('messages.ipd_patient.height'),
        'bp' => __('messages.ipd_patient.bp'),
        'payment_mode' => __('messages.ipd_payments.payment_mode'),
        'notes' => __('messages.document.notes'),
        'category_id' => __('messages.ipd_patient_prescription.category_id'),
        'issued_by' => __('messages.issued_item.issued_by'),
        'issued_date' => __('messages.issued_item.issued_date'),
        'return_date' => __('messages.issued_item.return_date'),
        'unit' => __('messages.item.unit'),
        'consultation_title' => __('messages.live_consultation.consultation_title'),
        'consultation_date' => __('messages.live_consultation.consultation_date'),
        'consultation_duration_minutes' => __('messages.live_consultation.consultation_duration_minutes'),
        'type_number' => __('messages.live_consultation.type_number'),
        'to' => __('messages.common.to'),
        'subject' => __('messages.email.subject'),
        'selling_price' => __('messages.medicine.selling_price'),
        'buying_price' => __('messages.medicine.buying_price'),
        'side_effects' => __('messages.medicine.side_effects'),
        'salt_composition' => __('messages.medicine.salt_composition'),
        'appointment_date' => __('messages.opd_patient.appointment_date'),
        'rate' => __('messages.package.rate'),
        'test_name' => __('messages.radiology_test.test_name'),
        'short_name' => __('messages.radiology_test.short_name'),
        'test_type' => __('messages.radiology_test.test_type'),
        'policy_no' => __('messages.patient_admission.policy_no'),
        'fee' => __('messages.case.fee'),
        'payment_date' => __('messages.payment.payment_date'),
        'pay_to' => __('messages.payment.pay_to'),
        'from_title' => __('messages.postal.from_title'),
        'to_title' => __('messages.postal.to_title'),
        'reference_no' => __('messages.postal.reference_no'),
        'subcategory' => __('messages.radiology_test.subcategory'),
        'available_on' => __('messages.schedule.available_on'),
        'available_from' => __('messages.schedule.available_from'),
        'available_to' => __('messages.schedule.available_to'),
        'per_patient_time' => __('messages.schedule.per_patient_time'),
        'app_name' => __('messages.setting.app_name'),
        'company_name' => __('messages.setting.company_name'),
        'favicon' => __('messages.setting.favicon'),
        'zoom_api_key' => __('messages.live_consultation.zoom_api_key'),
        'zoom_api_secret' => __('messages.live_consultation.zoom_api_secret'),
        'dose_given_date' => __('messages.vaccinated_patient.dose_given_date'),
        'manufactured_by' => __('messages.vaccination.manufactured_by'),
        'brand' => __('messages.vaccination.brand'),
        'purpose' => __('messages.visitor.purpose'),
        'no_of_person' => __('messages.visitor.number_of_person'),
        'in_time' => __('messages.visitor.in_time'),
        'out_time' => __('messages.visitor.out_time'),
        'field_name' => __('messages.custom_field.field_name')
    ],

];
