<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - French Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin' => 'Administratrices',
    'admins' => 'Administratrice',
    'roles' => 'Rôles',
    'doctor_departments' => 'Départements de médecins',
    'nurses' => 'Infirmières',
    'operations' => 'Opérations',
    'doctors' => 'Médecins',
    'patients' => 'Les patients',
    'lab_technicians' => 'Techniciens de laboratoire',
    'receptionists' => 'Réceptionnistes',
    'pharmacists' => 'Pharmaciennes',
    'accountants' => 'Comptables',
    'appointments' => 'Rendez-vous',
    'insurances' => 'Assurances',
    'investigation_reports' => 'Rapports d\'enquête',
    'death_reports' => 'Rapports de décès',
    'birth_reports' => 'Rapports de naissance',
    'operation_reports' => 'Rapports d\'opération',
    'medicine_categories' => 'Catégories de médecine',
    'medicine_brands' => 'Marques de médicaments',
    'medicines' => 'Médicaments',
    'cases' => 'Étuis',
    'case_handlers' => 'Gestionnaires de cas',
    'bed_types' => 'Types de lits',
    'beds' => 'Des lits',
    'bed_assigns' => 'Attributions de lit',
    'packages' => 'Paquets',
    'schedules' => 'Des horaires',
    'schedule_label' => 'Horaire',
    'services' => 'Prestations de service',
    'accounts' => 'Comptes',
    'payments' => 'Paiements',
    'bills' => 'Factures',
    'employee_payrolls' => 'Paie des employés',
    'documents' => 'Les documents',
    'document_types' => 'Types de documents',
    'notice_boards' => 'Tableaux d\'affichage',
    'settings' => 'Réglages',
    'doctors_list' => 'Liste des médecins',
    'my_payrolls' => 'Mes livres de paie',
    'blood_banks' => 'Banques de sang',
    'blood_donors' => 'Donneurs de sang',
    'invoices' => 'Factures',
    'patients_cases' => 'Cas de patients',
    'patients_case_details' => 'Détails du cas des patients',
    'account_manager' => 'Gestionnaire de compte',
    'bed_management' => 'Gestion des lits',
    'blood_bank' => 'Banque du sang',
    'billing' => 'Facturation',
    'case_manager' => 'Chargé de dossiers',
    'cms' => 'CMS',
    'department' => 'département',
    'departments' => 'Départements',
    'hospital_activities' => 'Activités hospitalières',
    'advanced_payments' => 'Paiements avancés',
    'patient_admissions' => 'Admissions des patients',
    'appointment_calendar' => 'Nommer. Calendrier',
    'bed_mgt' => 'Bed Management',
    'reports' => 'Rapports',
    'enquiries' => 'Demandes',
    'mail' => 'Courrier',
    'ambulances' => 'ambulances',
    'ambulance_calls' => 'Appels d\'ambulance',
    'prescriptions' => 'Prescriptions',
    'hospital_charges' => 'Frais d\'hospitalisation',
    'charge_categories' => 'Catégories de frais',
    'charges' => 'Des charges',
    'radiologies' => 'Radiologie',
    'radiology_categories' => 'Radiologie Catégorie',
    'pathologies' => 'Pathologie',
    'pathology_categories' => 'Pathologie Catégorie',
    'radiology_tests' => 'Radiologie Les tests',
    'doctor_opd_charges' => 'Frais du médecin OPD',
    'pathology_tests' => 'Pathologie Les tests',
    'expenses' => 'Dépenses',
    'income' => 'Le revenu',
    'finance' => 'La finance',
    'inventory' => 'Inventaire',
    'items_categories' => 'Catégories d\'articles',
    'items' => 'Items',
    'items_stocks' => 'Stocks d\'articles',
    'issued_items' => 'Articles émis',
    'ipd_patients' => 'Patients IPD',
    'ipd_opd' => 'IPD/OPD',
    'ipd_diagnosis' => 'Diagnostic',
    'ipd_consultant_register' => 'Instruction du consultant',
    'ipd_consultant_doctor' => 'Médecin consultant',
    'ipd_charges' => 'Des charges',
    'ipd_prescription' => 'Les ordonnances',
    'ipd_timelines' => 'Délais',
    'ipd_payment' => 'Paiement IPD',
    'opd_patients' => 'OPD Patients',
    'opd_diagnosis' => 'Diagnostic OPD',
    'opd_timeline' => 'Chronologie OPD',
    'call_logs' => 'Journaux d appels',
    'visitors' => 'Visiteuses',
    'front_office' => 'Bureau d`accueil',
    'postal_receive' => 'Réception postale',
    'postal_dispatch' => 'Envoi postal',
    'general' => 'Générale',
    'sidebar_setting' => 'Paramètres des modules',
    'currency_setting' => 'Devises',
    'testimonials' => 'Témoignages',
    'blood_donations' => 'Don de sang',
    'blood_issues' => 'Problèmes de sang',
    'live_consultations' => 'Consultations en direct',
    'vaccinations' => 'Les vaccinations',
    'vaccinated_patients' => 'Patients vaccinés',
    'users' => 'Utilisateurs',
    'front_settings' => 'Paramètres avant',
    'front_service' => 'Service avant',
    'about_us' => 'À propos de nous',
    'make_an_appointment' => 'Prendre rendez-vous',
    'patient_appointment' => 'Rendez-vous patient',
    'old_patient' => 'Ancien patient',
    'new_patient' => 'Nouveau Patient',
    'available_slot' => 'Slot disponible',
    'contact_us' => 'Contactez-nous',
    'live_meetings' => 'Réunions en direct',
    'live_meeting' => 'Réunion en direct',
    'hospital_schedule' => 'Horaire de l\'hôpital',
    'front_cms' => 'Cm avant',
    'front_cms_services' => 'Services CMS avant',
    'facebook_url' => 'L\'adresse URL de Facebook',
    'twitter_url' => 'URL Twitter',
    'instagram_url' => 'URL Instagram',
    'linkedIn_url' => 'URL Linkedin',
    'allow_file_type' => 'Types de fichiers autorisés : png, jpg, jpeg.',
    'overview' => 'Aperçu',
    'no_data_available' => 'aucune donnée disponible',
    'file_name' => 'Nom de fichier',
    'icon' => 'Icône',
    'short_description' => 'brève description',
    'valid' => 'Valide',
    'no_matching_records_found' => 'Aucun enregistrements correspondants trouvés',
    'select_applied_date' => 'Veuillez sélectionner la date d\'application',
    'select_instruction_date' => 'Veuillez sélectionner la date de l\'enseignement',
    'report' => 'rapport',
    'report_id' => 'ID du rapport',
    'yearly_income_expense_chart' => 'Tableau des revenus et dépenses annuels',
    'sms_mail' => 'SMS/Mail',
    'payment_gateways' => 'Passerelles de paiement',
    'stripe_key' => 'Clé Stripe',
    'stripe_secret' => 'Secret Stripe',
    'paypal' => 'PayPal',
    'paypal_client_id' => 'Identifiant client PayPal',
    'paypal_secret' => 'Secret PayPal',
    'paypal_mode' => 'Mode PayPal',
    'razorpay' => 'Razorpay',
    'razorpay_key' => 'Clé Razorpay',
    'razorpay_secret' => 'Secret Razorpay',
    'cash' => 'Espèces',
    'cheque' => 'Vérifier',
    'flutterwave' => 'Onde Flutter',
    'flutterwave_public_key' => 'Clé publique Flutterwave',
    'flutterwave_secret_key' => 'Clé secrète Flutterwave',
    'phonepe' => 'Téléphone Pe',
    'paystack' => 'Pile de paie',
    'paystack_public_key' => 'Clé publique de la pile de paie',
    'paystack_secret_key' => 'Clé secrète de la pile de paie',
    'phonepe_merchant_id' => 'Identifiant du commerçant Phonepe',
    'phonepe_merchant_user_id' => 'Identifiant d\'utilisateur du commerçant Phonepe',
    'phonepe_env' => 'Phonepé Env',
    'phonepe_salt_key' => 'Clé de sel de Phonepe',
    'phonepe_salt_index' => 'Indice de sel de Phonepe',
    'phonepe_merchant_transaction_id' => 'Identifiant de transaction du marchand Phonepe',

    'language' => [
        'Arabic' => 'arabe',
        'Chinese' => 'Chinois',
        'English' => 'Anglais',
        'French' => 'Français',
        'German' => 'Allemand',
        'Portuguese' => 'Portugais',
        'Russian' => 'russe',
        'Spanish' => 'Espagnol',
        'Turkish' => 'turc',
    ],

    //roles
    'role' => [
        'new_role' => 'Nouveau rôle',
        'edit_role' => 'Modifier le rôle',
        'select_role' => 'Sélectionnez un rôle',
    ],

    //user keys
    'user' => [
        'user' => 'Utilisatrice',
        'first_name' => 'Prénom',
        'last_name' => 'Nom de famille',
        'name' => 'Nom',
        'email' => 'E-mail',
        'phone' => 'Téléphone',
        'designation' => 'La désignation',
        'gender' => 'Le sexe',
        'male' => 'Mâle',
        'female' => 'Femme',
        'qualification' => 'Qualification',
        'dob' => 'Date de naissance',
        'blood_group' => 'Groupe sanguin',
        'select_blood_group' => 'Sélectionnez le groupe sanguin',
        'password' => 'Mot de passe',
        'password_confirmation' => 'Confirmez le mot de passe',
        'address1' => 'Adresse 1',
        'address2' => 'Adresse 2',
        'city' => 'Ville',
        'zip' => 'Zip *: français',
        'address_details' => 'Détails de l\'adresse',
        'address_not_found' => 'Aucune adresse n\'a été trouvée',
        'education' => 'Éducation',
        'status' => 'Statut',
        'edit_profile' => 'Editer le profil',
        'change_password' => 'Changer le mot de passe',
        'logout' => 'Se déconnecter',
        'new_user' => 'Nouvel utilisateur',
        'edit_user' => 'Modifier l`utilisateur',
        'user_details' => 'Détails de l\'utilisateur',
        'email_verified_successfully' => 'Courriel vérifié avec succès.',
        'invalid_password' => 'Le mot de passe actuel est invalide.',
        'validate_confirm_password' => 'Le mot de passe et le mot de passe de confirmation doivent correspondre.',
        'validate_min_character_password' => 'Le mot de passe doit contenir au moins 6 caractères.',
        'validate_image_type' => 'La imagen debe ser un archivo de tipo: jpg, jpeg o png.',
        'validate_image_size' => 'El documento debe tener menos de 10 MB de tamaño.',
        'validate_facebook_url' => 'Por favor, ingrese una URL de Facebook válida.',
        'validate_twitter_url' => 'Por favor, ingrese una URL de Twitter válida.',
        'validate_instagram_url' => 'Por favor, ingrese una URL de Instagram válida.',
        'validate_linkedin_url' => 'Por favor, ingrese una URL de Linkedin válida.',
        'user_list' => 'Lista de Usuarios',
        'phone_number_must_be_10_digits' => 'Le numéro de téléphone doit comporter 10 chiffres',
        'valid_email' => 'Veuillez entrer une adresse e-mail valide',
    ],

    //common keys
    'common' => [
        'field_required' => 'Champ requis.',
        'change' => 'Changement',
        'change_profile' => 'Changer l\'image',
        'is' => 'Est',
        'available_quantity_of' => 'La quantité disponible de',
        'result' => 'Résultat',
        'profile' => 'Profil',
        'status' => 'Statut',
        'action' => 'action',
        'save' => 'sauvegarder',
        'cancel' => 'Annuler',
        'canceled' => 'annulé',
        'back' => 'Retour',
        'created_on' => 'Créé sur',
        'last_updated' => 'Dernière mise à jour',
        'n/a' => 'N / A',
        'new' => 'Nouvelle',
        'total' => 'Totale',
        'add' => 'Ajouter',
        'active' => 'Active',
        'name' => 'Nom',
        'edit' => 'Éditer',
        'detail' => 'détails',
        'delete' => 'Supprimer',
        'view' => 'Vue',
        'view_attachment' => 'Afficher la pièce jointe',
        'de_active' => 'Désactivé',
        'description' => 'La description',
        'created_at' => 'Créé sur',
        'updated_at' => 'Dernière mise à jour',
        'is_available' => 'Est disponible',
        'choose' => 'Choisir',
        'yes' => 'Oui',
        'no' => 'Non',
        'address' => 'Adresse',
        'export_to_excel' => 'Exporter vers Excel',
        'reset' => 'Réinitialiser',
        'actions' => 'Actions',
        'confirm' => 'Confirmer',
        'search' => 'Chercher',
        'status_updated_successfully' => 'Statut mis à jour avec succès.',
        'saved_successfully' => 'enregistré avec succès.',
        'updated_successfully' => 'Mis à jour avec succés',
        'deleted_successfully' => 'Supprimé avec succès',
        'filter_options' => 'Options de filtrage',
        'are_you_sure_want_to_delete_this' => 'Voulez-vous vraiment supprimer ce ',
        'deleted' => 'Supprimé',
        'has_been_deleted' => 'a été supprimé.',
        'cant_be_deleted' => 'ne peut pas être supprimé',
        'custom' => 'Personnalisé',
        'apply' => 'appliquer',
        'from' => 'de',
        'to' => 'À',
        'invalid_number' => 'Numéro invalide',
        'invalid_country_code' => 'Code pays invalide',
        'too_short' => 'Trop court',
        'too_long' => 'Trop long',
        'not_found' => 'pas trouvé',
        'previous' => 'Précédent',
        'next' => 'Prochain',
        'ok' => 'D\'accord',
        'this_action_is_not_allowed_for_default_record' => 'Cette action n\'est pas autorisée pour l\'enregistrement par défaut.',
        'show' => 'Montrer',
        'something_wen_wrong' => 'Quelque chose s\'est mal passé',
        'cancelled_successfully' => 'Annulation réussie',
        'invalid_username_password' => 'Nom d\'utilisateur ou mot de passe incorrect',
        'logged_in_successfully' => 'Connexion réussie',
        'logout_successfully' => 'Déconnexion réussie',
        'we_cant_find_user' => 'Nous ne pouvons pas trouver d\'utilisateur avec cette adresse e-mail',
        'we_have_your_password_resetk_link' => 'Nous avons envoyé le lien de réinitialisation de votre mot de passe par e-mail !',
        'this_password_reset_token_is_invalid' => 'Ce jeton de réinitialisation de mot de passe n\'est pas valide',
        'password_reset_successfully' => 'Réinitialisation du mot de passe réussie',
        'please_enter_correct_old_password' => 'Veuillez entrer le bon ancien mot de passe',
        'password_updated' => 'Mot de passe mis à jour',
        'doctor_scheduled' => 'Docteur programmé',
        'not_updated' => 'Non mis à jour',
        'patient_registered_successfully' => 'Patient enregistré avec succès',
        'appointment_confirmed_successfully' => 'Rendez-vous confirmé avec succès',
        'bed_assigned_successfully' => 'Lit attribué avec succès',
        'username_and_password_required' => 'Nom d\'utilisateur et mot de passe requis',
        'meeting_finished_or_cancelled' => 'Cette réunion est terminée ou annulée',
        'alreay_exists' => 'Existe déjà.',
        'appointment_transaction' => 'Transaction de rendez-vous'
    ],

    'hospital_schedules' => [
        'exists_doctor_schedule' => 'Certains médecins ont programmé leurs journées en jours donnés non cochés, alors êtes-vous sûr de vouloir effectuer cette opération ?',
        'schedule_not_available' => 'Aktuell kann der Benutzer keinen Krankenhausplan erstellen, wenn der Krankenhausplan nicht verfügbar ist.',
        'this_day_hospital_is_closed' => 'An diesem Tag ist das Krankenhaus geschlossen.',
    ],

    'months' => [
        'jan' => 'Janvier',
        'feb' => 'Février',
        'mar' => 'Mars',
        'apr' => 'Avril',
        'may' => 'Peut',
        'jun' => 'Juin',
        'july' => 'Juillet',
        'aug' => 'Août',
        'sep' => 'Septembre',
        'oct' => 'Octobre',
        'nov' => 'Novembre',
        'dec' => 'Décembre',
    ],

    'weekdays' => [
        'sun' => 'SOLEIL',
        'mon' => 'LUN',
        'tue' => 'MAR',
        'wed' => 'ÉPOUSER',
        'thu' => 'JEU',
        'fri' => 'VEN',
        'sat' => 'ASSISE',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'Réceptionniste',
        'receptionists' => 'Réceptionnistes',
        'receptionist_details' => 'Détails de la réceptionniste',
        'new_receptionist' => 'Nouveau réceptionniste',
        'edit_receptionist' => 'Modifier la réceptionniste',
        'profile_must_be_image' => 'L\'image de profil doit être une image',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'Assurance',
        'insurances' => 'Assurances',
        'insurance_details' => 'Détails de l\'assurance',
        'new_insurance' => 'Nouvelle assurance',
        'edit_insurance' => 'Modifier l\'assurance',
        'service_tax' => 'Taxe de service',
        'insurance_no' => 'Numéro d\'assurance',
        'insurance_code' => 'Code d\'assurance',
        'hospital_rate' => 'Taux d\'hospitalisation',
        'discount' => 'Remise',
        'remark' => 'Remarque',
        'disease_details' => 'Détails de la maladie',
        'diseases_name' => 'Maladies Nom',
        'diseases_charge' => 'Maladie facturer',
        'total_amount' => 'Montant total',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'Départements de médecins',
        'doctor_department' => 'Département de docteur',
        'doctor_department_details' => 'Détails du service de médecin',
        'new_doctor_department' => 'Nouveau département de docteur',
        'edit_doctor_department' => 'Modifier le département de médecin',
        'title' => 'Titre',
        'description' => 'La description',
        'doctor_field_required' => 'Le champ Médecin est obligatoire'
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'Rapports d\'enquête',
        'investigation_report' => 'Rapport d\'investigation',
        'new_investigation_report' => 'Nouveau rapport d\'enquête',
        'investigation_report_details' => 'Détails du rapport d\'enquête',
        'edit_investigation_report' => 'Modifier le rapport d\'enquête',
        'patient' => 'Patiente',
        'date' => 'Date',
        'title' => 'Titre',
        'doctor' => 'Médecin',
        'description' => 'La description',
        'attachment' => 'Attachement',
        'birth_date_validation' => 'La date du rapport d\'investigation ne doit pas être inférieure à la date de naissance du patient.',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'Nouveau pharmacien',
        'edit_pharmacist' => 'Modifier le pharmacien',
        'pharmacists' => 'Pharmaciennes',
        'pharmacist_details' => 'Détails du pharmacien',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'Rapport de décès',
        'death_reports' => 'Rapports de décès',
        'new_death_report' => 'Nouveau rapport de décès',
        'edit_death_report' => 'Modifier le rapport de décès',
        'death_report_details' => 'Détails du rapport de décès',
        'patient_name' => 'Nom du patient',
        'case_id' => 'Identifiant de cas',
        'doctor_name' => 'Nom du docteur',
        'date' => 'Date',
        'description' => 'La description',
        'cant_create_report_because_the_patient_has_been_dead' => 'Bericht kann nicht erstellt werden, da der Patient verstorben ist.',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Datum darf nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'Rapport de naissance',
        'birth_reports' => 'Rapports de naissance',
        'birth_report_details' => 'Détails du rapport de naissance',
        'new_birth_report' => 'Nouveau rapport de naissance',
        'edit_birth_report' => 'Modifier le rapport de naissance',
        'patient_name' => 'Nom du patient',
        'case_id' => 'Identifiant de cas',
        'doctor_name' => 'Nom du docteur',
        'date' => 'Date',
        'description' => 'La description',
        'data_should_not_be_smaller_than_patient_birth_date' => 'La date ne doit pas être inférieure à la date de naissance du patient.',
        'patient_birth_date_not_found' => 'Date de naissance du patient introuvable.',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'Nouveau comptable',
        'edit_accountant' => 'Modifier le comptable',
        'accountants' => 'Comptables',
        'accountant_details' => 'Détails du comptable',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'Paie des employés',
        'employee_payrolls' => 'Paie des employés',
        'employee_payroll_details' => 'Détails de la paie des employés',
        'new_employee_payroll' => 'Paie des nouveaux employés',
        'edit_employee_payroll' => 'Modifier la paie des employés',
        'sr_no' => 'Sr Non',
        'payroll_id' => 'Identifiant de paie',
        'month' => 'Mois',
        'year' => 'Année',
        'role' => 'Rôle',
        'employee' => 'Employée',
        'basic_salary' => 'Salaire de base',
        'allowance' => 'Allocation',
        'deductions' => 'Déductions',
        'net_salary' => 'Salaire net',
        'paid' => 'Payé',
        'not_paid' => 'Non payé',
        'employee_name' => 'Nom de l\'employé',
        'employees_list_not_found' => 'Mitarbeiterliste nicht gefunden',
        'employee_payroll_deduction' => 'Abzüge dürfen nicht größer sein als Grundgehalt + Zulage',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'Rapport d\'opération',
        'operation_reports' => 'Rapports d\'opération',
        'operation_report_details' => 'Détails du rapport d\'opération',
        'new_operation_report' => 'Nouveau rapport d\'opération',
        'edit_operation_report' => 'Modifier le rapport d\'opération',
        'patient_name' => 'Nom du patient',
        'case_id' => 'Identifiant de cas',
        'doctor_name' => 'Nom du docteur',
        'date' => 'Date',
        'description' => 'La description',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Das Datum darf nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    // accounts keys
    'account' => [
        'account' => 'Compte',
        'accounts' => 'Comptes',
        'account_details' => 'Détails du compte',
        'new_account' => 'Nouveau compte',
        'edit_account' => 'Modifier le compte',
        'name' => 'Nom',
        'description' => 'La description',
        'type' => 'Type',
        'status' => 'Statut',
        'payments' => 'Paiements',
        'credit' => 'Le crédit',
        'debit' => 'Débit',
    ],

    // invoices keys
    'invoice' => [
        'invoice_id' => 'Identifiant de facture',
        'invoice' => 'Facture d\'achat',
        'invoices' => 'Factures',
        'invoice_details' => 'Détails de la facture',
        'new_invoice' => 'Nouvelle facture',
        'edit_invoice' => 'Modifier la facture',
        'patient' => 'Patiente',
        'invoice_date' => 'Date de facturation',
        'amount' => 'Montante',
        'patient_id' => 'ID patient',
        'discount' => 'Remise',
        'account_name' => 'Nom du compte',
        'description' => 'La description',
        'qty' => 'Qté',
        'price' => 'Prix',
        'add' => 'Ajouter',
        'sub_total' => 'Sous-total',
        'total' => 'Montant total',
        'edit' => 'Éditer',
        'hospital_address' => 'Adresse de l\'hôpital',
        'paid' => 'Payé',
        'not_paid' => 'Impayé',
        'print_invoice' => 'Imprimer la facture',
        'invoice_date_field_required' => 'Le champ date de facture est obligatoire',
        'issue_for' => 'Problème pour',
        'issue_from' => 'Problème à partir de',
        'patient_overview' => 'APERÇU DES PATIENTS',
        'in_percentage' => 'En pourcentage',
    ],

    //nurses
    'nurse' => [
        'nurse' => 'Infirmière',
        'new_nurse' => 'Nouvelle infirmière',
        'edit_nurse' => 'Modifier l\'infirmière',
        'nurse_details' => 'Détails sur l\'infirmière',
        'phone_no' => 'Pas de téléphone',
        'birth_date' => 'Date de naissance',
        'choose' => 'Choisir',
    ],

    //patient
    'patient' => [
        'new_patient' => 'Nouveau patient',
        'edit_patient' => 'Modifier le patient',
        'patient_details' => 'Détails du patient',
        'total_cases' => 'Nombre total de cas',
        'total_admissions' => 'Admissions totales',
        'total_appointments' => 'Nombre total de rendez-vous',
        'select_one_patient' => 'Veuillez sélectionner au moins un patient',
        'patient_name_already_taken' => 'Le nom du patient a déjà été pris',
        'patient_field_required' => 'Le champ patient est obligatoire',
    ],

    // payments keys
    'payment' => [
        'payment' => 'Paiement',
        'payments' => 'Paiements',
        'payment_details' => 'Détails de paiement',
        'new_payment' => 'Nouveau paiement',
        'edit_payment' => 'Modifier le paiement',
        'account_name' => 'Nom du compte',
        'payment_date' => 'Date de paiement',
        'pay_to' => 'Payer pour',
        'amount' => 'Montante',
        'account' => 'Compte',
        'description' => 'La description',
        'payment_reports' => 'Rapports de paiement',
        'your_payment_is_successfully_completed' => 'Ihre Zahlung wurde erfolgreich abgeschlossen.',
        'payment_failed' => 'Entschuldigung! Die Zahlung ist fehlgeschlagen. Bitte versuchen Sie es später erneut.',
        'flutterwave_not_support' => 'Flutterwave ne prend pas en charge cette devise.',
        'phonepe_support_inr' => 'PhonePe ne prend en charge que la devise INR.',
        'paystack_support_zar' => 'Paystack ne prend en charge que la devise "USD","GHS","NGN","ZAR","KES".',
        'paystack_token_expired' => 'Le jeton de paie a expiré. Veuillez actualiser la page et réessayer.',
        'currency_not_supported_paypal' => 'Cette devise n\'est pas prise en charge par PayPal pour effectuer des paiements.',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'Acompte',
        'advanced_payments' => 'Paiements avancés',
        'advanced_payment_details' => 'Détails du paiement anticipé',
        'new_advanced_payment' => 'Nouveau paiement anticipé',
        'edit_advanced_payment' => 'Modifier le paiement anticipé',
        'patient' => 'Patiente',
        'receipt_no' => 'Aucun reçu',
        'amount' => 'Montante',
        'date' => 'Date',
        'patient_name' => 'Nom du patient',
    ],

    // beds keys
    'bed' => [
        'bed' => 'Nouveau lit',
        'beds' => 'Des lits',
        'bed_details' => 'Détails du lit',
        'new_bed' => 'Nouveau lit',
        'edit_bed' => 'Modifier le lit',
        'new_bulk_bed' => 'Nouveau lit en vrac',
        'name' => 'Nom',
        'bed_type' => 'Type de lit',
        'charge' => 'Charger',
        'available' => 'Disponible',
        'not_available' => 'Indisponible',
        'description' => 'La description',
        'add' => 'Ajouter',
        'bed_id' => 'Identifiant du lit',
        'select_bed_type' => 'Sélectionnez le type de lit',
        'bed_charge' => 'Frais de lit',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'Type de lit',
        'bed_types' => 'Types de lits',
        'bed_type_details' => 'Détails sur le type de lit',
        'new_bed_type' => 'Nouveau type de lit',
        'edit_bed_type' => 'Modifier le type de lit',
        'title' => 'Titre',
        'description' => 'La description',
    ],

    'doctor' => [
        'new_doctor' => 'Nouveau docteur',
        'edit_doctor' => 'Modifier le docteur',
        'doctor_details' => 'Détails du médecin',
        'specialist' => 'Spécialiste',
        'doctor_name_already_taken' => 'Le nom du médecin a déjà été pris',
        'appointment_charge' => 'Frais de rendez-vous',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'Affectation de lit',
        'bed_assigns' => 'Attributions de lit',
        'bed_assign_details' => 'Détails d\'attribution de lit',
        'new_bed_assign' => 'Nouvelle affectation de lit',
        'edit_bed_assign' => 'Modifier l\'attribution de lit',
        'patient_name' => 'Nom du patient',
        'bed_name' => 'Nom du lit',
        'case_id' => 'Identifiant de cas',
        'assign_date' => 'Attribuer une date',
        'discharge_date' => 'Date de sortie',
        'bed' => 'Lit',
        'description' => 'La description',
        'assigned' => 'Attribué',
        'not_assigned' => 'Non attribué',
        'ipd_patient_id' => 'IPD Patiente Identifiant',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'La date d\'attribution ne doit pas être inférieure à la date de naissance du patient.',
        'ipd_patient_department_field_required' => 'Le champ Service patient IPD est obligatoire',
    ],

    // packages keys
    'package' => [
        'package' => 'Paquet',
        'packages' => 'Paquets',
        'package_details' => 'Détails du paquet',
        'new_package' => 'Nouveau package',
        'edit_package' => 'Modifier le package',
        'name' => 'Nom',
        'description' => 'La description',
        'discount' => 'Remise',
        'total_amount' => 'Montant total',
        'service' => 'Un service',
        'qty' => 'Qté',
        'rate' => 'Taux',
        'amount' => 'Montante',
        'select_service' => 'Sélectionnez le service',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'Imprimer la facture',
        'bill_id' => 'Id de facture',
        'bill' => 'Facture',
        'bills' => 'Factures',
        'bill_details' => 'Détails de la facture',
        'new_bill' => 'Nouveau projet de loi',
        'edit_bill' => 'Modifier la facture',
        'patient' => 'Patiente',
        'bill_date' => 'Date de facturation',
        'amount' => 'Montant',
        'admission_id' => 'ID d\'admission',
        'patient_name' => 'Nom du patient',
        'patient_email' => 'Courriel du patient',
        'patient_cell_no' => 'No de cellule patient',
        'patient_gender' => 'Sexe du patient',
        'patient_dob' => 'Patient DOB',
        'doctor_name' => 'Nom du docteur',
        'admission_date' => 'Date d\'admission',
        'discharge_date' => 'Date de sortie',
        'package_name' => 'Nom du paquet',
        'insurance_name' => 'Nom de l\'assurance',
        'total_days' => 'Nombre total de jours',
        'policy_no' => 'No de politique',
        'item_name' => 'Nom de l\'article',
        'qty' => 'Qté',
        'price' => 'Prix',
        'add' => 'Ajouter',
        'total_amount' => 'Montant total',
        'edit' => 'Modifier',
        'cell_no' => 'No de cellule',
        'bill_summary' => 'Résumé de la facture',
        'generate_bill' => 'Générer la facture',
        'update_bill' => 'Mettre à jour la facture',
        'calculate' => 'Calculer',
        'manual_bill' => 'Paiements par facturation manuelle',
        'transaction_date' => 'Date de la transaction',
        'paymentrequest_sent' => 'Demande de paiement envoyée avec succès',
        'manually' => 'Manuellement',
        'stripe' => 'Bande',
        'approved' => 'Approuvé',
        'rejected' => 'Rejeté',
        'are_you_sure' => 'Es-tu sûr?',
        'complete_this_payment' => 'Vous souhaitez effectuer ce paiement manuellement !!',
        'session_id_required' => 'Identifiant de session requis',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'Donateur de sang',
        'blood_donors' => 'Donateurs de sang',
        'blood_donor_details' => 'Détails sur le donneur de sang',
        'new_blood_donor' => 'Nouveau donneur de sang',
        'edit_blood_donor' => 'Modifier le donneur de sang',
        'name' => 'Nom',
        'age' => 'Âge',
        'gender' => 'Le sexe',
        'blood_group' => 'Groupe sanguin',
        'donation_date' => 'Date de don',
        'last_donation_date' => 'Dernière date de don',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'Banque du sang',
        'blood_banks' => 'Banques de sang',
        'blood_bank_details' => 'Détails de la banque de sang',
        'new_blood_group' => 'Nouveau groupe sanguin',
        'edit_blood_group' => 'Modifier le groupe sanguin',
        'blood_group' => 'Groupe sanguin',
        'remained_bags' => 'Sacs restant',
    ],

    //Case
    'case' => [
        'case' => 'Cas',
        'case_date' => 'Date du cas',
        'new_case' => 'Nouveau cas',
        'edit_case' => 'Modifier le cas',
        'case_details' => 'Détails du cas',
        'phone' => 'Téléphone',
        'fee' => 'Taxe',
        'patient' => 'Patiente',
        'doctor' => 'Médecin',
        'case_id' => 'Identifiant de cas',
        'date' => 'Date',
        'description' => 'La description',
        'case_date_should_not_be_smaller_than_patient_birth_date' => 'Das Datum des Falls darf nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    //services
    'service' => [
        'service' => 'Dienstleistung',
        'new_service' => 'Nouveau service',
        'edit_service' => 'Modifier le service',
        'service_details' => 'Détails du service',
        'quantity' => 'Quantité',
        'rate' => 'Taux',
        'given' => 'Donnée',
        'not_given' => 'Non donné',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'Nouveau rendez-vous',
        'edit_appointment' => 'Modifier le rendez-vous',
        'appointment_details' => 'Détails du rendez-vous',
        'calendar_view' => 'Affichage du calendrier',
        'patient_name' => 'Nom du patient',
        'doctor_name' => 'Nom du docteur',
        'department_name' => 'Nom du département',
        'date' => 'Date',
        'doctor_department' => 'Département de docteur',
        'doctor_department_name' => 'Nom du département de médecin',
        'doctor' => 'Médecin',
        'description' => 'La description',
        'patient' => 'Patiente',
        'appointment_calendar' => 'Calendrier des rendez-vous',
        'appointment_list' => 'Liste de rendez-vous',
        'completed' => 'Terminé',
        'pending' => 'En attente',
        'available_slot' => 'Emplacement disponible',
        'no_available' => 'Indisponible',
        'today' => 'Aujourd\'hui',
        'month' => 'Mois',
        'week' => 'Semaine',
        'day' => 'Jour',
        'opd_date' => 'Date de l\'opd',
        'yesterday' => 'Hier',
        'this_week' => 'Cette semaine',
        'last_7_days' => 'Les 7 derniers jours',
        'last_30_days' => 'Les 30 derniers jours',
        'this_month' => 'Ce mois-ci',
        'last_month' => 'Le mois dernier',
        'change_status' => 'Changer de statut',
        'are_you_sure_want_to_change' => 'Êtes-vous sûr de vouloir changer',
        'changed_appointment' => 'Rendez-vous modifié',
        'has_been_changed' => 'a été modifié.',
        'are_you_sure_want_to_cancel' => 'Êtes-vous sûr de vouloir annuler',
        'has_been_cancelled' => 'a été annulé.',
        'please_select_doctor_department' => 'Veuillez sélectionner le département du médecin',
        'please_select_doctor' => 'Veuillez sélectionner un médecin',
        'doctor_schedule_not_available_on_this_date' => 'Horaire des médecins non disponible à cette date.',
        'please_select_appointment_time_slot' => 'Veuillez sélectionner le créneau horaire du rendez-vous',
        'patient_not_exists_or_status_is_not_active' => 'Le patient n\'existe pas ou le statut n\'est pas actif.',
        'appointment_exists' => 'L\'e-mail du patient existe déjà',
        'old_patient_email_exists' => 'L\'e-mail existe déjà, veuillez sélectionner l\'ancien patient.',
        'time' => 'Temps',
    ],

    'case_handler' => [
        'case_handler' => 'Gestionnaire de cas',
        'new_case_handler' => 'Nouveau gestionnaire de cas',
        'edit_case_handler' => 'Modifier le gestionnaire de cas',
        'case_handler_detail' => 'Détails du gestionnaire de cas',
    ],

    'lab_tech' => [
        'lab_technician' => 'Un technicien de laboratoire',
        'new_lab_tech' => 'Nouveau technicien de laboratoire',
        'edit_lab_tech' => 'Modifier le technicien de laboratoire',
        'lab_tech_detail' => 'Détails du technicien de laboratoire',
    ],

    'doc_type' => [
        'new_doc_type' => 'Nouveau type de document',
        'edit_doc_type' => 'Modifier le type de document',
        'name' => 'Nom',
    ],

    'document' => [
        'document' => 'Document',
        'new_document' => 'Nouveau document',
        'edit_document' => 'Modifier le document',
        'title' => 'Titre',
        'document_type' => 'Type de document',
        'document_type_details' => 'Détails du type de document',
        'patient' => 'Patiente',
        'download' => 'Télécharger',
        'select_patient' => 'Sélectionner un patient',
        'select_document_type' => 'Select Document Type',
        'document_detail' => 'Détails du Document',
        'notes' => 'Remarques',
        'attachment' => 'Attachement',
        'uploaded_by' => 'Telechargé par',
        'validate_doc_type' => 'Le document doit être d\'un type de fichier valide : jpeg, jpg, png, pdf, doc, docx, webp.',
        'select_attachment' => 'Veuillez sélectionner la pièce jointe.',
    ],

    'patient_admission' => [
        'patient_admission' => 'Admission des patients',
        'new_patient_admission' => 'Nouvelle admission de patient',
        'edit_patient_admission' => 'Modifier l\'admission des patients',
        'details' => 'Détails sur l\'admission des patients',
        'patient' => 'Patiente',
        'patient_name' => 'Nom du patient',
        'doctor' => 'Médecin',
        'doctor_name' => 'Doctor Name',
        'admission_date' => 'Date d\'admission',
        'discharge_date' => 'Date de sortie',
        'package' => 'Paquet',
        'package_name' => 'Nom du paquet',
        'insurance' => 'Assurance',
        'insurance_name' => 'Nom de l\'assurance',
        'policy_no' => 'Politique Non',
        'bed' => 'Lit',
        'agent_name' => 'Nom d\'agent',
        'guardian_name' => 'Nom du gardien',
        'guardian_relation' => 'Relation de gardien',
        'guardian_contact' => 'Contact gardien',
        'guardian_address' => 'Adresse du gardien',
        'patient_admission_id' => 'ID d\'admission du patient',
        'admission_date_should_not_be_smaller_than_patient_birth_date' => 'La date d\'admission ne doit pas être antérieure à la date de naissance du patient.',
        'Admission_field_required' => 'Le champ ID d’admission est obligatoire.'
    ],

    'setting' => [
        'app_name' => 'Nom de l\'application',
        'company_name' => 'Nom de la société',
        'app_logo' => 'Logo de l\'application',
        'currency' => 'Devise actuelle',
        'address' => 'Adresse de l\'hôpital',
        'hospital_email' => 'Courriel de l\'hôpital',
        'hospital_phone' => 'Téléphone de l\'hôpital',
        'hospital_from_day' => 'À partir du jour de l\'hôpital',
        'hospital_from_time' => 'À partir de l\'heure de l\'hôpital',
        'about_us' => 'À propos de nous',
        'image_validation' => 'L\'image doit avoir une taille de 90 x 60 pixels.',
        'favicon' => 'Favicon',
        'favicon_validation' => 'L\'image doit avoir une taille de 34 x 34 pixels.',
        'social_details' => 'Détails sociaux',
        'country_code' => 'Code pays',
        'default_language' => 'Langage par défaut',
    ],

    'currency' => [
        'currency' => 'Devise',
        'new_currency' => 'Nouvelle devise',
        'edit_currency' => 'Modifier la devise',
        'currency_name' => 'Nom de la devise',
        'currency_code' => 'Code de devise',
        'currency_icon' => 'Icône de devise',
        'add_currency_code_as_per_three_letter_iso_code' => 'Ajoutez le code de devise selon le code ISO à trois lettres',
        'you_can_find_out_here' => 'vous pouvez découvrir ici',
        'currency_setting_not_found' => 'Paramètres de devise introuvables.',
    ],

    'schedule' => [
        'new' => 'Nouvelle programmation',
        'edit' => 'Modifier le calendrier',
        'details' => 'Détails du programme',
        'doctor_name' => 'Nom du docteur',
        'select_doctor_name' => 'Sélectionnez le nom du médecin',
        'per_patient_time' => 'Temps par patient',
        'serial_visibility' => 'Visibilité série',
        'select_serial_visibility' => 'Sélectionnez la visibilité série',
        'available_on' => 'Disponible le',
        'available_from' => 'Disponible à partir de',
        'available_to' => 'Disponible pour',
        'sequential' => 'Séquentielle',
        'timestamp' => 'Horodatage',
        'schedule_time_select' => 'Veuillez sélectionner l\'heure par patient',
        'schedule_time' => 'L\'heure disponible doit être supérieure à l\'heure de planification de l\'hôpital',
        'available_time_greater_than_zero' => 'L\'heure disponible doit être supérieure à zéro',
        'available_to_time_greater_than_zero' => 'L\'heure de fin disponible doit être supérieure à zéro',
        'available_time_less_than_hospital_schedule_time' => 'L\'heure de fin disponible doit être inférieure à l\'heure de planification de l\'hôpital',
    ],

    'notice_board' => [
        'notice_board' => 'Tableau d\'affichage',
        'new' => 'Nouveau tableau d\'affichage',
        'edit' => 'Modifier le tableau d\'affichage',
        'details' => 'Détails du tableau d\'affichage',
        'title' => 'Titre',
        'description' => 'La description',
        'created_at' => 'créé à',
    ],

    'my_payroll' => [
        'my_payrolls' => 'Mes livres de paie',
        'basic_salary' => 'Salaire de base',
        'allowance' => 'Allocation',
        'deductions' => 'Déductions',
        'net_salary' => 'Salaire net',
    ],

    'medicine' => [
        'medicine' => 'Médecine',
        'medicine_category' => 'Catégorie de médecine\'',
        'medicine_category_details' => 'Détails de la catégorie Médecine',
        'medicines' => 'Médicaments',
        'medicine_details' => 'Détails du médicament',
        'new_medicine' => 'Nouvelle médecine',
        'new_medicine_category' => 'Nouvelle catégorie de médicaments',
        'edit_medicine_category' => 'Modifier la catégorie des médicaments',
        'edit_medicine' => 'Modifier la médecine',
        'name' => 'Nom',
        'brand' => 'Marque',
        'selling_price' => 'Prix de vente',
        'buying_price' => 'Prix d\'achat',
        'category' => 'Catégorie',
        'salt_composition' => 'Composition du sel',
        'side_effects' => 'Effets secondaires',
        'description' => 'La description',
        'category_id' => 'Identifiant de catégorie',
        'brand_name' => 'Marque',
        'new_brand' => 'Nouvelle marque',
        'medicine_brands_details' => 'Détails sur la marque de médicaments',
        'new_medicine_brand' => 'Nouvelle marque de médecine',
        'edit_medicine_brand' => 'Modifier la marque de médecine',
        'medicine_brands' => 'Marques de médicaments',
        'medicine_brands_details' => 'Détails de la marque de médicament',
        'new_brand' => 'Nouvelle marque',
        'new_medicine_brand' => 'Nouvelle marque de médicament',
        'edit_medicine_brand' => 'Modifier la marque de médicament',
        'select_category' => 'Sélectionner une catégorie',
        'select_brand' => 'Sélectionner une marque',
        'is_active' => 'Est actif',
        'delete_medicine' => 'Ce médicament est déjà utilisé dans des factures de médicaments, êtes-vous sûr de vouloir le supprimer ?',
        'category_field_required' => 'Le champ Catégorie est obligatoire',
        'brand_field_required' => 'Le champ Marque est obligatoire.',
    ],

    'profile' => [
        'change_language' => 'Changer la langue',
        'language' => 'Langue',
        'edit_profile' => 'Editer le profil',
        'first_name' => 'Prénom',
        'last_name' => 'Nom de famille',
        'email' => 'E-mail',
        'phone' => 'Téléphoner',
        'profile' => 'Profil',
    ],

    'dashboard' => [
        'dashboard' => 'Tableau de bord',
        'total_invoices' => 'Montant de la facture',
        'total_bills' => 'Montant de la facture',
        'total_payments' => 'Montant du paiement',
        'total_advance_payments' => 'Montant du paiement anticipé',
        'notice_boards' => 'Tableaux d\'affichage',
        'title' => 'Titre',
        'doctors' => 'Médecins',
        'available_beds' => 'Lits disponibles',
        'patients' => 'Les patients',
        'income_and_expense_report' => 'Rapport de revenus et dépenses',
        'income_and_expense_reports' => 'Rapports de revenus et de dépenses',
        'no_enquiries_yet' => 'Aucune demande pour le moment',
        'no_notice_yet' => 'Pas encore d\'avis',
        'total_appointment' => 'Nombre total de rendez-vous',
        'today_appointment' => 'Rendez-vous aujourd\'hui',
        'total_meeting' => 'Total des réunions',
        'sum_of_ipd' => 'Montant dû de l\'IPD',
        'recent_appointments' => 'Nominations récentes',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'Nom',
        'email' => 'Email',
        'contact' => 'Contact',
        'type' => 'taper',
        'message' => 'Message',
        'viewed_by' => 'Vu par',
        'enquiry_details' => 'Détails de l\'enquête',
        'read' => 'Lis',
        'unread' => 'Non lu',
        'not_viewed' => 'Pas vu',
        'received_on' => 'Reçu le',
        'send_enquiry' => 'Envoyer une demande',
        'enquiry_send_successfully' => 'Demande envoyée avec succès',
    ],

    'email' => [
        'to' => 'À',
        'subject' => 'Matière',
        'message' => 'Un message',
        'attachment' => 'Pièces jointes',
    ],

    'verification' => [
        'verify_your_email_address' => 'Vérifiez votre adresse e-mail.',
        'verify_message' => 'Avant de continuer, veuillez vérifier votre e-mail pour un lien de vérification. Si vous n\'avez pas reçu l\'e-mail,',
        'another_verify_request' => 'cliquez ici pour en demander un autre',
        'click_button_for_verify_email' => 'Veuillez cliquer sur le bouton ci-dessous pour vérifier votre adresse e-mail.',
        'further_action_required' => 'Si vous n\'avez pas créé de compte, aucune autre action n\'est requise.',
        'verify_email_address' => 'Vérifier l\'adresse e-mail',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'ambulance',
        'ambulances' => 'ambulances',
        'ambulance_details' => 'Détails de l\'ambulance',
        'vehicle_number' => 'Numéro de véhicule',
        'vehicle_model' => 'Modèle de véhicule',
        'year_made' => 'Année de fabrication',
        'driver_name' => 'Nom du conducteur',
        'driver_license' => 'Permis de conduire',
        'driver_contact' => 'Contact conducteur',
        'note' => 'note',
        'vehicle_type' => 'Type de véhicule',
        'is_available' => 'Est disponible',
        'new_ambulance' => 'Nouvelle ambulance',
        'edit_ambulance' => 'Modifier l\'ambulance',
    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'Appel d\'ambulance',
        'ambulance_calls' => 'Appels d\'ambulance',
        'ambulance_call_details' => 'Détails de l\'appel d\'ambulance',
        'vehicle_model' => 'Modèle de véhicule',
        'patient' => 'Patiente',
        'driver_name' => 'Nom du conducteur',
        'date' => 'Date',
        'amount' => 'Montante',
        'new_ambulance_call' => 'Nouvel appel d\'ambulance',
        'edit_ambulance_call' => 'Modifier l\'appel d\'ambulance',
    ],

    // prescription keys
    'prescription' => [
        'reference_id' => 'Pièce d\'identité',
        'prescription' => 'Prescription',
        'prescriptions' => 'Prescriptions',
        'prescription_details' => 'Détails de la prescription',
        'new_prescription' => 'Nouvelle ordonnance',
        'edit_prescription' => 'Modifier la prescription',
        'patient' => 'Patiente',
        'food_allergies' => 'Allergies alimentaires',
        'tendency_bleed' => 'Saignement de tendance',
        'heart_disease' => 'Maladie cardiaque',
        'high_blood_pressure' => 'Hypertension artérielle',
        'diabetic' => 'Diabétique',
        'surgery' => 'Chirurgie',
        'accident' => 'Accident',
        'others' => 'Autres',
        'medical_history' => 'Ajouté à',
        'current_medication' => 'Médicament actuel',
        'female_pregnancy' => 'Grossesse féminine',
        'breast_feeding' => 'Allaitement maternel',
        'health_insurance' => 'Assurance santé',
        'low_income' => 'Faible revenu',
        'reference' => 'Référence',
        'physical_information' => 'informations physiques',
        'new_medicine' => 'nouveau médicament',
        'plus_rate' => 'Impulsion majoré',
        'temperature' => 'temperature',
        'problem_description' => 'Description du problème',
        'test' => 'test',
        'advice' => 'conseils',
        'next_visit' => 'prochaine visite',
        'time' => 'temps',
        'comment' => 'commentaire',
        'problem' => 'problème',
        'Rx' => 'Rx',
        'medicine_name' => 'nom_du_medicament',
        'duration' => 'Durée',
        'days' => 'journées',
        'after_meal' => 'après manger',
        'before_meal' => 'Avant le repas',
        'year' => 'Année',
        'month' => 'Mois',
        'no_data_available' => 'Aucune donnée disponible',
    ],

    'charge_category' => [
        'charge_categories' => 'Catégories de frais',
        'new_charge_category' => 'Nouvelle catégorie de frais',
        'edit_charge_category' => 'Modifier la catégorie de frais',
        'charge_type' => 'Type de charge',
        'charge_category_details' => 'Détails sur la catégorie de facturation',
    ],

    'charge' => [
        'new_charge' => 'Nouvelle charge',
        'edit_charge' => 'Modifier la charge',
        'charge_details' => 'Détails des frais',
        'charge_category' => 'Catégorie de charge',
        'standard_charge' => 'frais standards',
        'code' => 'Code',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'Nom',
        'radiology_categories' => 'Radiologie Les catégories',
        'new_radiology_category' => 'Nouvelle Radiologie Catégorie',
        'edit_radiology_category' => 'Éditer Radiologie Catégorie',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'Pathologie Les catégories',
        'new_pathology_category' => 'Nouvelle Pathologie Catégorie',
        'edit_pathology_category' => 'Éditer Pathologie Catégorie',
        'name' => 'Nom',
        'select_charge_category' => 'sélectionner la catégorie de frais',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'Radiologie Les tests',
        'new_radiology_test' => 'Nouvelle Radiologie Tester',
        'edit_radiology_test' => 'Éditer Radiologie Tester',
        'radiology_test_details' => 'Radiologie Tester Détails',
        'test_name' => 'Nom du test',
        'short_name' => 'Nom court',
        'test_type' => 'Type de test',
        'category_name' => 'Nom de catégorie',
        'subcategory' => 'Sous-catégorie',
        'report_days' => 'Journées du rapport',
        'charge_category' => 'Catégorie de charge',
        'code' => 'code',
        'standard_charge' => 'la norme Charge',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'doctor_opd_charge' => 'Charge du médecin OPD',
        'new_doctor_opd_charge' => 'Nouveau Doctor OPD Charge',
        'edit_doctor_opd_charge' => 'Modifier la charge Doctor OPD',
        'doctor_name' => 'Nom du Socteur',
        'standard_charge' => 'Charge Standard',
        'doctor' => 'Médecin',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'Pathologie Les tests',
        'new_pathology_test' => 'Nouvelle Pathologie Tester',
        'edit_pathology_test' => 'Éditer Pathologie Tester',
        'pathology_test_details' => 'Pathologie Tester Détails',
        'test_name' => 'Tester Nom',
        'short_name' => 'Courte Nom',
        'test_type' => 'Tester Type',
        'category_name' => 'Catégorie Nom',
        'unit' => 'Unité',
        'subcategory' => 'Sous Catégorie',
        'method' => 'Méthode',
        'report_days' => 'rapport Journées',
        'charge_category' => 'Charge Catégorie',
        'standard_charge' => 'la norme Charge',
    ],

    //expenses keys
    'expense' => [
        'expense' => 'Frais',
        'new_expense' => 'Nouvelle Dépense',
        'edit_expense' => 'Modifier les Dépenses',
        'expense_head' => 'Responsable des Dépenses',
        'name' => 'Nom',
        'date' => 'Date',
        'invoice_number' => 'Numéro de Facture',
        'amount' => 'Montant',
        'attachment' => 'Attachement',
        'description' => 'La description',
        'choose' => 'Choisir',
        'download' => 'Télécharger',
        'expense_details' => 'Détails des Dépenses',
        'select_expense_head' => 'Sélectionner la Tête de Dépense',
        'document_error' => 'Le document doit être un fichier de type: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'Revenus',
        'new_income' => 'Nouveau revenu',
        'edit_income' => 'Modifier le revenu',
        'income_head' => 'Responsable du revenu',
        'name' => 'Nom',
        'date' => 'Date',
        'invoice_number' => 'Numéro de Facture',
        'amount' => 'Montant',
        'attachment' => 'Attachement',
        'description' => 'La description',
        'choose' => 'Choisir',
        'download' => 'Télécharger',
        'income_details' => 'Détails sur le Revenu',
        'select_income_head' => 'Sélectionner le responsable du revenu',
        'document_error' => 'Le document doit être un fichier de type: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Statut du lit',
        'assigned_beds' => 'Lits attribués',
        'available_beds' => 'Lits disponibles',
        'bed_name' => 'Nom du lit',
        'patient_name' => 'Nom du patient',
        'phone' => 'Téléphone',
        'admission_date' => 'Date d\'admission',
        'gender' => 'Le genre',
    ],

    //Messages keys
    'message' => [
        'message' => 'Message',
        'messages' => 'Messages',
        'send_to' => 'Envoyer à',
        'subject' => 'Matière',
        'new_message' => 'Nouveau Message',
        'messages_details' => 'Détails du Message',
        'sender_name' => 'Nom de l\'expéditeur',
        'date' => 'Date',
        'select_user' => 'Sélectionnez un Utilisateur',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'SMS',
        'new_sms' => 'Nouveau SMS',
        'send_to' => 'Envoyer à',
        'phone_number' => 'Numéro de Téléphone',
        'send_by' => 'Envoyé par',
        'message' => 'Message',
        'sms_details' => 'Détails SMS',
        'date' => 'Date',
        'send' => 'Envoyer',
        'role' => 'Rôle',
        'send_sms_by_number_directly' => 'Envoyez directement des SMS par numéro',
        'only_user_with_registered_phone_will_display' => '(Seuls les utilisateurs avec un téléphone enregistré s`afficheront.)',
        'message_not_greater_than_160_characters' => 'Le message ne peut pas dépasser 160 caractères.',
        'set_credential' => 'Veuillez définir vos informations d\'identification.',

    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'Diagnostic',
        'diagnosis_test' => 'Tests de diagnostic',
        'patient_diagnosis_test' => 'Tests de diagnostic des patients',
        'report_number' => 'Signaler le numéro',
        'patient' => 'Patient',
        'doctor' => 'Docteur',
        'created_at' => 'Créé à',
        'action' => 'action',
        'new_patient_diagnosis_test' => 'Nouveau test de diagnostic pour les patients',
        'edit_patient_diagnosis_test' => 'Modifier le test de diagnostic du patient',
        'create_patient_diagnosis_test' => 'Créer un test de diagnostic patient',
        'patient_diagnosis_test_details' => 'Détails du test de diagnostic du patient',
        'diagnosis_category' => 'Catégorie de diagnostic',
        'add_other_diagnosis_property' => 'Ajouter une autre propriété de diagnostic',
        'other_diagnosis_property' => 'Autre propriété de diagnostic',
        'diagnosis_property_name' => 'Nom de la propriété de diagnostic',
        'diagnosis_property_value' => 'Valeur de propriété de diagnostic',
        'patient_name' => 'Nom du patient',
        'doctor_name' => 'Nom du docteur',
        'age' => 'Âge',
        'height' => 'Hauteur',
        'weight' => 'Poids',
        'average_glucose' => 'Glycémie moyenne',
        'fasting_blood_sugar' => 'Glycémie à jeun',
        'urine_sugar' => 'Urine Sucre',
        'blood_pressure' => 'Pression artérielle',
        'diabetes' => 'Diabète',
        'cholesterol' => 'Cholestérol',
        'print_diagnosis_test' => 'Test de diagnostic d\'impression',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'Catégorie de diagnostic',
        'diagnosis_categories' => 'Catégorie de diagnostic',
        'new_diagnosis_category' => 'Nouvelle catégorie de diagnostic',
        'description' => 'La description',
        'category_name' => 'Nom de catégorie',
        'diagnosis_category_details' => 'Détails de la catégorie de diagnostic',
        'edit_diagnosis_category' => 'Modifier la catégorie de diagnostic',
    ],

    // Operation Category
    'operation_category' => [
        'operation_category' => 'Catégorie d\'opération',
        'operation_categories' => 'Catégories d\'opérations',
        'new_operation_category' => 'Nouvelle catégorie d\'opération',
        'edit_operation_category' => 'Modifier la catégorie d\'opération',
        'operation_category_field_required' => 'Le champ Catégorie d’opération est obligatoire.',
    ],

    // Operation
    'operation' => [
        'operation' => 'Opération',
        'operation_field_required' => 'Le champ Opération est obligatoire.',
        'select_operation_date' => 'Veuillez sélectionner la date de l\'opération.',
        'operation_date' => 'Date d\'opération',
        'operation_name' => 'Nom de l\'opération',
        'operation_category_name' => 'Catégorie d\'opération Nom',
        'ot_technician' => 'Technicien en OT',
        'ot_assistant' => 'Assistante OT',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'Catégorie d\'article',
        'item_categories' => 'Catégories d\'articles',
        'new_item_category' => 'Nouvelle Catégorie d\'article',
        'edit_item_category' => 'Éditer Catégorie d\'article',
        'name' => 'Nom',
    ],

    'item' => [
        'item' => 'Item',
        'items' => 'Items',
        'new_item' => 'Nouvelle Item',
        'edit_item' => 'Éditer Item',
        'item_details' => 'Item Détails',
        'name' => 'Nom',
        'item_category' => 'Item Catégorie',
        'unit' => 'Unité',
        'description' => 'La description',
        'available_quantity' => 'quantité disponible',
    ],

    'item_stock' => [
        'item_stock' => 'Stock d\'article',
        'item_stocks' => 'Stocks d\'articles',
        'new_item_stock' => 'Nouveau stock d\'article',
        'edit_item_stock' => 'Modifier le stock d\'articles',
        'item_stock_details' => 'Détails du stock d\'article',
        'item_category' => 'Catégorie d\'article',
        'item' => 'Item',
        'supplier_name' => 'Nom du fournisseur',
        'store_name' => 'Nom du magasin',
        'quantity' => 'Quantité',
        'purchase_price' => 'Prix d\'achat',
        'description' => 'La description',
        'attachment' => 'Attachement',
    ],

    'issued_item' => [
        'issued_item' => 'Article émis',
        'issued_items' => 'Articles émis',
        'new_issued_item' => 'Nouvel élément émis',
        'edit_issued_item' => 'Modifier l\'élément émis',
        'issued_item_details' => 'Détails des articles émis',
        'department_id' => 'Type d\'utilisateur',
        'user_id' => 'Émettre à',
        'issued_by' => 'Issue By',
        'issued_date' => 'Date d\'émission',
        'return_date' => 'Date de retour',
        'item_category' => 'Catégorie d\'article',
        'item' => 'Article',
        'quantity' => 'Quantité',
        'description' => 'La description',
        'available_quantity' => 'quantité disponible',
        'item_return' => 'Retourner l\'objet',
        'item_returned' => 'Revenu',
        'are_you_sure_want_to_return_this_item' => 'Êtes-vous sûr de vouloir retourner cet article',
        'quantity_cannot_be_zero' => 'La quantité ne peut pas être zéro.',
        'quantity_must_be_less_than_available_quantity' => 'La quantité doit être inférieure à la quantité disponible.',
    ],

    'ipd_patient' => [
        'ipd_patient_in' => 'IPD - Entrée patient',
        'ipd_patient' => 'Patient IPD',
        'ipd_patients' => 'Patients IPD',
        'new_ipd_patient' => 'Nouveau patient IPD',
        'edit_ipd_patient' => 'Modifier le patient IPD',
        'ipd_patient_details' => 'Détails du patient IPD',
        'patient_id' => 'Patient',
        'ipd_number' => 'IPD Non',
        'height' => 'la taille',
        'weight' => 'Poids',
        'bp' => 'Pression artérielle',
        'symptoms' => 'Symptômes',
        'notes' => 'Remarques',
        'admission_date' => 'Date d\'admission',
        'case_id' => 'Cas',
        'is_old_patient' => 'Est un vieux patient',
        'doctor_id' => 'Docteur',
        'bed_type_id' => 'Type de lit',
        'bed_id' => 'Lit',
        'bill_status' => 'Statut de la facture',
        'the_case_field_is_required' => 'Le champ cas est obligatoire.',
        'the_bed_field_is_required' => 'Le champ lit est obligatoire.',
        'the_bed_field_has_a_duplicate_value' => 'Le champ lit a une valeur en double',
        'the_bed_already_taken' => 'The Bed : l\'entrée a déjà été prise',
        'the_bed_type_is_required' => 'Le champ type de lit est obligatoire.',
        'charge_required' => 'Champ de frais Obligatoire.',
        'discharge' => 'Décharge',
        'net_amount' => 'Montant net',
        'discharged' => 'Déchargé',
        'not_dischared' => 'Non déchargé',
        'discharge_slip' => 'Bordereau de décharge',
        'print_discharge_slip' => 'Imprimer le bordereau de sortie',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'Ajouter un diagnostic',
        'edit_ipd_diagnosis' => 'Modifier le diagnostic',
        'report_type' => 'Type de rapport',
        'report_date' => 'Date du compte rendu',
        'document' => 'Document',
        'description' => 'La description',
    ],

    'ipd_patient_consultant_register' => [
        'consultant_doctor' => 'Médecin consultant',
        'new_consultant_register' => 'Ajouter une instruction de consultant',
        'edit_consultant_register' => 'Modifier les instructions du consultant',
        'applied_date' => 'Date d\'application',
        'doctor_id' => 'Docteur',
        'instruction' => 'Instruction',
        'instruction_date' => 'Date de l\'instruction',
        'applied_date_or_Instruction_date_can_not_be_null' => 'La date de demande ou la date d\'instruction ne peut pas être nulle.',
        'assistant_consultant_1' => 'Consultant adjoint 1',
        'assistant_consultant_2' => 'Consultant adjoint 2',
        'anesthetist' => 'Anesthésiste',
        'anesthesia_type' => 'Type d\'anesthésie',
        'instruction_field_is_required' => 'Le champ d\'instruction est obligatoire.',
    ],

    'ipd_patient_charges' => [
        'consultant_instruction' => 'Instruction du conseiller',
        'new_charge' => 'Ajouter des frais',
        'date' => 'Date',
        'edit_charge' => 'Modifier les frais',
        'charge_type_id' => 'Type de charge',
        'charge_category_id' => 'Catégorie de charge',
        'charge_id' => 'Code',
        'standard_charge' => 'Charge standard',
        'applied_charge' => 'Charge appliquée',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD Non',
        'header_note' => 'Note d\'en-tête',
        'footer_note' => 'Note de pied de page',
        'new_prescription' => 'Ajouter une ordonnance',
        'edit_prescription' => 'Modifier la prescription',
        'prescription_details' => 'Détails de la prescription',
        'category_id' => 'Catégorie de médecine',
        'medicine_id' => 'Médicament',
        'dosage' => 'Dosage',
        'instruction' => 'Instruction',
        'print_prescription' => 'Prescription d\'impression',
    ],

    'ipd_patient_timeline' => [
        'timeline' => 'Chronologie',
        'new_ipd_timeline' => 'Ajouter une chronologie',
        'edit_ipd_timeline' => 'Modifier la chronologie',
        'title' => 'Titre',
        'date' => 'Date',
        'description' => 'La description',
        'document' => 'Document',
        'visible_to_person' => 'Visible à la personne',
        'no_timeline_found' => 'Aucune ligne de temps trouvée',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'Ajouter un paiement IPD',
        'edit_ipd_payment' => 'Modifier le paiement IPD',
        'payment_mode' => 'Mode de paiement',
        'make_payment' => 'Effectuer le paiement',
    ],

    'ipd_bill' => [
        'paid_amount' => 'Montant payé',
        'total_charges' => 'Total Charges',
        'gross_total' => 'Total brut',
        'discount_in_percentage' => 'Remise en pourcentage',
        'discount_in_number' => 'Remise en nombre',
        'tax_in_percentage' => 'Taxe en pourcentage',
        'tax_in_number' => 'Numéro de taxe',
        'other_charges' => 'Autres frais',
        'net_payable_amount' => 'Montant net à payer',
        'discharge_patient' => 'Sortie du patient',
    ],

    'opd_patient' => [
        'opd_patient_out' => 'OPD – Sortie du patient',
        'opd_patient' => 'OPD Patient',
        'opd_patients' => 'OPD Patients',
        'new_opd_patient' => 'Nouveau patient OPD',
        'edit_opd_patient' => 'Modifier le patient OPD',
        'opd_patient_details' => 'Détails du patient OPD',
        'opd_number' => 'OPD Non',
        'appointment_date' => 'Date de rendez-vous',
        'visits' => 'Visites',
        'revisits' => 'Revisiter',
        'total_visits' => 'Total des visites',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'Ajouter un paiement Opd',
        'edit_opd_payment' => 'Modifier le paiement Opd',
        'payment_mode' => 'Mode de paiement',
        'make_payment' => 'Effectuer le paiement',
    ],

    'call_log' => [
        'call_log' => 'Journal d\'appel',
        'new' => 'Nouveau journal d`appels',
        'edit' => 'Modifier le journal des appels',
        'name' => 'Nom',
        'phone' => 'Téléphone',
        'received_on' => 'Reçu le',
        'follow_up_date' => 'Date de suivi',
        'note' => 'Remarque',
        'call_type' => 'Type d\'appel',
        'incoming' => 'Entrante',
        'outgoing' => 'Sortante',
    ],

    'visitor' => [
        'visitor' => 'Visiteuse',
        'new' => 'Nouveau visiteur',
        'edit' => 'Modifier le visiteur',
        'name' => 'Nom',
        'purpose' => 'Objectif',
        'phone' => 'Téléphone',
        'id_card' => 'Carte d`identité',
        'number_of_person' => 'Nombre de personne',
        'date' => 'Date',
        'in_time' => 'À l`heure',
        'out_time' => 'Temps de sortie',
        'note' => 'Remarque',
    ],

    'postal' => [
        'postal' => 'Carte postale',
        'new_receive' => 'Nouvelle réception',
        'new_dispatch' => 'Nouvel envoi',
        'dispatch' => 'Envoi',
        'receive' => 'Recevoir',
        'edit_receive' => 'Modifier la réception',
        'edit_dispatch' => 'Modifier l`envoi',
        'to_title' => 'Au titre',
        'from_title' => 'À partir du titre',
        'reference_no' => 'Numéro de réference',
        'date' => 'Date',
        'address' => 'Adresse',
        'validate_from_title' => 'Le champ "De" est requis.',
        'validate_to_title' => 'Le champ "À" est requis.',
    ],

    'testimonial' => [
        'testimonial' => 'Témoignage',
        'new_testimonial' => 'Nouveau témoignage',
        'edit_testimonial' => 'Témoignage bearbeiten',
        'testimonial_detail' => 'Détail du témoignage',
        'name' => 'Nom',
        'description' => 'Description',
        'profile_error' => 'Das Dokument muss eine Datei vom Typ sein: jpeg, jpg, png.',
    ],

    'blood_donation' => [
        'blood_donation' => 'Don de sang',
        'new_blood_donation' => 'Nouveau don de sang',
        'edit_blood_donation' => 'Modifier le don de sang',
        'donor_name' => 'Nom du donateur',
        'bags' => 'Sacs',
        'last_donate_date' => 'Date du dernier don',
    ],

    'blood_issue' => [
        'blood_issue' => 'Problème de sang',
        'new_blood_issue' => 'Nouveau problème de sang',
        'edit_blood_issue' => 'Modifier le problème de sang',
        'issue_date' => 'Date d`émission',
        'patient_name' => 'Nom du patient',
        'doctor_name' => 'Nom du médecin',
        'donor_name' => 'Nom du donateur',
        'amount' => 'Montante',
        'remarks' => 'Remarques',
    ],

    'ipd_operation' => [
        'ipd_operation' => 'Opération en hospitalisation à domicile (IHD)',
        'ipd_operation_created_successfully' => 'Opération en hospitalisation à domicile (IHD) créée avec succès',
    ],

    'notification' => [
        'all_notification_read_successfully' => 'Toutes les notifications ont été lues avec succès.',
        'notification_read_successfully' => 'Notification lue avec succès.',
        'notifications' => 'Notifications',
        'mark_all_as_read' => 'Tout marquer comme lu',
        'you_don`t_have_any_new_notification' => 'Vous n`avez aucune nouvelle notification',
    ],

    'live_consultation' => [
        'live_consultation' => 'Consultation en direct',
        'new_live_consultation' => 'Nouvelle consultation en direct',
        'consultation_title' => 'Titre de la consultation',
        'consultation_date' => 'Date de la consultation',
        'consultation_duration_minutes' => 'Durée de la consultation (en minutes)',
        'client_video' => 'Vidéo du client',
        'host_video' => 'Vidéo de l\'hôte',
        'enable' => 'Activer',
        'disabled' => 'Désactivé',
        'type' => 'Type',
        'type_number' => 'Numéro de type',
        'created_by' => 'Créé par',
        'created_for' => 'Créé pour',
        'new_live_meeting' => 'Nouvelle réunion en direct',
        'staff_list' => 'Liste du personnel',
        'edit_live_consultation' => 'Modifier la consultation en direct',
        'duration' => 'Durée (en minutes)',
        'start_now' => 'Démarrer maintenant',
        'join_now' => 'Rejoindre maintenant',
        'edit_live_meeting' => 'Modifier la réunion en direct',
        'add_credential' => 'Ajouter une référence',
        'zoom_api_key' => 'Clé API Zoom',
        'zoom_api_secret' => 'Secret de l\'API Zoom',
        'join_meeting' => 'Rejoindre la réunion',
        'start_meeting' => 'Démarrer la réunion',
        'generate_auth_credentials' => 'Comment générer des informations d\'authentification ?',
        'user_zoom_credential_saved' => 'Informations d\'identification Zoom de l\'utilisateur enregistrées avec succès.',
        'add_credentials_for_zoom_meeting' => 'Veuillez ajouter des informations d\'identification pour la réunion Zoom.',
        'credentials_already_use' => 'Vos identifiants zoom sont déjà utilisés',
        'connect_with_zoom' => 'Il faut se connecter avec zoom',
        'cannot_delete_meeting_in_progress' => 'Désolé, vous ne pouvez pas supprimer cette réunion car elle est en cours',
        'select_platform' => 'Sélectionnez la plateforme',
    ],

    'vaccination' => [
        'vaccinations' => 'Les vaccinations',
        'new_vaccination' => 'Nouvelle vaccination',
        'edit_vaccination' => 'Modifier la vaccination',
        'name' => 'Nom',
        'manufactured_by' => 'Fabriqué par',
        'brand' => 'Marque',
        'vaccinated' => 'Vacciné',
    ],

    'vaccinated_patient' => [
        'vaccinated_patient' => 'Patient vacciné',
        'patient' => 'Patient',
        'vaccination' => 'Vaccination',
        'serial_no' => 'Numéro de série',
        'does_no' => 'Dose Non',
        'dose_given_date' => 'Dose donnée Date',
        'description' => 'Description',
        'add_vaccinate_patient' => 'Ajouter un patient vacciné',
        'new_vaccinate_patient' => 'Nouveau patient vacciné',
        'edit_vaccinate_patient' => 'Modifier le patient vacciné',
        'vaccine' => 'Vaccin',
        'vaccinate_patient' => 'Vacciner le patient',
        'already_registered_dose' => 'Le patient est déjà enregistré avec le même vaccin et le même numéro de dose.',
    ],

    'front_setting' => [
        'about_us_title' => 'Titre',
        'about_us_mission' => 'Mission',
        'about_us_image' => 'Image',
        'about_us_description' => 'Description',
        'about_us_details' => 'À propos de nous Détails',
        'appointment_details' => 'Détails du rendez-vous',
        'terms_condition_details' => 'Détails des conditions générales',
        'front_setting_details' => 'détail de réglage avant',
        'home_page_image' => 'Image de la page d\'accueil',
        'home_page_title' => 'Titre de la page d\'accueil',
        'home_page_description' => 'Description de la page d\'accueil',
        'home_page_box_title' => 'Titre de la boîte de la page d\'accueil',
        'home_page_box_description' => 'Description de la boîte de la page d\'accueil',
        'home_page_experience' => 'Expérience de la page d\'accueil',
        'home_page_step_1_title' => 'Page d\'accueil Étape 1 Titre',
        'home_page_step_1_description' => 'Page d\'accueil Étape 1 Description',
        'home_page_step_2_title' => 'Page d\'accueil Étape 2 Titlen',
        'home_page_step_2_description' => 'Page d\'accueil Étape 2 Description',
        'home_page_step_3_title' => 'Page d\'accueil Étape 3 Titre',
        'home_page_step_3_description' => 'Page d\'accueil Étape 3 Description',
        'home_page_step_4_title' => 'Page d\'accueil Étape 4 Titre',
        'home_page_step_4_description' => 'Page d\'accueil Étape 4 Description',
        'terms_conditions' => 'termes et conditions',
        'privacy_policy' => 'Politique de confidentialité',
        'home_page_certified_doctor_image' => 'Page d\'accueil Image de médecin certifié',
        'home_page_certified_doctor_text' => 'Page d\'accueil Texte du médecin certifié',
        'home_page_certified_doctor_title' => 'Page d\'accueil Titre de docteur certifié',
        'home_page_certified_doctor_description' => 'Page d\'accueil Médecin certifié Description',
        'home_page_certified_box_title' => 'Titre de la boîte certifiée de la page d\'accueil',
        'home_page_certified_box_description' => 'Page d\'accueil Description de la boîte certifiée',
        'the_terms_conditions_is_required' => 'Les conditions générales sont requises.',
        'the_privacy_policy_is_required' => 'La politique de confidentialité est requise.',
        'home_page_experience_required' => 'Le champ expérience de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_title_required' => 'Le champ titre de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_description_required' => 'Le champ description de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_box_required' => 'Le champ titre de la boîte de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_box_descriptions_required' => 'Le champ descriptions de la boîte de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_certified_required' => 'Le champ texte du médecin certifié de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_certified_title_required' => 'Le champ titre du médecin certifié de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_certified_doctor_description_required' => 'Le champ description du médecin certifié de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_certified_box_title_required' => 'Le champ titre de la boîte certifiée de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_certified_description_required' => 'Le champ description de la boîte certifiée de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_title_required' => 'Le champ titre de l\'étape 1 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_description_required' => 'Le champ description de l\'étape 1 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_two_title_required' => 'Le champ titre de l\'étape 2 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_two_description_required' => 'Le champ description de l\'étape 2 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_three_title_required' => 'Le champ titre de l\'étape 3 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_three_description_required' => 'Le champ description de l\'étape 3 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_four_title_required' => 'Le champ titre de l\'étape 4 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'home_page_step_four_description_required' => 'Le champ description de l\'étape 4 de la page d\'accueil ne doit pas contenir que des espaces blancs.',
        'about_us_title_required' => 'Le champ titre "À propos de nous" ne doit pas contenir que des espaces blancs.',
        'about_us_description_required' => 'Le champ description "À propos de nous" ne doit pas contenir que des espaces blancs.',
        'about_us_mission_required' => 'Le champ mission "À propos de nous" ne doit pas contenir que des espaces blancs.',
    ],

    'change_password' => [
        'change_password' => 'Changer le mot de passe',
        'current_password' => 'Mot de passe actuel',
        'new_password' => 'nouveau mot de passe',
        'confirm_password' => 'Confirmez le mot de passe',
    ],

    'web_home' => [
        'home' => 'Accueil',
        'services' => 'Prestations de service',
        'doctors' => 'Médecins',
        'about_us' => 'À propos de nous',
        'contact' => 'Contact',
        'make_appointment' => 'Prendre un rendez-vous',
        'working_hours' => 'Heures d\'ouverture',
        'testimonials' => 'Témoignages',
        'terms_of_service' => 'Conditions d\'utilisation',
        'privacy_policy' => 'Politique de confidentialité',
        'patients' => 'Les patients',
        'years_experience' => 'Années d\'expérience',
        'sign_up' => 'S\'inscrire',
        'available_doctors' => 'Médecins disponibles',
        'select_doctors' => 'Sélectionnez les médecins',
        'contact_doctors' => 'Contacter le médecin',
        'contact_hospital' => 'Contacter l\'hôpital',
        'easy_solutions' => 'Solutions faciles',
        '4_easy_step_and_get_the_world_best_treatment' => '4 étapes faciles et obtenez le meilleur traitement au monde',
        'book_an_appointment' => 'Prenez rendez-vous',
        'select_doctor' => 'Sélectionnez un médecin',
        'book_now' => 'Reserve maintenant',
        'patients_beds' => 'Lits de patients',
        'doctors_nurses' => 'Médecins et infirmières',
        'happy_patients' => 'Patients heureux',
        'book_appointment' => 'Prendre rendez-vous',
        'our_services' => 'Nos services',
        'we_offer_different_services_to_improve_your_health' => 'Nous offrons différents services pour améliorer votre santé',
        'professional_doctors' => 'Médecins professionnels',
        'we_are_experienced_healthcare_professionals' => 'Nous sommes des professionnels de la santé expérimentés',
        'our_testimonials' => 'Nos témoignages',
        'what_our_patient_say_about_medical_treatments' => 'Ce que nos patients disent de nos traitements médicaux',
        'professional_details' => 'Détails professionnels',
    ],

    'web_password' => [
        'please_fill_all_the_required_fields' => 'Veuillez remplir tous les champs obligatoires.',
        'password_and_confirm_password_not_match' => 'Le mot de passe et la confirmation du mot de passe ne correspondent pas.',
    ],

    'web_contact' => [
        'call_today' => 'Appelez aujourd\'hui',
        'open_hours' => 'Heures d\'ouverture',
        'our_location' => 'Notre emplacement',
        'send_us_a_message' => 'Envoie-nous un message',
        'your_name' => 'votre nom',
        'your_email' => 'Votre e-mail',
        'phone_number' => 'Numéro de téléphone',
        'select_enquiry' => 'Sélectionnez l\'enquête',
        'your_message' => 'Votre message',
        'send_message' => 'Envoyer le message',
        'enter_your_name' => 'Entrez votre nom',
        'enter_your_email' => 'Entrer votre Email',
        'contact_no' => 'N° de contact',
        'please_enter_your_phone_number' => 'Veuillez entrer votre numéro de téléphone',
        'write_your_message' => 'Écrivez votre message',
        'type_your_message' => 'Tapez votre message',
    ],

    'web_menu' => [
        'about' => 'Sur',
        'our_features' => 'Nos fonctionnalités',
        'appointment' => 'Rendez-vous',
        'working_hours' => 'Heures d\'ouverture',
        'login' => 'Connexion',
        'useful_link' => 'Lien utile',
        'contact_information' => 'Coordonnées',
        'copyright' => 'droits d\'auteur',
        'all_rights_reserved_by' => 'Tous droits réservés par',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'Prendre rendez-vous',
        'call_now_and_get_a_free_consulting' => 'Appelez maintenant et obtenez une consultation gratuite',
        'enter_your_first_name' => 'Entrez votre prénom',
        'enter_your_last_name' => 'Entrez votre nom de famille',
        'enter_your_password' => 'Tapez votre mot de passe',
        'enter_confirm_password' => 'Entrez Confirmer le mot de passe',
        'select_department' => 'Sélectionnez le département',
        'select_doctor' => 'Sélectionnez un médecin',
        'enter_description' => 'Entrez la description',
        'select_time' => 'Sélectionnez l\'heure',
    ],

    'web_working_hours' => [
        'opening_hours' => 'Horaires d\'ouvertures',
        'no_yet_opening_hours' => 'Pas encore d\'heures d\'ouverture',
    ],

    'front_services' => [
        'new_service' => 'Nouveau service',
        'edit_service' => 'Modifier le service',
        'select_icon_file' => 'Veuillez sélectionner le fichier d\'icône',
    ],

    'purchase_medicine' => [
        'purchase_number' => 'Numéro d\'achat',
        'total' => 'Total',
        'discount' => 'Rabais',
        'tax_amount' => 'Montant de la taxe',
        'net_amount' => 'Montant net',
        'payment_mode' => 'Mode de paiement',
        'payment_note' => 'Bulletin de paiement',
        'note' => 'Note',
        'purchase_medicine' => 'Acheter des médicaments',
        'purchase_medicine_details' => 'Acheter des détails sur les médicaments',
        'purchase_medicine_overview' => 'Aperçu de l\'achat de médicaments',
        'lot_no' => 'N° de lot',
        'tax' => 'Impôt',
        'quantity' => 'Quantité',
        'amount' => 'Montant',
        'expiry_date' => 'Date d\'expiration',
        'other_details' => 'Autres détails',
        'dose_duration' => 'Durée de la dose',
        'medicine_purchased_successfully' => 'Médicament acheté avec succès.',
    ],

    'used_medicine' => [
        'used_medicine' => 'Médicament utilisé',
        'used_quantity' => 'Quantité utilisée',
        'used_at' => 'Utilisé à',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Factures de médicaments',
        'medicine_bill' => 'Facture de médecine',
        'edit_medicine_bill' => 'Modifier la facture de médicaments',
        'medicine_bill_details' => 'Détails de la facture des médicaments',
        'dose_interval' => 'Intervalle de dose',
        'available_quantity' => 'La quantité disponible de',
        'is' => 'est',
        'prescription_not_found' => 'Ordonnance introuvable.',
        'medicine_not_selected' => 'Veuillez sélectionner au moins un médicament.',
        'duplicate_medicine' => 'Impossible d\'ajouter des médicaments en double.',
        'payment_status' => 'Statut de paiement',
        'sale_price' => 'Prix ​​de vente',
        'add_medicine_bill' => 'Ajouter une facture de médicaments',
        'select_medicine' => 'Sélectionnez un médicament',
        'update_quantity' => 'La quantité mise à jour doit être inférieure à la quantité précédente.',
        'net_amount_not_empty' => 'Le montant net ne peut pas être vide.',
        'net_amount_not_zero' => 'Le montant net ne peut pas être nul.',
        'payment_type' => 'Type de paiement',
        'tax_amount_not_zero_or_empty' => 'Le montant de la taxe ne peut pas être zéro ou vide.',
        'medicine_required' => 'Le champ Médicament est requis.',
        'bill_number' => 'Numéro de facture',
        'validate_discount' => 'La réduction doit être inférieure au montant total',
        'validate_tax' => 'Les taxes doivent être inférieures à 100%.',
        'quantity_cannot_be_zero' => 'La quantité ne peut pas être zéro ou vide.',
        'lot_number' => 'Entrez le numéro de lot',
        'sale_price' => 'Entrez le prix de vente',
        'purchase_price' => 'Entrez le prix d\'achat',
        'validate_quantity' => 'La quantité doit être supérieure à 0.',
        'quantity_required' => 'Veuillez entrer la quantité.',
    ],
    'subscription_plans' => [
        'payment_type' => 'Sélectionner le mode de paiement',
        'connect_with_zoom' => 'Se connecter à Zoom',
        'connected' => 'Connecté',
    ],

    'holiday' => [
        'holiday' => 'Jour férié',
        'add_holiday' => 'Ajouter un jour férié',
        'doctor_holiday' => 'Congés du médecin',
        'service_category' => 'Catégorie de service',
        'holiday_date' => 'Date du jour férié',
        'reason' => 'Raison',
        'holiday_already_is_exist' => 'Le jour férié existe déjà.',
        'doctor_holiday_create' => 'Congés du médecin enregistrés avec succès.',
        'you_are_not_allow_to_record' => 'Il semble que vous n\'ayez pas accès à cet enregistrement.',
        'appointment_exists' => 'Le rendez-vous existe. Vous ne pouvez pas prendre de vacances.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'Pause déjeuner',
        'lunch_break' => 'Pause déjeuner',
        'break_create' => 'Pause déjeuner enregistrée avec succès.',
        'break_update' => 'Pause déjeuner mise à jour avec succès.',
        'add_break' => 'Ajouter une pause déjeuner',
        'edit_break' => 'Modifier la pause déjeuner',
        'break_already_is_exist' => 'La pause déjeuner existe déjà.',
        'break_time_greater_than_zero' => 'La durée de la pause doit être supérieure à zéro.',
        'break_to_time_greater_than_zero' => 'L\'heure de fin de la pause doit être supérieure à zéro.',
        'break_to_time_greater_than_from_time' => 'L\'heure de fin de la pause doit être supérieure à l\'heure de début de la pause.',
        'date_required' => 'Le champ Date est obligatoire.',
        'appointment_exists' => 'Le rendez-vous existe, vous ne pouvez pas prendre de pause.',
    ],

    'new_change' => [
        'pathology_units' => 'Unités de pathologie',
        'pathology_unit' => 'Unité de pathologie',
        'add_unit' => 'Nouvelle unité de pathologie',
        'edit_unit' => 'Modifier l\'unité de pathologie',
        'pathology_unit_not_found' => 'Unité de pathologie introuvable',
        'pathology_unit_cant_deleted' => 'L\'unité de pathologie ne peut pas être supprimée.',
        'pathology_parameter_not_found' => 'Paramètre pathologique introuvable',
        'pathology_parameter_cant_deleted' => 'Le paramètre de pathologie ne peut pas être supprimé.',
        'pathology_parameter' => 'Paramètre de pathologie',
        'pathology_parameters' => 'Paramètres pathologiques',
        'add_parameter' => 'Nouveau paramètre de pathologie',
        'edit_parameter' => 'Modifier le paramètre de pathologie',
        'parameter_name_required' => 'Le champ Nom du paramètre est obligatoire.',
        'patient_result_required' => 'Le champ Résultat du patient est obligatoire.',
        'parameter_name' => 'Le nom du paramètre',
        'patient_result' => 'Résultat du patient',
        'select_parameter_name' => 'Sélectionnez le nom du paramètre',
        'reference_range' => 'Plage de référence',
        'select_unit' => 'Sélectionnez l\'unité',
        'print_pathology_test' => 'Test de pathologie d\'impression',
        'pathology_test_report' => 'Rapport de test de pathologie',
    ],
    'subscription_plans' => [
        'payment_type' => 'Choisissez le type de paiement',
        'connect_with_zoom' => 'Connectez-vous à Zoom',
        'connected' => 'Connecté',
        'select_ipd_patient' => 'Sélectionnez un patient IPD',
    ],

    'patient_id_card' => [
        'id' => 'IDENTIFIANT',
        'patient_id_card' => 'Cartes à puce des patients',
        'new_patient_id_card_template' => 'Nouveau modèle de carte à puce patient',
        'edit_patient_id_card_template' => 'Modifier le modèle de carte à puce du patient',
        'patient_id_card_template' => 'Modèle de carte à puce patient',
        'color' => 'Couleur',
        'patient_unique_id' => 'Identifiant unique du patient',
        'new_patient_id_card' => 'Nouvelle carte à puce patient',
        'generate_patient_id_card' => 'Générer une carte à puce patient',
        'template_id' => 'Nom du modèle',
        'select_template' => 'Sélectionner un modèle',
        'select_type' => 'Sélectionner un type',
        'all_patient' => 'Pour tous les patients',
        'one_patient' => 'Pour un seul patient',
        'remaining_patients' => 'Patients restants',
        'template_required' => 'Champ du modèle requis',
        'patient_required' => 'Le champ Patient est obligatoire',
    ],

    'register' => [
        'hello' => 'Bonjour !',
        'whoops' => 'Oups !',
        'regards' => 'Cordialement,',
        'if_having_trouble_text' => "Si vous avez des problèmes pour cliquer sur le bouton \":actionText\", copiez et collez l'URL ci-dessous\n".
        'dans votre navigateur Web : [:actionURL](:actionURL)',
    ],

    'custom_field' => [
        'custom_field' => 'Campo Personalizado',
        'add_custom_field' => 'Agregar Campo Personalizado',
        'edit_custom_field' => 'Editar Campo Personalizado',
        'module_name' => 'Nombre del Módulo',
        'field_type' => 'Tipo de Campo',
        'field_name' => 'Nombre del Campo',
        'grid' => 'Cuadrícula',
        'value' => 'Valor',
        'seperated_by_comma' => 'Separado por Coma',
        'is_reqired' => 'Es Requerido',
        'input' => 'Entrada',
        'textarea' => 'Área de Texto',
        'checkbox' => 'Casilla de Verificación',
        'number' => 'Número',
        'dropdown' => 'Desplegable',
        'multi_select' => 'Selección Múltiple',
        'date' => 'Fecha',
        'date_time' => 'Date et heure',
        'appointment' => 'Cita',
        'ipd_patient' => 'Paciente de Hospitalización',
        'opd_patient' => 'Paciente de Consulta Externa',
        'patient' => 'Paciente',
        'value_must_be_greter_then' => 'El valor debe ser mayor que 1',
        'select_module' => 'Seleccionar Módulo',
        'select_field_type' => 'Seleccionar Tipo de Campo',
        'text' => 'Texte'
    ],

    'google_meet' => [
        'connect_calendar' => 'Connectez votre agenda Google',
        'disconnect_google_calendar' => 'Déconnectez votre agenda Google',
        'sync_google_calendar' => 'Synchronisez votre agenda Google',
        'validate_json_file' => 'Veuillez définir le fichier JSON des informations d\'identification de votre agenda Google',
        'google_calendar_connect' => 'Google Agenda connecté avec succès',
        'google_calendar_add' => 'calendrier ajouté avec succès',
        'google_calendar_update' => 'Le calendrier Google a été mis à jour avec succès.',
        'disconnect_or_reconnect' => 'Veuillez déconnecter et reconnecter votre agenda Google',
        'google_calendar_disconnect' => 'Calendrier Google déconnecté',
        'select_google_calendar' => 'Sélectionnez vos agendas (depuis Google Calendar) dans lesquels vous souhaitez créer les événements',
        'platform_type' => 'Type de plateforme',
        'google_json_file' => 'Fichier Json de Google',
        'upload_json_file' => 'Veuillez télécharger un fichier JSON.',
        'upload_file' => 'Veuillez télécharger un fichier.',
        'invalid_json_format' => 'Ce format n\'est pas valide, le format valide est JSON.',
        'json_file_saved_successfully' => 'Le fichier Json de Google Calendar a été enregistré avec succès',
    ],

    'footer' => [
        'all_rights_reserved' => 'Tous droits réservés',
    ],

    'open_ai' => [
        'provide_prompt' => 'Veuillez fournir des informations physiques pour être invité.',
        'open_ai_key_not_found' => 'Clé API OpenAI introuvable.',
        'repsonse_retrive_successfully' => 'Réponse récupérée avec succès.',
        'open_ai_key' => 'Ouvrir la clé IA',
        'suggest_medicines' => 'Suggérer des médicaments',
    ],

    'schedule_weekday' => [
        'Monday' => 'Lundi',
        'Tuesday' => 'Mardi',
        'Wednesday' => 'Mercredi',
        'Thursday' => 'Jeudi',
        'Friday' => 'Vendredi',
        'Saturday' => 'Samedi',
        'Sunday' => 'Dimanche',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'LUN',
        'TUE' => 'MAR',
        'WED' => 'ÉPOUSER',
        'THU' => 'JEU',
        'FRI' => 'VEN',
        'SAT' => 'ASSISE',
        'SUN' => 'SOLEIL',
    ],
];
