<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - Spanish Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin' => 'Administradoras',
    'admins' => 'Administradora',
    'roles' => 'Roles',
    'doctor_departments' => 'Departamentos médicos',
    'nurses' => 'Enfermeras',
    'operations' => 'Operaciones',
    'doctors' => 'Doctores',
    'patients' => 'Pacientes',
    'lab_technicians' => 'Técnicos de laboratorio',
    'receptionists' => 'Recepcionistas',
    'pharmacists' => 'Farmacéuticos',
    'accountants' => 'Contador',
    'appointments' => 'Citas',
    'insurances' => 'Seguros',
    'investigation_reports' => 'Informes de investigación',
    'death_reports' => 'Informes de defunción',
    'birth_reports' => 'Informes de nacimiento',
    'operation_reports' => 'Informes de operaciones',
    'medicine_categories' => 'Categorías de medicina',
    'medicine_brands' => 'Marcas de medicina',
    'medicines' => 'Medicamentos',
    'cases' => 'Casos',
    'case_handlers' => 'Manejadores de caso',
    'bed_types' => 'Tipos de cama',
    'beds' => 'Camas',
    'bed_assigns' => 'Asignaciones de cama',
    'packages' => 'Paquetes',
    'schedules' => 'Horarios',
    'schedule_label' => 'Calendario',
    'services' => 'Servicios',
    'accounts' => 'Cuentas',
    'payments' => 'Pagos',
    'bills' => 'Facturas',
    'employee_payrolls' => 'Nóminas de empleados',
    'documents' => 'Documentos',
    'document_types' => 'Tipos de documento',
    'notice_boards' => 'Tablón de anuncios',
    'settings' => 'Configuración',
    'doctors_list' => 'Lista de médicos',
    'my_payrolls' => 'Mis nóminas',
    'blood_banks' => 'Bancos de sangre',
    'blood_donors' => 'Donantes de sangre',
    'invoices' => 'Facturas',
    'patients_cases' => 'Casos de pacientes',
    'patients_case_details' => 'Detalles del caso de las pacientes',
    'account_manager' => 'Administrador de cuenta',
    'bed_management' => 'Gestión de camas',
    'blood_bank' => 'Banco de sangre',
    'billing' => 'Facturación',
    'case_manager' => 'Administrador de casos',
    'cms' => 'CMS',
    'department' => 'Departamento',
    'departments' => 'Departamentos',
    'hospital_activities' => 'Actividades hospitalarias',
    'advanced_payments' => 'Pagos anticipados',
    'patient_admissions' => 'Admisiones de pacientes',
    'appointment_calendar' => 'Nombrar. Calendario',
    'bed_mgt' => 'Administración de la cama',
    'reports' => 'Informes',
    'enquiries' => 'Consultas',
    'mail' => 'Correo',
    'ambulances' => 'ambulancias',
    'ambulance_calls' => 'Llamadas de ambulancia',
    'prescriptions' => 'Recetas',
    'hospital_charges' => 'Cargos Hospitalarios',
    'charge_categories' => 'Categorías de carga',
    'charges' => 'Cargos',
    'radiologies' => 'Radiología',
    'radiology_categories' => 'Radiología Categoría',
    'pathologies' => 'Patología',
    'pathology_categories' => 'Categoría de patología',
    'radiology_tests' => 'Radiología Pruebas',
    'doctor_opd_charges' => 'Doctor OPD Cargos',
    'pathology_tests' => 'Patología Pruebas',
    'expenses' => 'Gastos',
    'income' => 'Ingresos',
    'finance' => 'Finanzas',
    'inventory' => 'Inventario',
    'items_categories' => 'Categorías de artículos',
    'items' => 'Artículos',
    'items_stocks' => 'Existencias de artículos',
    'issued_items' => 'Artículos emitidos',
    'ipd_patients' => 'Pacientes con ENI',
    'ipd_opd' => 'IPD / OPD',
    'ipd_diagnosis' => 'Diagnóstico',
    'ipd_consultant_register' => 'Instrucción del consultor',
    'ipd_consultant_doctor' => 'Consultora doctora',
    'ipd_charges' => 'Cargos',
    'ipd_prescription' => 'Prescripciones',
    'ipd_timelines' => 'Cronologías',
    'ipd_payment' => 'Pago IPD',
    'opd_patients' => 'Pacientes OPD',
    'opd_diagnosis' => 'Diagnóstico de OPD',
    'opd_timeline' => 'Cronología de OPD',
    'call_logs' => 'Registros de llamadas',
    'visitors' => 'Visitantes',
    'front_office' => 'Oficina frontal',
    'postal_receive' => 'Recepción postal',
    'postal_dispatch' => 'Despacho postal',
    'general' => 'General',
    'sidebar_setting' => 'Configuración de módulos',
    'currency_setting' => 'Monedas',
    'testimonials' => 'Testimonios',
    'blood_donations' => 'Donaciones de sangre',
    'blood_issues' => 'Problemas de sangre',
    'live_consultations' => 'Consultas en vivo',
    'vaccinations' => 'Vacunas',
    'vaccinated_patients' => 'Pacientes vacunados',
    'users' => 'Usuarios',
    'front_settings' => 'Configuración frontal',
    'front_service' => 'Servicio frontal',
    'about_us' => 'Acerca de nosotros',
    'make_an_appointment' => 'Concierte una cita',
    'patient_appointment' => 'Cita del paciente',
    'old_patient' => 'Paciente anciano',
    'new_patient' => 'Paciente nuevo',
    'available_slot' => 'Espacio disponible',
    'contact_us' => 'Contáctenos',
    'live_meetings' => 'Reuniones en vivo',
    'live_meeting' => 'Reunión en vivo',
    'hospital_schedule' => 'Horario del hospital',
    'front_cms' => 'cm delantero',
    'front_cms_services' => 'Servicios frontales de CMS',
    'facebook_url' => 'Facebook URL',
    'twitter_url' => 'URL de twitter',
    'instagram_url' => 'URL de Instagram',
    'linkedIn_url' => 'vinculado en_url',
    'allow_file_type' => 'Tipos de archivos permitidos: png, jpg, jpeg.',
    'overview' => 'Visión general',
    'no_data_available' => 'No hay datos disponibles en la tabla',
    'file_name' => 'Nombre del archivo',
    'icon' => 'Icono',
    'short_description' => 'Breve descripción',
    'valid' => 'Válida',
    'no_matching_records_found' => 'No se encontraron registros coincidentes',
    'select_applied_date' => 'Por favor seleccione la fecha de aplicación',
    'select_instruction_date' => 'Por favor seleccione la fecha de instrucción',
    'report' => 'Informe',
    'report_id' => 'ID de informe',
    'yearly_income_expense_chart' => 'Cuadro de gastos de ingresos anuales',
    'sms_mail' => 'SMS/correo',
    'payment_gateways' => 'Pasarelas de Pago',
    'stripe_key' => 'Clave de Stripe',
    'stripe_secret' => 'Secreto de Stripe',
    'paypal' => 'PayPal',
    'paypal_client_id' => 'ID de cliente de PayPal',
    'paypal_secret' => 'Secreto de PayPal',
    'paypal_mode' => 'Modo PayPal',
    'razorpay' => 'Razorpay',
    'razorpay_key' => 'Clave de Razorpay',
    'razorpay_secret' => 'Secreto de Razorpay',
    'cash' => 'Dinero',
    'cheque' => 'Controlar',
    'flutterwave' => 'Onda de aleteo',
    'flutterwave_public_key' => 'Clave pública de Flutterwave',
    'flutterwave_secret_key' => 'Flutterwave Secret Key',
    'phonepe' => 'teléfono pe',
    'paystack' => 'pila de pago',
    'paystack_public_key' => 'Clave pública de la pila de pago',
    'paystack_secret_key' => 'Clave secreta de la pila de pago',
    'phonepe_merchant_id' => 'Identificación del comerciante de Phonepe',
    'phonepe_merchant_user_id' => 'ID de usuario del comerciante de Phonepe',
    'phonepe_env' => 'Entorno telefónico',
    'phonepe_salt_key' => 'Llave de sal de Phonepe',
    'phonepe_salt_index' => 'Índice de sal de fonepe',
    'phonepe_merchant_transaction_id' => 'ID de transacción del comerciante de Phonepe',

    'language' => [
        'Arabic' => 'Arábica',
        'Chinese' => 'Chino',
        'English' => 'inglés',
        'French' => 'Francés',
        'German' => 'Alemán',
        'Portuguese' => 'portugués',
        'Russian' => 'ruso',
        'Spanish' => 'español',
        'Turkish' => 'turco',
    ],

    //roles
    'role' => [
        'new_role' => 'Nuevo rol',
        'edit_role' => 'Editar rol',
        'select_role' => 'Seleccionar rol',
    ],

    //user keys
    'user' => [
        'user' => 'Usuaria',
        'first_name' => 'Nombre',
        'last_name' => 'Apellido',
        'name' => 'Nombre',
        'email' => 'Correo electrónico',
        'phone' => 'Teléfono',
        'designation' => 'Designación',
        'gender' => 'Género',
        'male' => 'Masculino',
        'female' => 'Hembra',
        'qualification' => 'Calificación',
        'dob' => 'Fecha de nacimiento',
        'blood_group' => 'Grupo sanguíneo',
        'select_blood_group' => 'Seleccionar grupo sanguíneo',
        'password' => 'Contraseña',
        'password_confirmation' => 'Confirmar contraseña',
        'address1' => 'Dirección  1',
        'address2' => 'Dirección  2',
        'city' => 'Ciudad',
        'zip' => 'Código Postal',
        'address_details' => 'Detalles de la dirección',
        'address_not_found' => 'No se encontraron detalles de la dirección',
        'education' => 'Educación',
        'status' => 'Estado',
        'edit_profile' => 'Editar perfil',
        'change_password' => 'Cambia la contraseña',
        'logout' => 'Cerrar sesión',
        'new_user' => 'Nuevo usuario',
        'edit_user' => 'Editar usuario',
        'user_details' => 'Detalles de usuario',
        'email_verified_successfully' => 'Correo electrónico verificado con éxito.',
        'invalid_password' => 'La contraseña actual no es válida.',
        'validate_confirm_password' => 'La contraseña y la contraseña de confirmación deben coincidir.',
        'validate_min_character_password' => 'La contraseña debe contener al menos 6 caracteres.',
        'user_list' => 'Lista de Usuarios',
        'validate_image_type' => 'La imagen debe ser un archivo de tipo: jpg, jpeg, png.',
        'validate_image_size' => 'El documento debe ser menor de 10 MB.',
        'validate_facebook_url' => 'Por favor, ingrese una URL de Facebook válida.',
        'validate_twitter_url' => 'Por favor, ingrese una URL de Twitter válida.',
        'validate_instagram_url' => 'Por favor, ingrese una URL de Instagram válida.',
        'validate_linkedin_url' => 'Por favor, ingrese una URL de Linkedin válida.',
        'phone_number_must_be_10_digits' => 'El número de teléfono debe tener 10 dígitos.',
        'valid_email' => 'Por favor introduzca un correo electrónico válido',
    ],

    //common keys
    'common' => [
        'field_required' => 'Se requiere campo.',
        'change' => 'Cambiar',
        'change_profile' => 'Cambiar imagen',
        'is' => 'Es',
        'available_quantity_of' => 'La cantidad disponible de',
        'result' => 'Resultado',
        'profile' => 'Perfil',
        'status' => 'Estado',
        'action' => 'Acción',
        'save' => 'Guardar',
        'cancel' => 'Cancelar',
        'canceled' => 'Cancelada',
        'back' => 'Atrás',
        'created_on' => 'Creado el',
        'last_updated' => 'Última actualización',
        'n/a' => 'N / A',
        'new' => 'Nuevo',
        'total' => 'Total',
        'add' => 'Agregar',
        'active' => 'Activo',
        'name' => 'Nombre',
        'edit' => 'Editar',
        'detail' => 'detalles',
        'delete' => 'Eliminar',
        'view' => 'Ver',
        'view_attachment' => 'Vea el archivo adjunto',
        'de_active' => 'Inactivo',
        'description' => 'Descripción',
        'created_at' => 'Creado el',
        'updated_at' => 'Última actualización',
        'is_available' => 'Está disponible',
        'choose' => 'Escoger',
        'yes' => 'Si',
        'no' => 'No',
        'address' => 'Habla a',
        'export_to_excel' => 'Exportar a Excel',
        'reset' => 'Reiniciar',
        'actions' => 'Comportamiento',
        'confirm' => 'Confirmar',
        'search' => 'Búsqueda',
        'status_updated_successfully' => 'Estado actualizado correctamente.',
        'saved_successfully' => 'Guardado exitosamente.',
        'updated_successfully' => 'actualizado con éxito',
        'deleted_successfully' => 'borrado exitosamente',
        'filter_options' => 'Opciones de filtro',
        'are_you_sure_want_to_delete_this' => '¿Estás segura de que quieres eliminar esto?( ',
        'deleted' => 'Eliminada',
        'has_been_deleted' => 'ha sido eliminado.',
        'cant_be_deleted' => 'no se puede borrar',
        'custom' => 'Disfraz',
        'apply' => 'aplicar',
        'from' => 'de',
        'to' => 'A',
        'invalid_number' => 'Número invalido',
        'invalid_country_code' => 'Código de país no válido',
        'too_short' => 'Demasiado corta',
        'too_long' => 'Demasiado larga',
        'not_found' => 'extraviado',
        'profile' => 'Perfil',
        'status' => 'Estado',
        'action' => 'Acción',
        'save' => 'Guardar',
        'cancel' => 'Cancelar',
        'canceled' => 'Cancelada',
        'back' => 'Atrás',
        'created_on' => 'Creado el',
        'last_updated' => 'Última actualización',
        'n/a' => 'N / A',
        'new' => 'Nuevo',
        'total' => 'Total',
        'add' => 'Agregar',
        'active' => 'Activo',
        'name' => 'Nombre',
        'edit' => 'Editar',
        'delete' => 'Eliminar',
        'view' => 'Ver',
        'view_attachment' => 'Vea el archivo adjunto',
        'de_active' => 'Inactivo',
        'description' => 'Descripción',
        'created_at' => 'Creado el',
        'updated_at' => 'Última actualización',
        'is_available' => 'Está disponible',
        'choose' => 'Escoger',
        'yes' => 'Si',
        'no' => 'No',
        'address' => 'Habla a',
        'export_to_excel' => 'Exportar a Excel',
        'reset' => 'Reiniciar',
        'actions' => 'Comportamiento',
        'confirm' => 'Confirmar',
        'search' => 'Búsqueda',
        'status_updated_successfully' => 'Estado actualizado correctamente.',
        'saved_successfully' => 'Guardado exitosamente.',
        'updated_successfully' => 'actualizado con éxito',
        'deleted_successfully' => 'borrado exitosamente',
        'filter_options' => 'Opciones de filtro',
        'are_you_sure_want_to_delete_this' => '¿Estás segura de que quieres eliminar esto?( ',
        'deleted' => 'Eliminada',
        'has_been_deleted' => 'ha sido eliminado.',
        'cant_be_deleted' => 'no se puede borrar',
        'custom' => 'Disfraz',
        'apply' => 'aplicar',
        'from' => 'de',
        'to' => 'A',
        'invalid_number' => 'Número invalido',
        'invalid_country_code' => 'Código de país no válido',
        'too_short' => 'Demasiado corta',
        'too_long' => 'Demasiado larga',
        'not_found' => 'extraviado',
        'previous' => 'Previous',
        'next' => 'Nest',
        'ok' => 'OK',
        'this_action_is_not_allowed_for_default_record' => 'Esta acción no está permitida para el registro predeterminado.',
        'show' => 'Espectáculo',
        'something_wen_wrong' => 'Algo salió mal',
        'cancelled_successfully' => 'Cancelado exitosamente',
        'invalid_username_password' => 'Nombre de usuario o contraseña no válidos',
        'logged_in_successfully' => 'Inicio de sesión exitoso',
        'logout_successfully' => 'Cierre de sesión exitoso',
        'we_cant_find_user' => 'No podemos encontrar un usuario con esta dirección de correo electrónico',
        'we_have_your_password_resetk_link' => '¡Hemos enviado el enlace de restablecimiento de contraseña a su correo electrónico!',
        'this_password_reset_token_is_invalid' => 'Este token de restablecimiento de contraseña no es válido',
        'password_reset_successfully' => 'Restablecimiento de contraseña exitoso',
        'please_enter_correct_old_password' => 'Por favor, introduzca la contraseña antigua correcta',
        'password_updated' => 'Contraseña actualizada',
        'doctor_scheduled' => 'Cita con el médico programada',
        'not_updated' => 'No actualizado',
        'patient_registered_successfully' => 'Paciente registrado exitosamente',
        'appointment_confirmed_successfully' => 'Cita confirmada exitosamente',
        'bed_assigned_successfully' => 'Cama asignada exitosamente',
        'username_and_password_required' => 'Nombre de usuario y contraseña requeridos',
        'meeting_finished_or_cancelled' => 'Esta reunión ha finalizado o sido cancelada',
        'alreay_exists' => 'Ya existe.',
        'appointment_transaction' => 'Transacción de cita'
    ],

    'hospital_schedules' => [
        'exists_doctor_schedule' => 'Algunos médicos han programado sus días en días no marcados, ¿está seguro de que desea realizar esta operación?',
        'schedule_not_available' => 'Actualmente, el usuario no puede crear un horario de hospital si el horario del hospital no está disponible.',
        'this_day_hospital_is_closed' => 'Este día el hospital está cerrado.',
    ],

    'months' => [
        'jan' => 'enero',
        'feb' => 'Febrero',
        'mar' => 'Marzo',
        'apr' => 'Abril',
        'may' => 'Mayo',
        'jun' => 'Junio',
        'july' => 'Julio',
        'aug' => 'Agosto',
        'sep' => 'Septiembre',
        'oct' => 'Octubre',
        'nov' => 'Noviembre',
        'dec' => 'Diciembre',
    ],

    'weekdays' => [
        'sun' => 'SOL',
        'mon' => 'LUN',
        'tue' => 'MAR',
        'wed' => 'CASARSE',
        'thu' => 'JUE',
        'fri' => 'VIE',
        'sat' => 'SE SENTÓ',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'Recepcionista',
        'receptionists' => 'Recepcionistas',
        'receptionist_details' => 'Detalles del recepcionista',
        'new_receptionist' => 'Nueva recepcionista',
        'edit_receptionist' => 'Editar recepcionista',
        'profile_must_be_image' => 'La imagen de perfil debe ser una imagen.',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'Seguro',
        'insurances' => 'Seguros',
        'insurance_details' => 'Detalles del seguro',
        'new_insurance' => 'Nuevo seguro',
        'edit_insurance' => 'Editar seguro',
        'service_tax' => 'Impuesto de servicio',
        'insurance_no' => 'Seguro no',
        'insurance_code' => 'Código de seguro',
        'hospital_rate' => 'Tarifa hospitalaria',
        'discount' => 'Descuento',
        'remark' => 'Observación',
        'disease_details' => 'Detalles de la enfermedad',
        'diseases_name' => 'Nombre de enfermedades',
        'diseases_charge' => 'Carga de enfermedades',
        'total_amount' => 'Cantidad total',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'Departamentos médicos',
        'doctor_department' => 'Departamento médico',
        'doctor_department_details' => 'Detalles del departamento médico',
        'new_doctor_department' => 'Nuevo departamento médico',
        'edit_doctor_department' => 'Editar departamento médico',
        'title' => 'Título',
        'description' => 'Descripción',
        'doctor_field_required' => 'Se requiere campo médico',
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'Informes de investigación',
        'investigation_report' => 'Informe de investigación',
        'new_investigation_report' => 'Nuevo informe de investigación',
        'investigation_report_details' => 'Detalles del informe de investigación',
        'edit_investigation_report' => 'Editar informe de investigación',
        'patient' => 'Paciente',
        'date' => 'Fecha',
        'title' => 'Título',
        'doctor' => 'Médica',
        'description' => 'Descripción',
        'attachment' => 'Adjunto',
        'birth_date_validation' => 'La fecha del informe de la investigación no debe ser menor que la fecha de nacimiento del paciente.',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'Nuevo farmacéutico',
        'edit_pharmacist' => 'Editar farmacéutico',
        'pharmacists' => 'Farmacéuticos',
        'pharmacist_details' => 'Detalles del farmacéutico',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'Informe de defunción',
        'death_reports' => 'Informes de defunción',
        'new_death_report' => 'Nuevo informe de defunción',
        'edit_death_report' => 'Editar informe de defunción',
        'death_report_details' => 'Detalles del informe de defunción',
        'patient_name' => 'Nombre del paciente',
        'case_id' => 'ID del caso',
        'doctor_name' => 'Nombre del doctor',
        'date' => 'Fecha',
        'description' => 'Descripción',
        'cant_create_report_because_the_patient_has_been_dead' => 'No se puede crear el informe porque el paciente ha fallecido.',
        'data_should_not_be_smaller_than_patient_birth_date' => 'La fecha no debe ser menor que la fecha de nacimiento del paciente.',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'Informe de nacimiento',
        'birth_reports' => 'Informes de nacimiento',
        'birth_report_details' => 'Detalles del informe de nacimiento',
        'new_birth_report' => 'Nuevo informe de nacimiento',
        'edit_birth_report' => 'Editar informe de nacimiento',
        'patient_name' => 'Nombre del paciente',
        'case_id' => 'ID del caso',
        'doctor_name' => 'Nombre del doctor',
        'date' => 'Fecha',
        'description' => 'Descripción',
        'data_should_not_be_smaller_than_patient_birth_date' => 'La fecha no debe ser menor que la fecha de nacimiento del paciente.',
        'patient_birth_date_not_found' => 'Fecha de nacimiento del paciente no encontrada.',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'Nuevo contador',
        'edit_accountant' => 'Editar contador',
        'accountants' => 'Contador',
        'accountant_details' => 'Detalles del contador',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'Nómina de empleados',
        'employee_payrolls' => 'Nóminas de empleados',
        'employee_payroll_details' => 'Detalles de la nómina del empleado',
        'new_employee_payroll' => 'Nueva nómina de empleados',
        'edit_employee_payroll' => 'Editar nómina de empleados',
        'sr_no' => 'No Señor',
        'payroll_id' => 'Id. de nómina',
        'month' => 'Mes',
        'year' => 'Año',
        'role' => 'Papel',
        'employee' => 'Empleado',
        'basic_salary' => 'Salario básico',
        'allowance' => 'Permiso',
        'deductions' => 'Deducciones',
        'net_salary' => 'Salario neto',
        'paid' => 'Pagada',
        'not_paid' => 'No pagado',
        'employee_name' => 'Nombre de empleado',
        'employees_list_not_found' => 'Lista de empleados no encontrada',
        'employee_payroll_deduction' => 'Las deducciones no pueden ser mayores que el salario básico + la asignación',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'Informe de operación',
        'operation_reports' => 'Informes de operaciones',
        'operation_report_details' => 'Detalles del informe de operación',
        'new_operation_report' => 'Nuevo informe de operación',
        'edit_operation_report' => 'Editar informe de operación',
        'patient_name' => 'Nombre del paciente',
        'case_id' => 'ID del caso',
        'doctor_name' => 'Nombre del doctor',
        'date' => 'Fecha',
        'description' => 'Descripción',
        'data_should_not_be_smaller_than_patient_birth_date' => 'La fecha no debe ser menor que la fecha de nacimiento del paciente.',
    ],

    // accounts keys
    'account' => [
        'account' => 'Cuenta',
        'accounts' => 'Cuentas',
        'account_details' => 'Detalles de la cuenta',
        'new_account' => 'Nueva cuenta',
        'edit_account' => 'Editar cuenta',
        'name' => 'Nombre',
        'description' => 'Descripción',
        'type' => 'Tipo',
        'status' => 'Estado',
        'payments' => 'Pagos',
        'credit' => 'Crédito',
        'debit' => 'Débito',
    ],

    // invoices keys
    'invoice' => [
        'invoice_id' => 'ID de factura',
        'invoice' => 'Factura',
        'invoices' => 'Facturas',
        'invoice_details' => 'Detalles de la factura',
        'new_invoice' => 'Nueva factura',
        'edit_invoice' => 'Editar factura',
        'patient' => 'Paciente',
        'invoice_date' => 'Fecha de factura',
        'amount' => 'Cantidad',
        'patient_id' => 'Id. del paciente',
        'discount' => 'Descuento',
        'account_name' => 'Nombre de cuenta',
        'description' => 'Descripción',
        'qty' => 'Cantidad',
        'price' => 'Precio',
        'add' => 'Agregar',
        'sub_total' => 'Subtotal',
        'total' => 'Cantidad total',
        'edit' => 'Editar',
        'hospital_address' => 'Dirección del hospital',
        'paid' => 'Pagada',
        'not_paid' => 'No pagada',
        'print_invoice' => 'Imprimir factura',
        'invoice_date_field_required' => 'El campo de fecha de factura es obligatorio',
        'issue_for' => 'Problema para',
        'issue_from' => 'Emitir desde',
        'patient_overview' => 'RESUMEN DEL PACIENTE',
        'in_percentage' => 'En porcentaje',
    ],

    //nurses
    'nurse' => [
        'nurse' => 'Enfermera',
        'new_nurse' => 'Nueva enfermera',
        'edit_nurse' => 'Editar enfermera',
        'nurse_details' => 'Detalles de la enfermera',
        'phone_no' => 'Número de teléfono',
        'birth_date' => 'Fecha de nacimiento',
        'choose' => 'Escoger',
    ],

    //patient
    'patient' => [
        'new_patient' => 'Nuevo paciente',
        'edit_patient' => 'Editar paciente',
        'patient_details' => 'Detalles del paciente',
        'total_cases' => 'Casos Totales',
        'total_admissions' => 'Admisiones totales',
        'total_appointments' => 'Citas totales',
        'select_one_patient' => 'Por favor seleccione al menos un paciente',
        'patient_name_already_taken' => 'El nombre del paciente ya ha sido tomado',
        'patient_field_required' => 'El campo del paciente es obligatorio.',
    ],

    // payments keys
    'payment' => [
        'payment' => 'Pago',
        'payments' => 'Pagos',
        'payment_details' => 'Detalles de pago',
        'new_payment' => 'Nuevo pago',
        'edit_payment' => 'Editar pago',
        'account_name' => 'Nombre de cuenta',
        'payment_date' => 'Fecha de pago',
        'pay_to' => 'Pagar a',
        'amount' => 'Cantidad',
        'account' => 'Cuenta',
        'description' => 'Descripción',
        'payment_reports' => 'Informes de pago',
        'your_payment_is_successfully_completed' => 'Su pago se ha completado con éxito.',
        'payment_failed' => '¡Lo sentimos! El pago ha fallado. Inténtelo nuevamente más tarde.',
        'flutterwave_not_support' => 'Flutterwave no admite esta moneda.',
        'phonepe_support_inr' => 'PhonePe solo admitía moneda INR.',
        'paystack_support_zar' => 'Paystack solo admitía moneda "USD","GHS","NGN","ZAR","KES".',
        'paystack_token_expired' => 'El token de la pila de pago ha caducado. Actualice la página e inténtelo de nuevo.',
        'currency_not_supported_paypal' => 'PayPal no admite esta moneda para realizar pagos.',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'Pago por adelantado',
        'advanced_payments' => 'Pagos anticipados',
        'advanced_payment_details' => 'Detalles de pago anticipado',
        'new_advanced_payment' => 'Nuevo anticipo',
        'edit_advanced_payment' => 'Editar pago anticipado',
        'patient' => 'Paciente',
        'receipt_no' => 'Recibo No',
        'amount' => 'Cantidad',
        'date' => 'Fecha',
        'patient_name' => 'Nombre del paciente',
    ],

    // beds keys
    'bed' => [
        'bed' => 'Nueva cama',
        'beds' => 'Camas',
        'bed_details' => 'Detalles de la cama',
        'new_bed' => 'Nueva cama',
        'edit_bed' => 'Editar cama',
        'new_bulk_bed' => 'Nueva cama masiva',
        'name' => 'Nombre',
        'bed_type' => 'Tipo de cama',
        'charge' => 'Cargo',
        'available' => 'Disponible',
        'not_available' => 'No disponible',
        'description' => 'Descripción',
        'add' => 'Agregar',
        'bed_id' => 'ID de la cama',
        'select_bed_type' => 'Seleccione tipo de cama',
        'bed_charge' => 'Cargo por cama',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'Tipo de cama',
        'bed_types' => 'Tipos de cama',
        'bed_type_details' => 'Detalles del tipo de cama',
        'new_bed_type' => 'Nuevo tipo de cama',
        'edit_bed_type' => 'Editar tipo de cama',
        'title' => 'Título',
        'description' => 'Descripción',
    ],

    'doctor' => [
        'new_doctor' => 'Nuevo doctor',
        'edit_doctor' => 'Editar Doctor',
        'doctor_details' => 'Detalles del médico',
        'specialist' => 'Especialista',
        'doctor_name_already_taken' => 'El nombre del doctor ya ha sido tomado.',
        'appointment_charge' => 'Cargo por cita',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'Asignación de cama',
        'bed_assigns' => 'Asignaciones de cama',
        'bed_assign_details' => 'Detalles de asignación de cama',
        'new_bed_assign' => 'Nueva asignación de cama',
        'edit_bed_assign' => 'Editar asignación de cama',
        'patient_name' => 'Nombre del paciente',
        'bed_name' => 'Nombre de cama',
        'case_id' => 'ID del caso',
        'assign_date' => 'Asignar fecha',
        'discharge_date' => 'Fecha de alta',
        'bed' => 'Cama',
        'description' => 'Descripción',
        'assigned' => 'Asignada',
        'not_assigned' => 'No asignado',
        'ipd_patient_id' => 'ID de paciente de IPD',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'La fecha de asignación no debe ser menor que la fecha de nacimiento del paciente.',
        'ipd_patient_department_field_required' => 'El campo del departamento de pacientes de IPD es obligatorio',
    ],

    // packages keys
    'package' => [
        'package' => 'Paquete',
        'packages' => 'Paquetes',
        'package_details' => 'Detalles del paquete',
        'new_package' => 'Nuevo paquete',
        'edit_package' => 'Editar paquete',
        'name' => 'Nombre',
        'description' => 'Descripción',
        'discount' => 'Descuento',
        'total_amount' => 'Cantidad total',
        'service' => 'Servicio',
        'qty' => 'Cantidad',
        'rate' => 'Velocidad',
        'amount' => 'Cantidad',
        'select_service' => 'Seleccionar servicio',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'Imprimir factura',
        'bill_id' => 'ID de factura',
        'bill' => 'Factura',
        'bills' => 'Facturas',
        'bill_details' => 'Detalles de la factura',
        'new_bill' => 'Nueva factura',
        'edit_bill' => 'Editar factura',
        'patient' => 'Paciente',
        'bill_date' => 'Fecha de factura',
        'amount' => 'Cantidad',
        'admission_id' => 'ID de admisión',
        'patient_name' => 'Nombre del paciente',
        'patient_email' => 'Correo electrónico del paciente',
        'patient_cell_no' => 'Número de celda del paciente',
        'patient_gender' => 'Sexo del paciente',
        'patient_dob' => 'DOB del paciente',
        'doctor_name' => 'Nombre del doctor',
        'admission_date' => 'Fecha de admisión',
        'discharge_date' => 'Fecha de alta',
        'package_name' => 'Nombre del paquete',
        'insurance_name' => 'Nombre del seguro',
        'total_days' => 'Total de días',
        'policy_no' => 'No política',
        'item_name' => 'Nombre del elemento',
        'qty' => 'Cantidad',
        'price' => 'Precio',
        'add' => 'Agregar',
        'total_amount' => 'Cantidad total',
        'edit' => 'Editar',
        'cell_no' => 'Celda no',
        'bill_summary' => 'Resumen de la factura',
        'generate_bill' => 'Generar factura',
        'update_bill' => 'Actualizar factura',
        'calculate' => 'Calcular',
        'manual_bill' => 'Pagos de facturación manuales',
        'transaction_date' => 'Fecha de Transacción',
        'paymentrequest_sent' => 'Solicitud de pago enviada correctamente',
        'manually' => 'A mano',
        'stripe' => 'Raya',
        'approved' => 'Aprobado',
        'rejected' => 'Rechazado',
        'are_you_sure' => '¿Está seguro?',
        'complete_this_payment' => '¡¡Quieres completar este pago manualmente!!',
        'session_id_required' => 'ID de sesión requerido',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'Donante de sangre',
        'blood_donors' => 'Donantes de sangre',
        'blood_donor_details' => 'Detalles del donante de sangre',
        'new_blood_donor' => 'Nuevo donante de sangre',
        'edit_blood_donor' => 'Editar donante de sangre',
        'name' => 'Nombre',
        'age' => 'Edad',
        'gender' => 'Género',
        'blood_group' => 'Grupo sanguíneo',
        'donation_date' => 'Fecha de donación',
        'last_donation_date' => 'Última fecha de donación',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'Banco de sangre',
        'blood_banks' => 'Bancos de sangre',
        'blood_bank_details' => 'Detalles del banco de sangre',
        'new_blood_group' => 'Nuevo grupo sanguíneo',
        'edit_blood_group' => 'Editar grupo sanguíneo',
        'blood_group' => 'Grupo sanguíneo',
        'remained_bags' => 'Bolsas restantes',
    ],

    //Case
    'case' => [
        'case' => 'Caso',
        'case_date' => 'Fecha del caso',
        'new_case' => 'Nuevo caso',
        'edit_case' => 'Editar caso',
        'case_details' => 'Detalles del caso',
        'phone' => 'Teléfono',
        'fee' => 'Tarifa',
        'patient' => 'Paciente',
        'doctor' => 'Médico',
        'case_id' => 'ID del caso',
        'date' => 'Fecha',
        'description' => 'Descripción',
        'case_date_should_not_be_smaller_than_patient_birth_date' => 'La fecha del caso no debe ser anterior a la fecha de nacimiento del paciente.',
    ],

    //services
    'service' => [
        'service' => 'Dienstleistung',
        'new_service' => 'Nuevo servicio',
        'edit_service' => 'Editar servicio',
        'service_details' => 'Detalles del servicio',
        'quantity' => 'Cantidad',
        'rate' => 'Velocidad',
        'given' => 'Dada',
        'not_given' => 'No dado',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'Nueva cita',
        'edit_appointment' => 'Editar cita',
        'appointment_details' => 'Detalles de la cita',
        'calendar_view' => 'Vista de calendario',
        'patient_name' => 'Nombre del paciente',
        'doctor_name' => 'Nombre del doctor',
        'department_name' => 'Nombre del departamento',
        'date' => 'Fecha',
        'doctor_department' => 'Departamento médico',
        'doctor_department_name' => 'Nombre del departamento médico',
        'doctor' => 'Médica',
        'description' => 'Descripción',
        'patient' => 'Paciente',
        'appointment_calendar' => 'Calendario de citas',
        'appointment_list' => 'Lista de citas',
        'completed' => 'Terminado',
        'pending' => 'Pendiente',
        'available_slot' => 'Espacio disponible',
        'no_available' => 'No disponible',
        'today' => 'Hoy',
        'month' => 'Mes',
        'week' => 'Semana',
        'day' => 'Día',
        'opd_date' => 'Fecha de opd',
        'yesterday' => 'El dia de ayer',
        'this_week' => 'Esta semana',
        'last_7_days' => 'Los últimos 7 días',
        'last_30_days' => 'últimos 30 días',
        'this_month' => 'Este mes',
        'last_month' => 'El mes pasado',
        'change_status' => 'Cambiar Estado',
        'are_you_sure_want_to_change' => 'Estas segura de querer cambiar',
        'changed_appointment' => 'Cita cambiada',
        'has_been_changed' => 'Ha sido cambiada.',
        'are_you_sure_want_to_cancel' => 'Seguro que quieres cancelar',
        'has_been_cancelled' => 'ha sido cancelado.',
        'please_select_doctor_department' => 'Por favor seleccione Departamento Médico',
        'please_select_doctor' => 'Por favor seleccione doctora',
        'doctor_schedule_not_available_on_this_date' => 'Horario médico no disponible esta fecha.',
        'please_select_appointment_time_slot' => 'Seleccione la franja horaria de la cita',
        'patient_not_exists_or_status_is_not_active' => 'La paciente no existe o el estado no está activo.',
        'appointment_exists' => 'El correo electrónico del paciente ya existe',
        'old_patient_email_exists' => 'El correo electrónico ya existe, seleccione paciente antiguo.',
        'time' => 'Tiempo',

    ],

    'case_handler' => [
        'case_handler' => 'Manejador de casos',
        'new_case_handler' => 'Nuevo manejador de casos',
        'edit_case_handler' => 'Editar manejador de casos',
        'case_handler_detail' => 'Detalles del manejador de casos',
    ],

    'lab_tech' => [
        'lab_technician' => 'Técnica de laboratorio',
        'new_lab_tech' => 'Nuevo técnico de laboratorio',
        'edit_lab_tech' => 'Editar técnico de laboratorio',
        'lab_tech_detail' => 'Detalles del técnico de laboratorio',
    ],

    'doc_type' => [
        'new_doc_type' => 'Nuevo tipo de documento',
        'edit_doc_type' => 'Editar tipo de documento',
        'name' => 'Nombre',
    ],

    'document' => [
        'document' => 'Documento',
        'new_document' => 'Nuevo documento',
        'edit_document' => 'Editar documento',
        'title' => 'Título',
        'document_type' => 'Tipo de documento',
        'document_type_details' => 'Detalles del tipo de documento',
        'patient' => 'Paciente',
        'download' => 'Descargar',
        'select_patient' => 'Seleccionar paciente',
        'select_document_type' => 'Seleccionar tipo de documento',
        'document_detail' => 'Detalles del Documento',
        'notes' => 'Notas',
        'attachment' => 'Adjunto archivo',
        'uploaded_by' => 'Subido por',
        'validate_doc_type' => 'Das Dokument muss eine Datei vom Typ: jpeg, jpg, png, pdf, doc, docx, webp sein.',
        'select_attachment' => 'Por favor seleccione archivo adjunto.',
    ],

    'patient_admission' => [
        'patient_admission' => 'Admisión de pacientes',
        'new_patient_admission' => 'Admisión de pacientes nuevos',
        'edit_patient_admission' => 'Editar admisión del paciente',
        'details' => 'Detalles de admisión del paciente',
        'patient' => 'Paciente',
        'patient_name' => 'Nombre del paciente',
        'doctor' => 'Médica',
        'doctor_name' => 'Nombre del doctor',
        'admission_date' => 'Fecha de admisión',
        'discharge_date' => 'Fecha de alta',
        'package' => 'Paquete',
        'package_name' => 'Nombre del paquete',
        'insurance' => 'Seguro',
        'insurance_name' => 'Nombre del seguro',
        'policy_no' => 'No política',
        'bed' => 'Cama',
        'agent_name' => 'Nombre del agente',
        'guardian_name' => 'Nombre del guardián',
        'guardian_relation' => 'Relación de tutor',
        'guardian_contact' => 'Contacto de tutor',
        'guardian_address' => 'Dirección del tutor',
        'patient_admission_id' => 'ID de admisión del paciente',
        'admission_date_should_not_be_smaller_than_patient_birth_date' => 'Das Eintrittsdatum sollte nicht vor dem Geburtsdatum des Patienten liegen.',
        'Admission_field_required' => 'El campo ID de admisión es obligatorio.',
    ],

    'setting' => [
        'app_name' => 'Nombre de la Aplicación',
        'company_name' => 'Nombre de la Compañía',
        'app_logo' => 'Logotipo de la Aplicación',
        'currency' => 'Moneda Actual',
        'address' => 'Dirección del Hospital',
        'hospital_email' => 'Correo Electrónico del Hospital',
        'hospital_phone' => 'Teléfono del Hospital',
        'hospital_from_day' => 'Día de Inicio del Hospital',
        'hospital_from_time' => 'Hora de Inicio del Hospital',
        'about_us' => 'Acerca de Nosotros',
        'image_validation' => 'La imagen debe tener dimensiones de 90 x 60 píxeles.',
        'favicon' => 'Favicon',
        'favicon_validation' => 'La imagen debe tener dimensiones de 34 x 34 píxeles.',
        'social_details' => 'Detalles Sociales',
        'country_code' => 'Código de País',
        'default_language' => 'Idioma predeterminado',
    ],

    'currency' => [
        'currency' => 'Divisa',
        'new_currency' => 'Nueva moneda',
        'edit_currency' => 'Editar moneda',
        'currency_name' => 'Nombre de moneda',
        'currency_code' => 'Código de moneda',
        'currency_icon' => 'Icono de moneda',
        'add_currency_code_as_per_three_letter_iso_code' => 'Agregue el código de moneda según el código ISO de tres letras',
        'you_can_find_out_here' => 'puedes averiguarlo aquí',
        'currency_setting_not_found' => 'Währungseinstellung nicht gefunden.',
    ],

    'schedule' => [
        'new' => 'Nuevo horario',
        'edit' => 'Editar horario',
        'details' => 'Detalles de programación',
        'doctor_name' => 'Nombre del doctor',
        'select_doctor_name' => 'Seleccionar nombre del médico',
        'per_patient_time' => 'Tiempo por paciente',
        'serial_visibility' => 'Visibilidad en serie',
        'select_serial_visibility' => 'Seleccionar visibilidad en serie',
        'available_on' => 'Disponible el',
        'available_from' => 'Disponible desde',
        'available_to' => 'Disponible para',
        'sequential' => 'Secuencial',
        'timestamp' => 'Marca de tiempo',
        'schedule_time_select' => 'Por favor, seleccione la hora por paciente',
        'schedule_time' => 'La hora disponible debe ser mayor que la hora de programación del hospital',
        'available_time_greater_than_zero' => 'La hora disponible debe ser mayor que cero',
        'available_to_time_greater_than_zero' => 'La hora disponible hasta debe ser mayor que cero',
        'available_time_less_than_hospital_schedule_time' => 'La hora disponible hasta debe ser menor que la hora de programación del hospital',
    ],

    'notice_board' => [
        'notice_board' => 'Tablón de anuncios',
        'new' => 'Nuevo tablón de anuncios',
        'edit' => 'Editar tablón de anuncios',
        'details' => 'Detalles del tablón de anuncios',
        'title' => 'Título',
        'description' => 'Descripción',
        'created_at' => 'Creado en',
    ],

    'my_payroll' => [
        'my_payrolls' => 'Mis nóminas',
        'basic_salary' => 'Salario básico',
        'allowance' => 'Permiso',
        'deductions' => 'Deducciones',
        'net_salary' => 'Salario neto',
    ],

    'medicine' => [
        'medicine' => 'Medicina',
        'medicine_category' => 'Categoría de medicina',
        'medicine_category_details' => 'Detalles de la categoría de medicina',
        'medicines' => 'Medicamentos',
        'medicine_details' => 'Detalles de la medicina',
        'new_medicine' => 'Nueva medicina',
        'new_medicine_category' => 'Nueva categoría de medicina',
        'edit_medicine_category' => 'Editar categoría de medicina',
        'edit_medicine' => 'Editar medicina',
        'name' => 'Nombre',
        'brand' => 'Marca',
        'selling_price' => 'Precio de venta',
        'buying_price' => 'Precio de compra',
        'category' => 'Categoría',
        'salt_composition' => 'Composición de sal',
        'side_effects' => 'Efectos secundarios',
        'description' => 'Descripción',
        'category_id' => 'Id. de categoría',
        'brand_name' => 'Nombre de la marca',
        'medicine_brands_details' => 'Detalles de la marca de medicina',
        'new_brand' => 'Marca nueva',
        'new_medicine_brand' => 'Nueva marca de medicina',
        'edit_medicine_brand' => 'Editar marca de medicina',
        'medicine_brands' => 'Marcas de medicamentos',
        'medicine_brands_details' => 'Detalles de Marca de Medicamento',
        'new_brand' => 'Nueva Marca',
        'new_medicine_brand' => 'Nueva Marca de Medicamento',
        'edit_medicine_brand' => 'Editar Marca de Medicamento',
        'select_category' => 'Seleccionar Categoría',
        'select_brand' => 'Seleccionar Marca',
        'is_active' => '¿Está activo?',
        'delete_medicine' => 'Este medicamento ya se usa en facturas de medicamentos, ¿estás seguro de que quieres eliminarlo?',
        'category_field_required' => 'El campo Categoría es obligatorio',
        'brand_field_required' => 'El campo Marca es obligatorio.',
    ],

    'profile' => [
        'change_language' => 'Cambiar idioma',
        'language' => 'Idioma',
        'edit_profile' => 'Editar perfil',
        'first_name' => 'Primer nombre',
        'last_name' => 'Apellido',
        'email' => 'Correo electrónico',
        'phone' => 'Teléfono',
        'profile' => 'Perfil',
    ],

    'dashboard' => [
        'dashboard' => 'Tablero',
        'total_invoices' => 'Monto de la factura',
        'total_bills' => 'Total de la factura',
        'total_payments' => 'Monto del pago',
        'total_advance_payments' => 'Monto de anticipo',
        'notice_boards' => 'Tablones de anuncios',
        'title' => 'Título',
        'doctors' => 'Doctoras',
        'available_beds' => 'Camas disponibles',
        'patients' => 'Pacientes',
        'income_and_expense_report' => 'Informe de ingresos y gastos',
        'income_and_expense_reports' => 'Informes de ingresos y gastos',
        'no_enquiries_yet' => 'Aún no hay consultas',
        'no_notice_yet' => 'Sin aviso todavía',
        'total_appointment' => 'Total de citas',
        'today_appointment' => 'Cita de hoy',
        'total_meeting' => 'Total de reuniones',
        'sum_of_ipd' => 'Monto adeudado por IPD',
        'recent_appointments' => 'Nombramientos recientes',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'Nombre',
        'email' => 'Email',
        'contact' => 'Contacto',
        'type' => 'Tipo',
        'message' => 'Mensaje',
        'viewed_by' => 'Visto por',
        'enquiry_details' => 'Detalles de la consulta',
        'read' => 'Leer',
        'unread' => 'No leída',
        'not_viewed' => 'No vista',
        'received_on' => 'Recibido el',
        'send_enquiry' => 'Enviar consulta',
        'enquiry_send_successfully' => 'Consulta enviada con éxito',
    ],

    'email' => [
        'to' => 'A',
        'subject' => 'Sujeta',
        'message' => 'Mensaje',
        'attachment' => 'Archivos adjuntos',
    ],

    'verification' => [
        'verify_your_email_address' => 'Verifique su dirección de correo electrónico.',
        'verify_message' => 'Antes de continuar, verifique su correo electrónico para obtener un enlace de verificación. Si no recibió el correo electrónico,',
        'another_verify_request' => 'haga clic aquí para solicitar otro',
        'click_button_for_verify_email' => 'Haga clic en el botón a continuación para verificar su dirección de correo electrónico.',
        'further_action_required' => 'Si no creó una cuenta, no es necesario realizar ninguna otra acción.',
        'verify_email_address' => 'Confirme su dirección de correo electrónico',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'ambulancia',
        'ambulances' => 'ambulancias',
        'ambulance_details' => 'Detalles de ambulancia',
        'vehicle_number' => 'Numero de Vehículo',
        'vehicle_model' => 'Modelo de vehículo',
        'year_made' => 'Año hecho',
        'driver_name' => 'Nombre del conductor',
        'driver_license' => 'Licencia de conducir',
        'driver_contact' => 'Contacto del conductor',
        'note' => 'nota',
        'vehicle_type' => 'tipo de vehiculo',
        'is_available' => 'Está disponible',
        'new_ambulance' => 'Nueva ambulancia',
        'edit_ambulance' => 'Editar ambulancia',
    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'Llamada de ambulancia',
        'ambulance_calls' => 'Llamadas de ambulancia',
        'ambulance_call_details' => 'Detalles de la llamada de ambulancia',
        'vehicle_model' => 'Modelo de vehículo',
        'patient' => 'Paciente',
        'driver_name' => 'Nombre del conductor',
        'date' => 'Fecha',
        'amount' => 'Cantidad',
        'new_ambulance_call' => 'Nueva llamada de ambulancia',
        'edit_ambulance_call' => 'Editar llamada de ambulancia',
    ],

    // prescription keys
    'prescription' => [
        'reference_id' => 'Identificación de referencia',
        'prescription' => 'Prescripción',
        'prescriptions' => 'Recetas',
        'prescription_details' => 'Detalles de prescripción',
        'new_prescription' => 'Nueva receta',
        'edit_prescription' => 'Editar receta',
        'patient' => 'Paciente',
        'food_allergies' => 'Alergias a los alimentos',
        'tendency_bleed' => 'Sangrado de tendencia',
        'heart_disease' => 'Enfermedad del corazón',
        'high_blood_pressure' => 'Alta presión sanguínea',
        'diabetic' => 'Diabética',
        'surgery' => 'Cirugía',
        'accident' => 'Accidente',
        'others' => 'Otras',
        'medical_history' => 'Agregado en',
        'current_medication' => 'Medicación actual',
        'female_pregnancy' => 'Embarazo femenino',
        'breast_feeding' => 'Lactancia materna',
        'health_insurance' => 'Seguro de salud',
        'low_income' => 'De bajos ingresos',
        'reference' => 'Referencia',
        'physical_information' => 'Información Física',
        'new_medicine' => 'nueva medicina',
        'plus_rate' => 'Legumbres adicional',
        'temperature' => 'la temperatura',
        'problem_description' => 'Descripción del problema',
        'test' => 'prueba',
        'advice' => 'consejo',
        'next_visit' => 'siguiente visita',
        'time' => 'tiempo',
        'comment' => 'comentario',
        'problem' => 'problema',
        'rx' => 'Rx',
        'medicine_name' => 'nombre_medicamento',
        'duration' => 'Duración',
        'days' => 'días',
        'after_meal' => 'después de comer',
        'before_meal' => 'Antes de la comida',
        'year' => 'AÃ±o',
        'month' => 'Mes',
        'no_data_available' => 'datos no encontrados',
    ],

    'charge_category' => [
        'charge_categories' => 'Categorías de carga',
        'new_charge_category' => 'Nueva categoría de carga',
        'edit_charge_category' => 'Editar categoría de carga',
        'charge_type' => 'Tipo de carga',
        'charge_category_details' => 'Detalles de la categoría de carga',
    ],

    'charge' => [
        'new_charge' => 'Nueva carga',
        'edit_charge' => 'Editar carga',
        'charge_details' => 'Detalles de carga',
        'charge_category' => 'Cargo estándar',
        'standard_charge' => 'Standard Charge',
        'code' => 'Código',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'Nombre',
        'radiology_categories' => 'Radiología Categorias',
        'new_radiology_category' => 'Nueva Radiología Categoría',
        'edit_radiology_category' => 'Editar Radiología Categoría',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'Categorías de patología',
        'new_pathology_category' => 'Nueva Patología Categoría',
        'edit_pathology_category' => 'Editar Patología Categoría',
        'name' => 'Nombre',
        'select_charge_category' => 'seleccionar categoría de cargo',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'Radiología Pruebas',
        'new_radiology_test' => 'Nueva Radiología Prueba',
        'edit_radiology_test' => 'Editar Radiología Prueba',
        'radiology_test_details' => 'Radiología Prueba Detalles',
        'test_name' => 'Prueba Nombre',
        'short_name' => 'Corta Nombre',
        'test_type' => 'Prueba Tipo',
        'category_name' => 'Categoría Nombre',
        'subcategory' => 'Sub Categoría',
        'report_days' => 'Reporte Dias',
        'charge_category' => 'Cargar Categoría',
        'code' => 'código',
        'standard_charge' => 'Estándar Cargar',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'doctor_opd_charge' => 'Doctora OPD Cargo',
        'new_doctor_opd_charge' => 'Nuevo Doctor Cargo OPD',
        'edit_doctor_opd_charge' => 'Editar Doctor OPD Cargo',
        'doctor_name' => 'Nombre Del Doctor',
        'standard_charge' => 'Cargo Estándar',
        'doctor' => 'Médico',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'Patología Pruebas',
        'new_pathology_test' => 'Nueva Patología Prueba',
        'edit_pathology_test' => 'Editar Patología Prueba',
        'pathology_test_details' => 'Patología Prueba Detalles',
        'test_name' => 'Prueba Nombre',
        'short_name' => 'Corto Nombre',
        'test_type' => 'Prueba Type',
        'category_name' => 'Categoría Nombre',
        'unit' => 'Unidad',
        'subcategory' => 'Subcategoría',
        'method' => 'Método',
        'report_days' => 'Informar días',
        'charge_category' => 'Categoría de carga',
        'standard_charge' => 'Cargo estándar',
    ],

    //expenses keys
    'expense' => [
        'expense' => 'Gastos',
        'new_expense' => 'Nuevo Gasto',
        'edit_expense' => 'Editar Gasto',
        'expense_head' => 'Jefe de Gastos',
        'name' => 'Nombre',
        'date' => 'Fecha',
        'invoice_number' => 'Numero de Factura',
        'amount' => 'Cantidad',
        'attachment' => 'Adjunto Archivo',
        'description' => 'descripción',
        'choose' => 'Escoger',
        'download' => 'Descargar',
        'expense_details' => 'Detalles de Gastos',
        'select_expense_head' => 'Seleccionar Cabeza de Gastos',
        'document_error' => 'Das Dokument muss eine Dateityp sein: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'Ingresos',
        'new_income' => 'Neues Einkommen',
        'edit_income' => 'Einkommen bearbeiten',
        'income_head' => 'Einkommensleiter',
        'name' => 'Nombre',
        'date' => 'Fecha',
        'invoice_number' => 'Numero de Factura',
        'amount' => 'Cantidad',
        'attachment' => 'Adjunto Archivo',
        'description' => 'descripción',
        'choose' => 'Escoger',
        'download' => 'Descargar',
        'income_details' => 'Detalles de Ingresos',
        'select_income_head' => 'Wählen Sie Income Head',
        'document_error' => 'Das Dokument muss eine Dateityp sein: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Estado de la cama',
        'assigned_beds' => 'Camas asignadas',
        'available_beds' => 'Camas disponibles',
        'bed_name' => 'Nombre de cama',
        'patient_name' => 'Nombre del paciente',
        'phone' => 'Teléfono',
        'admission_date' => 'Fecha de admisión',
        'gender' => 'Género',
    ],

    //Messages keys
    'message' => [
        'message' => 'Mensaje',
        'messages' => 'Mensajes',
        'send_to' => 'Enviar a',
        'subject' => 'Sujeto',
        'new_message' => 'Nuevo mensaje',
        'messages_details' => 'Detalles del mensaje',
        'sender_name' => 'Nombre del remitente',
        'date' => 'Fecha',
        'select_user' => 'Seleccionar usuario',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'SMS',
        'new_sms' => 'SMS nuevo',
        'send_to' => 'Enviar a',
        'phone_number' => 'Número de Teléfono',
        'send_by' => 'Enviado Por',
        'message' => 'Mensaje',
        'sms_details' => 'Detalles de SMS',
        'date' => 'Fecha',
        'send' => 'Enviar',
        'role' => 'Papel',
        'send_sms_by_number_directly' => 'Envía SMS por número directamente',
        'only_user_with_registered_phone_will_display' => '(Solo se mostrarán los usuarios con un teléfono registrado).',
        'message_not_greater_than_160_characters' => 'El mensaje no puede superar los 160 caracteres.',
        'set_credential' => 'Por favor, configure sus credenciales.',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'Diagnóstico',
        'diagnosis_test' => 'Pruebas de diagnóstico',
        'patient_diagnosis_test' => 'Pruebas de diagnóstico del paciente',
        'report_number' => 'Numero de reporte',
        'patient' => 'Paciente',
        'doctor' => 'Médico',
        'created_at' => 'Creado en',
        'action' => 'Acción',
        'new_patient_diagnosis_test' => 'Nueva prueba de diagnóstico del paciente',
        'edit_patient_diagnosis_test' => 'Editar prueba de diagnóstico del paciente',
        'create_patient_diagnosis_test' => 'Crear prueba de diagnóstico del paciente',
        'patient_diagnosis_test_details' => 'Detalles de la prueba de diagnóstico del paciente',
        'diagnosis_category' => 'Categoría de diagnóstico',
        'add_other_diagnosis_property' => 'Agregar otra propiedad de diagnóstico',
        'other_diagnosis_property' => 'Otra propiedad de diagnóstico',
        'diagnosis_property_name' => 'Nombre de la propiedad de diagnóstico',
        'diagnosis_property_value' => 'Valor de la propiedad de diagnóstico',
        'patient_name' => 'Nombre del paciente',
        'doctor_name' => 'Nombre del doctor',
        'age' => 'Alter',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'average_glucose' => 'Durchschnittliche Glukose',
        'fasting_blood_sugar' => 'Blutzucker nüchtern',
        'urine_sugar' => 'Urin Zucker',
        'blood_pressure' => 'Blutdruck',
        'diabetes' => 'Diabetes',
        'cholesterol' => 'Cholesterin',
        'print_diagnosis_test' => 'Prueba de diagnóstico de impresión',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'Categoría de diagnóstico',
        'diagnosis_categories' => 'Categoría de diagnóstico',
        'new_diagnosis_category' => 'Nueva categoría de diagnóstico',
        'description' => 'Descripción',
        'category_name' => 'Nombre de la categoría',
        'diagnosis_category_details' => 'Detalles de la categoría de diagnóstico',
        'edit_diagnosis_category' => 'Editar categoría de diagnóstico',
    ],

    // Operation Category
    'operation_category' => [
        'operation_category' => 'Categoría de operación',
        'operation_categories' => 'Categorías de operaciones',
        'new_operation_category' => 'Nueva categoría de operación',
        'edit_operation_category' => 'Editar categoría de operación',
        'operation_category_field_required' => 'El campo de categoría de operación es obligatorio.',
    ],

    // Operation
    'operation' => [
        'operation' => 'Operación',
        'operation_field_required' => 'El campo de operación es obligatorio.',
        'select_operation_date' => 'Por favor seleccione la fecha de operación.',
        'operation_date' => 'Fecha de operación',
        'operation_name' => 'Nombre de la operación',
        'operation_category_name' => 'Categoría de operación Nombre',
        'ot_technician' => 'Técnico OT',
        'ot_assistant' => 'Asistente de TO',

    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'Categoría de artículo',
        'item_categories' => 'Categorías de artículos',
        'new_item_category' => 'Nueva Categoría de artículo',
        'edit_item_category' => 'Editar Categoría de artículo',
        'name' => 'Nombre',
    ],

    'item' => [
        'item' => 'Articulo',
        'items' => 'Artículos',
        'new_item' => 'Nuevo artículo',
        'edit_item' => 'Editar artículo',
        'item_details' => 'detalles del artículo',
        'name' => 'Nombre',
        'item_category' => 'Categoría de artículo',
        'unit' => 'Unidad',
        'description' => 'Descripción',
        'available_quantity' => 'Cantidad disponible',
    ],

    'item_stock' => [
        'item_stock' => 'Stock del artículo',
        'item_stocks' => 'Existencias de artículos',
        'new_item_stock' => 'Stock de artículos nuevos',
        'edit_item_stock' => 'Editar stock de artículos',
        'item_stock_details' => 'Detalles de stock del artículo',
        'item_category' => 'Categoría de artículo',
        'item' => 'Articulo',
        'supplier_name' => 'Nombre del proveedor',
        'store_name' => 'Nombre de la tienda',
        'quantity' => 'Cantidad',
        'purchase_price' => 'Precio de compra',
        'description' => 'Descripción',
        'attachment' => 'Adjunto archivo',
    ],

    'issued_item' => [
        'issued_item' => 'Artículo emitido',
        'issued_items' => 'Artículos emitidos',
        'new_issued_item' => 'Nuevo artículo emitido',
        'edit_issued_item' => 'Editar artículo emitido',
        'issued_item_details' => 'Detalles de artículos emitidos',
        'department_id' => 'Tipo de usuario',
        'user_id' => 'Emitido a',
        'issued_by' => 'Problema por',
        'issued_date' => 'Fecha de asunto',
        'return_date' => 'Fecha de regreso',
        'item_category' => 'Categoría de artículo',
        'item' => 'Articulo',
        'quantity' => 'Cantidad',
        'description' => 'Descripción',
        'available_quantity' => 'Cantidad disponible',
        'item_return' => 'Devolver objeto',
        'item_returned' => 'Devuelto',
        'are_you_sure_want_to_return_this_item' => '¿Estás segura de que quieres devolver este artículo?',
        'quantity_cannot_be_zero' => 'Die Menge darf nicht null sein.',
        'quantity_must_be_less_than_available_quantity' => 'Die Menge muss kleiner sein als die verfügbare Menge.',
    ],

    'ipd_patient' => [
        'ipd_patient_in' => 'IPD - Entrada de paciente',
        'ipd_patient' => 'Paciente con DPI',
        'ipd_patients' => 'Pacientes con ENI',
        'new_ipd_patient' => 'Nuevo paciente IPD',
        'edit_ipd_patient' => 'Editar paciente de DPI',
        'ipd_patient_details' => 'Detalles del paciente IPD',
        'patient_id' => 'Paciente',
        'ipd_number' => 'IPD No',
        'height' => 'Altura',
        'weight' => 'Peso',
        'bp' => 'Presión arterial',
        'symptoms' => 'Síntomas',
        'notes' => 'Notas',
        'admission_date' => 'Fecha de admisión',
        'case_id' => 'Caso',
        'is_old_patient' => 'Es viejo paciente',
        'doctor_id' => 'Médico',
        'bed_type_id' => 'Tipo de cama',
        'bed_id' => 'Cama',
        'bill_status' => 'Estado de la factura',
        'the_case_field_is_required' => 'El campo del caso es obligatorio.',
        'the_bed_field_is_required' => 'El campo de la cama es obligatorio.',
        'the_bed_field_has_a_duplicate_value' => 'El campo de la cama tiene un valor duplicado.',
        'the_bed_already_taken' => 'La cama: la entrada ya ha sido tomada',
        'the_bed_type_is_required' => 'El campo tipo de cama es obligatorio.',
        'charge_required' => 'Campo de cargo Obligatorio.',
        'discharge' => 'Descargar',
        'net_amount' => 'Importe neto',
        'discharged' => 'Descargado',
        'not_dischared' => 'No descargada',
        'discharge_slip' => 'Resbalón de descarga',
        'print_discharge_slip' => 'Imprimir recibo de alta',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'Agregar diagnóstico',
        'edit_ipd_diagnosis' => 'Editar diagnóstico',
        'report_type' => 'Tipo de informe',
        'report_date' => 'Fecha del informe',
        'document' => 'Documento',
        'description' => 'Descripción',
    ],

    'front_services' => [
        'new_service' => 'Nuevo servicio',
        'edit_service' => 'Editar servicio',
        'select_icon_file' => 'Por favor seleccione el archivo de icono',
    ],

    'ipd_operation' => [
        'ipd_operation' => 'IPD-Operation',
        'ipd_operation_created_successfully' => 'IPD-Operation erfolgreich erstellt',
        'operation_field_required' => 'El campo de operación es obligatorio.',
        'select_operation_date' => 'Por favor seleccione la fecha de operación.'
    ],

    'ipd_patient_consultant_register' => [
        'consultant_instruction' => 'Instructora Consultora',
        'consultant_doctor' => 'Consultora doctora',
        'new_consultant_register' => 'Agregar instrucción de consultor',
        'edit_consultant_register' => 'Editar instrucción de consultor',
        'applied_date' => 'Fecha de aplicación',
        'doctor_id' => 'Médico',
        'instruction' => 'Instrucción',
        'instruction_date' => 'Fecha de instrucción',
        'applied_date_or_Instruction_date_can_not_be_null' => 'Das Anwendungsdatum oder das Anweisungsdatum darf nicht null sein.',
        'assistant_consultant_1' => 'Consultor Asistente 1',
        'assistant_consultant_2' => 'Consultor Asistente 2',
        'anesthetist' => 'Anestesista',
        'anesthesia_type' => 'Tipo de anestesia',
        'instruction_field_is_required' => 'El campo de instrucción es obligatorio.',
    ],

    'ipd_patient_charges' => [
        'new_charge' => 'Agregar cargos',
        'date' => 'Fecha',
        'edit_charge' => 'Editar cargos',
        'charge_type_id' => 'Tipo de carga',
        'charge_category_id' => 'Categoría de carga',
        'charge_id' => 'Código',
        'standard_charge' => 'Cargo estándar',
        'applied_charge' => 'Carga aplicada',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD No',
        'header_note' => 'Nota de encabezado',
        'footer_note' => 'Nota de pie de página',
        'new_prescription' => 'Agregar receta',
        'edit_prescription' => 'Editar prescripción',
        'prescription_details' => 'Detalles de la prescripción',
        'category_id' => 'Categoría de medicina',
        'medicine_id' => 'Medicamento',
        'dosage' => 'Dosis',
        'instruction' => 'Instrucción',
        'print_prescription' => 'Receta de impresión',
    ],

    'ipd_patient_timeline' => [
        'timeline' => 'Cronología',
        'new_ipd_timeline' => 'Agregar cronología',
        'edit_ipd_timeline' => 'Editar línea de tiempo',
        'title' => 'Título',
        'date' => 'Fecha',
        'description' => 'Descripción',
        'document' => 'Documento',
        'visible_to_person' => 'Visible para la persona',
        'no_timeline_found' => 'No se encontró TimeLine',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'Agregar pago de Ipd',
        'edit_ipd_payment' => 'Editar pago IPD',
        'payment_mode' => 'Modo de pago',
        'make_payment' => 'Hacer el pago',
    ],

    'ipd_bill' => [
        'paid_amount' => 'Monto de pago',
        'total_charges' => 'Cargos totales',
        'gross_total' => 'Total bruto',
        'discount_in_percentage' => 'Descuento en porcentaje',
        'discount_in_number' => 'Descuento en número',
        'tax_in_percentage' => 'Impuesto en porcentaje',
        'tax_in_number' => 'Número de impuestos',
        'other_charges' => 'Otros cargos',
        'net_payable_amount' => 'Importe neto a pagar',
        'discharge_patient' => 'Paciente de alta',
    ],

    'opd_patient' => [
        'opd_patient_out' => 'OPD - Paciente fuera',
        'opd_patient' => 'Paciente OPD',
        'opd_patients' => 'Pacientes OPD',
        'new_opd_patient' => 'Nuevo paciente OPD',
        'edit_opd_patient' => 'Editar paciente OPD',
        'opd_patient_details' => 'Detalles del paciente OPD',
        'opd_number' => 'OPD No',
        'appointment_date' => 'Día de la cita',
        'visits' => 'Visitas',
        'revisits' => 'Volver a visitar',
        'total_visits' => 'Visitas totales',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'Agregar pago de Opd',
        'edit_opd_payment' => 'Editar pago de Opd',
        'payment_mode' => 'Modo de pago',
        'make_payment' => 'Hacer el pago',
    ],

    'call_log' => [
        'call_log' => 'Registro de llamadas',
        'new' => 'Nuevo registro de llamadas',
        'edit' => 'Editar registro de llamadas',
        'name' => 'Nombre',
        'phone' => 'Teléfono',
        'received_on' => 'Recibido el',
        'follow_up_date' => 'Fecha de seguimiento',
        'note' => 'Nota',
        'call_type' => 'Tipo de llamada',
        'incoming' => 'Entrante',
        'outgoing' => 'Saliente',
    ],

    'visitor' => [
        'visitor' => 'Visitante',
        'new' => 'Nueva visitante',
        'edit' => 'Editar visitante',
        'name' => 'Nombre',
        'purpose' => 'Propósito',
        'phone' => 'Teléfono',
        'id_card' => 'Tarjeta de identificación',
        'number_of_person' => 'Numero de personas',
        'date' => 'Fecha',
        'in_time' => 'A tiempo',
        'out_time' => 'Fuera de tiempo',
        'note' => 'Nota',
    ],

    'postal' => [
        'postal' => 'Postal',
        'new_receive' => 'Nueva recepción',
        'new_dispatch' => 'Nuevo envío',
        'dispatch' => 'Envío',
        'receive' => 'Recibir',
        'edit_receive' => 'Editar Recibir',
        'edit_dispatch' => 'Editar envío',
        'to_title' => 'Al título',
        'from_title' => 'Desde el título',
        'reference_no' => 'Número de referencia',
        'date' => 'Fecha',
        'address' => 'Habla a',
        'validate_from_title' => 'El título del remitente es requerido.',
        'validate_to_title' => 'El título del destinatario es requerido.',
    ],

    'testimonial' => [
        'testimonial' => 'Testimonial',
        'new_testimonial' => 'Nuevo testimonio',
        'edit_testimonial' => 'Editar testimonio',
        'testimonial_detail' => 'Detalle del testimonio',
        'name' => 'Nombre',
        'description' => 'Descripción',
        'profile_error' => 'El documento debe ser un archivo del tipo: jpeg, jpg, png.',
    ],

    'blood_donation' => [
        'blood_donation' => 'Donación de sangre',
        'new_blood_donation' => 'Nueva donación de sangre',
        'edit_blood_donation' => 'Editar donación de sangre',
        'donor_name' => 'Nombre del donante',
        'bags' => 'Pantalón',
        'last_donate_date' => 'última fecha de donación',
    ],

    'blood_issue' => [
        'blood_issue' => 'Problema de sangre',
        'new_blood_issue' => 'Nueva emisión de sangre',
        'edit_blood_issue' => 'Editar problema de sangre',
        'issue_date' => 'Fecha de asunto',
        'patient_name' => 'Nombre del paciente',
        'doctor_name' => 'Nombre del doctor',
        'donor_name' => 'Nombre del donante',
        'amount' => 'Cantidad',
        'remarks' => 'Observaciones',
    ],

    'notification' => [
        'notifications' => 'Notificaciones',
        'mark_all_as_read' => 'Marcar todo como leido',
        'you_don`t_have_any_new_notification' => 'No tienes ninguna notificación nueva',
        'all_notification_read_successfully' => 'Alle Benachrichtigungen wurden erfolgreich gelesen',
        'notification_read_successfully' => 'Benachrichtigung erfolgreich gelesen',
    ],

    'live_consultation' => [
        'live_consultation' => 'Consulta en Vivo',
        'new_live_consultation' => 'Nueva Consulta en Vivo',
        'consultation_title' => 'Título de la Consulta',
        'consultation_date' => 'Fecha de la Consulta',
        'consultation_duration_minutes' => 'Duración de la Consulta (en minutos)',
        'client_video' => 'Video del Cliente',
        'host_video' => 'Video del Anfitrión',
        'enable' => 'Habilitar',
        'disabled' => 'Deshabilitado',
        'type' => 'Tipo',
        'type_number' => 'Número de Tipo',
        'created_by' => 'Creado por',
        'created_for' => 'Creado para',
        'new_live_meeting' => 'Nueva Reunión en Vivo',
        'staff_list' => 'Lista de Personal',
        'edit_live_consultation' => 'Editar Consulta en Vivo',
        'duration' => 'Duración (en minutos)',
        'start_now' => 'Iniciar Ahora',
        'join_now' => 'Unirse Ahora',
        'edit_live_meeting' => 'Editar Reunión en Vivo',
        'add_credential' => 'Agregar Credencial',
        'zoom_api_key' => 'Clave de la API de Zoom',
        'zoom_api_secret' => 'Secreto de la API de Zoom',
        'join_meeting' => 'Unirse a la Reunión',
        'start_meeting' => 'Iniciar la Reunión',
        'generate_auth_credentials' => '¿Cómo generar Credenciales de Autenticación?',
        'user_zoom_credential_saved' => 'Credencial de Zoom del usuario guardada exitosamente.',
        'add_credentials_for_zoom_meeting' => 'Por favor, agregue credenciales para la reunión de Zoom.',
        'credentials_already_use' => 'Tus credenciales de zoom ya están en uso',
        'connect_with_zoom' => 'Tienes que conectarte con zoom.',
        'cannot_delete_meeting_in_progress' => 'Lo sentimos, no puedes eliminar esta reunión porque está en curso.',
        'select_platform' => 'Seleccionar plataforma',
    ],

    'vaccination' => [
        'vaccinations' => 'Vacunas',
        'new_vaccination' => 'Nueva vacunación',
        'edit_vaccination' => 'Editar vacunación',
        'name' => 'Nombre',
        'manufactured_by' => 'Fabricado por',
        'brand' => 'Marca',
        'vaccinated' => 'Vacunado',
    ],

    'vaccinated_patient' => [
        'vaccinated_patient' => 'Paciente vacunada',
        'patient' => 'Paciente',
        'vaccination' => 'Vacunación',
        'serial_no' => 'Número de serie',
        'does_no' => 'Dosis No',
        'dose_given_date' => 'Fecha de administración de la dosis',
        'description' => 'Descripción',
        'add_vaccinate_patient' => 'Agregar paciente vacunar',
        'new_vaccinate_patient' => 'Nuevo paciente vacunado',
        'edit_vaccinate_patient' => 'Editar Vacunar Paciente',
        'vaccine' => 'Vacuna',
        'vaccinate_patient' => 'Vacunar Paciente',
        'already_registered_dose' => 'Der Patient ist bereits mit demselben Impfstoff und derselben Dosis registriert.',
    ],

    'front_setting' => [
        'about_us_title' => 'Título',
        'about_us_mission' => 'Misión',
        'about_us_image' => 'Imagen',
        'about_us_description' => 'Descripción',
        'terms_conditions' => 'Términos y condiciones',
        'about_us_details' => 'Sobre nosotros detalles',
        'appointment_details' => 'Detalles de la cita',
        'terms_condition_details' => 'Detalles de términos y condiciones',
        'front_setting_details' => 'Front Setting Details',
        'home_page_image' => 'Imagen de la página de inicio',
        'home_page_title' => 'Título de la página de inicio',
        'home_page_description' => 'Descripción de la página de inicio',
        'home_page_box_title' => 'Título del cuadro de la página de inicio',
        'home_page_box_description' => 'Descripción del cuadro de la página de inicio',
        'home_page_experience' => 'Experiencia en la página de inicio',
        'home_page_step_1_title' => 'Página de inicio Paso 1 Título',
        'home_page_step_1_description' => 'Página de inicio Paso 1 Descripción',
        'home_page_step_2_title' => 'Página de inicio Paso 2 Título',
        'home_page_step_2_description' => 'Página de inicio Paso 2 Descripción',
        'home_page_step_3_title' => 'Página de inicio Paso 3 Título',
        'home_page_step_3_description' => 'Página de inicio Paso 3 Descripción',
        'home_page_step_4_title' => 'Página de inicio Paso 4 Título',
        'home_page_step_4_description' => 'Página de inicio Paso 4 Descripción',
        'privacy_policy' => 'Política de privacidad',
        'home_page_certified_doctor_image' => 'Página de inicio Imagen de médico certificado',
        'home_page_certified_doctor_text' => 'Texto de médico certificado de la página de inicio',
        'home_page_certified_doctor_title' => 'Título de médico certificado de la página de inicio',
        'home_page_certified_doctor_description' => 'Página de Inicio Médico Certificado Descripción',
        'home_page_certified_box_title' => 'Título del cuadro certificado de la página de inicio',
        'home_page_certified_box_description' => 'Página de inicio Caja certificada Descripción',
        'the_terms_conditions_is_required' => 'Die Allgemeinen Geschäftsbedingungen sind erforderlich.',
        'the_privacy_policy_is_required' => 'Die Datenschutzrichtlinie ist erforderlich.',
        'home_page_experience_required' => 'Das Feld für die Startseite darf keine Leerzeichen enthalten.',
        'home_page_title_required' => 'Das Feld für den Titel der Startseite darf keine Leerzeichen enthalten.',
        'home_page_description_required' => 'Das Feld für die Beschreibung der Startseite darf keine Leerzeichen enthalten.',
        'home_page_box_required' => 'Das Feld für den Titel des Startseitenkastens darf keine Leerzeichen enthalten.',
        'home_page_box_descriptions_required' => 'Das Feld für die Beschreibungen des Startseitenkastens darf keine Leerzeichen enthalten.',
        'home_page_certified_required' => 'Das Feld für den Text des zertifizierten Arztes auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_certified_title_required' => 'Das Feld für den Titel des zertifizierten Arztes auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_certified_doctor_description_required' => 'Das Feld für die Beschreibung des zertifizierten Arztes auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_certified_box_title_required' => 'Das Feld für den Titel des zertifizierten Kastens auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_certified_description_required' => 'Das Feld für die Beschreibung des zertifizierten Kastens auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_title_required' => 'Das Feld für den Titel des Schritts 1 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_description_required' => 'Das Feld für die Beschreibung des Schritts 1 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_two_title_required' => 'Das Feld für den Titel des Schritts 2 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_two_description_required' => 'Das Feld für die Beschreibung des Schritts 2 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_three_title_required' => 'Das Feld für den Titel des Schritts 3 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_three_description_required' => 'Das Feld für die Beschreibung des Schritts 3 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_four_title_required' => 'Das Feld für den Titel des Schritts 4 auf der Startseite darf keine Leerzeichen enthalten.',
        'home_page_step_four_description_required' => 'Das Feld für die Beschreibung des Schritts 4 auf der Startseite darf keine Leerzeichen enthalten.',
        'about_us_title_required' => 'Das Feld für den Titel "Über uns" darf keine Leerzeichen enthalten.',
        'about_us_description_required' => 'Das Feld für die Beschreibung "Über uns" darf keine Leerzeichen enthalten.',
        'about_us_mission_required' => 'Das Feld für die Mission "Über uns" darf keine Leerzeichen enthalten.',
    ],

    'change_password' => [
        'change_password' => 'Cambiar la contraseña',
        'current_password' => 'Contraseña actual',
        'new_password' => 'Nueva contraseña',
        'confirm_password' => 'confirmar Contraseña',
    ],

    'web_home' => [
        'home' => 'Hogar',
        'services' => 'Servicios',
        'doctors' => 'Doctoras',
        'about_us' => 'Sobre nosotras',
        'contact' => 'Contacto',
        'make_appointment' => 'Concertar cita',
        'working_hours' => 'Horas Laborales',
        'testimonials' => 'Testimonios',
        'terms_of_service' => 'Términos de servicio',
        'privacy_policy' => 'Política de privacidad',
        'patients' => 'Pacientes',
        'years_experience' => 'Años de experiencia',
        'sign_up' => 'Inscribirse',
        'available_doctors' => 'Doctores Disponibles',
        'select_doctors' => 'Seleccionar médicos',
        'contact_doctors' => 'Doctora de contacto',
        'contact_hospital' => 'Póngase en contacto con el hospital',
        'easy_solutions' => 'Soluciones fáciles',
        '4_easy_step_and_get_the_world_best_treatment' => '4 pasos sencillos y obtenga el mejor tratamiento del mundo',
        'book_an_appointment' => 'Reservar una cita',
        'select_doctor' => 'Seleccionar doctora',
        'book_now' => 'Reservar ahora',
        'patients_beds' => 'Camas de pacientes',
        'doctors_nurses' => 'Doctores y enfermeras',
        'happy_patients' => 'Pacientes felices',
        'book_appointment' => 'Reservar una cita',
        'our_services' => 'Nuestros servicios',
        'we_offer_different_services_to_improve_your_health' => 'Ofrecemos diferentes servicios para mejorar su salud',
        'professional_doctors' => 'Doctores Profesionales',
        'we_are_experienced_healthcare_professionals' => 'Somos profesionales sanitarios experimentados',
        'our_testimonials' => 'Nuestras Testimonios',
        'what_our_patient_say_about_medical_treatments' => 'Lo que dicen nuestros pacientes sobre nuestros tratamientos médicos',
        'professional_details' => 'Detalles Profesionales'
    ],

    'web_password' => [
        'please_fill_all_the_required_fields' => 'Por favor complete todos los campos requeridos.',
        'password_and_confirm_password_not_match' => 'Contraseña y Confirmar contraseña no coinciden.',
    ],

    'web_contact' => [
        'call_today' => 'Llama hoy',
        'open_hours' => 'Horarios de apertura',
        'our_location' => 'nuestra ubicación',
        'send_us_a_message' => 'Mandanos un mensaje',
        'your_name' => 'Tu nombre',
        'your_email' => 'Tu correo electrónico',
        'phone_number' => 'Número de teléfono',
        'select_enquiry' => 'Seleccionar consulta',
        'your_message' => 'Tu mensaje',
        'send_message' => 'Enviar mensaje',
        'enter_your_name' => 'Introduzca su nombre',
        'enter_your_email' => 'Introduce tu correo electrónico',
        'contact_no' => 'Contacto No',
        'please_enter_your_phone_number' => 'Por favor, introduzca su número de teléfono',
        'write_your_message' => 'escribe tu mensaje',
        'type_your_message' => 'Escribe tu mensaje',
    ],

    'web_menu' => [
        'about' => 'Sobre',
        'our_features' => 'Nuestras caracteristicas',
        'appointment' => 'Cita',
        'working_hours' => 'Horas Laborales',
        'login' => 'Acceso',
        'useful_link' => 'Enlace útil',
        'contact_information' => 'Información del contacto',
        'copyright' => 'Derechos de autor',
        'all_rights_reserved_by' => 'Todos los derechos reservados por',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'Haga una cita',
        'call_now_and_get_a_free_consulting' => 'Llame ahora y obtenga una consultoría gratuita',
        'enter_your_first_name' => 'Ponga su primer nombre',
        'enter_your_last_name' => 'Ingrese su apellido',
        'enter_your_password' => 'Ingresa tu contraseña',
        'enter_confirm_password' => 'Ingrese Confirmar Contraseña',
        'select_department' => 'Seleccionar departamento',
        'select_doctor' => 'Seleccionar doctora',
        'enter_description' => 'Ingrese descripción',
        'select_time' => 'Seleccionar hora',
    ],

    'web_working_hours' => [
        'opening_hours' => 'Horario de apertura',
        'no_yet_opening_hours' => 'Aún no hay horario de apertura',
    ],

    'purchase_medicine' => [
        'purchase_number' => 'Número de compra',
        'total' => 'Total',
        'discount' => 'Descuento',
        'tax_amount' => 'Importe del impuesto',
        'net_amount' => 'Importe neto',
        'payment_mode' => 'Modo de pago',
        'payment_note' => 'Nota de pago',
        'note' => 'Nota',
        'purchase_medicine' => 'Comprar Medicina',
        'purchase_medicine_details' => 'Detalles de la compra de medicamentos',
        'purchase_medicine_overview' => 'Descripción general de la compra de medicamentos',
        'lot_no' => 'Mucho no.',
        'tax' => 'Impuesto',
        'quantity' => 'Cantidad',
        'amount' => 'Cantidad',
        'expiry_date' => 'Fecha de caducidad',
        'other_details' => 'Otros detalles',
        'dose_duration' => 'Dosis Duración',
        'medicine_purchased_successfully' => 'Medikament erfolgreich gekauft.',
    ],

    'used_medicine' => [
        'used_medicine' => 'Medicina Usada',
        'used_quantity' => 'Cantidad usada',
        'used_at' => 'Usado en',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Factures de médicaments',
        'medicine_bill' => 'Proyecto de ley de medicamentos',
        'edit_medicine_bill' => 'Editar factura de medicamentos',
        'medicine_bill_details' => 'Detalles de la factura de medicamentos',
        'dose_interval' => 'Intervalo de dosis',
        'available_quantity' => 'La cantidad disponible de',
        'is' => 'es',
        'prescription_not_found' => 'Receta no encontrada.',
        'medicine_not_selected' => 'Seleccione al menos un medicamento.',
        'duplicate_medicine' => 'No se pueden agregar medicamentos duplicados.',
        'payment_status' => 'Estado de pago',
        'sale_price' => 'Precio de venta',
        'add_medicine_bill' => 'Agregar factura de medicamentos',
        'select_medicine' => 'Seleccione Medicina',
        'update_quantity' => 'La cantidad de actualización debe ser menor que la cantidad anterior.',
        'net_amount_not_empty' => 'El importe neto no puede estar vacío.',
        'net_amount_not_zero' => 'El importe neto no puede ser cero.',
        'payment_type' => 'Tipo de pago',
        'tax_amount_not_zero_or_empty' => 'El monto del impuesto no puede ser cero o estar vacío.',
        'medicine_required' => 'El campo Medicamento es obligatorio.',
        'bill_number' => 'Número de Factura',
        'validate_discount' => 'El descuento debe ser menor que el monto total.',
        'validate_tax' => 'Los impuestos deben ser menores al 100%.',
        'quantity_cannot_be_zero' => 'La cantidad no puede ser cero o estar vacía.',
        'lot_number' => 'Ingrese el número de lote.',
        'sale_price' => 'Ingrese el precio de venta.',
        'purchase_price' => 'Ingrese el precio de compra.',
        'validate_quantity' => 'La cantidad debe ser mayor que 0.',
        'quantity_required' => 'Por favor, ingrese la cantidad.',
    ],
    'subscription_plans' => [
        'payment_type' => 'Seleccionar tipo de pago',
        'connect_with_zoom' => 'Conectar con Zoom',
        'connected' => 'Conectado',
    ],

    'holiday' => [
        'holiday' => 'Día festivo',
        'add_holiday' => 'Agregar día festivo',
        'doctor_holiday' => 'Vacaciones del médico',
        'service_category' => 'Categoría de servicio',
        'holiday_date' => 'Fecha del día festivo',
        'reason' => 'Motivo',
        'holiday_already_is_exist' => 'El día festivo ya existe.',
        'doctor_holiday_create' => 'Vacaciones del médico guardadas exitosamente.',
        'you_are_not_allow_to_record' => 'Parece que no tiene acceso a este registro.',
        'appointment_exists' => 'La cita existe. No puedes tomar vacaciones.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'Descansos para almorzar',
        'lunch_break' => 'Descanso para almorzar',
        'break_create' => 'Descanso para almorzar guardado exitosamente.',
        'break_update' => 'Descanso para almorzar actualizado exitosamente.',
        'add_break' => 'Agregar descanso para almorzar',
        'edit_break' => 'Editar descanso para almorzar',
        'break_already_is_exist' => 'El descanso para almorzar ya existe.',
        'break_time_greater_than_zero' => 'El tiempo de descanso debe ser mayor que cero.',
        'break_to_time_greater_than_zero' => 'La hora de finalización del descanso debe ser mayor que cero.',
        'break_to_time_greater_than_from_time' => 'La hora de finalización del descanso debe ser mayor que la hora de inicio del descanso.',
        'date_required' => 'El campo de fecha es obligatorio.',
        'appointment_exists' => 'La cita existe. No puedes tomar un descanso.',
    ],
    'new_change' => [
        'pathology_units' => 'Unidades de Patología',
        'pathology_unit' => 'Unidad de Patología',
        'add_unit' => 'Nueva Unidad de Patología',
        'edit_unit' => 'Editar unidad de patología',
        'pathology_unit_not_found' => 'Unidad de patología no encontrada',
        'pathology_unit_cant_deleted' => 'La unidad de patología no se puede eliminar.',
        'pathology_parameter_not_found' => 'Parámetro de patología no encontrado',
        'pathology_parameter_cant_deleted' => 'El parámetro de patología no se puede eliminar.',
        'pathology_parameter' => 'Parámetro de patología',
        'pathology_parameters' => 'Parámetros de patología',
        'add_parameter' => 'Nuevo parámetro de patología',
        'edit_parameter' => 'Editar parámetro de patología',
        'parameter_name_required' => 'El campo Nombre del parámetro es obligatorio.',
        'patient_result_required' => 'El campo Resultado del paciente es obligatorio.',
        'parameter_name' => 'Nombre del parámetro',
        'patient_result' => 'Resultado del paciente',
        'select_parameter_name' => 'Seleccione el nombre del parámetro',
        'reference_range' => 'Rango de referencia',
        'select_unit' => 'Seleccionar unidad',
        'print_pathology_test' => 'Imprimir prueba de patología',
        'pathology_test_report' => 'Informe de prueba de patología',
    ],
    'subscription_plans' => [
        'payment_type' => 'Elegir Tipo de Pago',
        'connect_with_zoom' => 'Conectar con Zoom',
        'connected' => 'Conectado',
        'select_ipd_patient' => 'Seleccionar paciente IPD',
    ],

    'patient_id_card' => [
        'id' => 'IDENTIFICACIÓN',
        'patient_id_card' => 'Tarjetas inteligentes para pacientes',
        'new_patient_id_card_template' => 'Nueva plantilla de tarjeta inteligente para pacientes',
        'edit_patient_id_card_template' => 'Editar plantilla de tarjeta inteligente de paciente',
        'patient_id_card_template' => 'Plantilla de tarjeta inteligente para pacientes',
        'color' => 'Color',
        'patient_unique_id' => 'Identificación Única del Paciente',
        'new_patient_id_card' => 'Tarjeta paciente nuevo',
        'generate_patient_id_card' => 'Generar tarjeta inteligente de paciente',
        'template_id' => 'Nombre de la plantilla',
        'select_template' => 'Seleccionar plantilla',
        'select_type' => 'Seleccionar tipo',
        'all_patient' => 'Para todos los pacientes',
        'one_patient' => 'Solo para un paciente',
        'remaining_patients' => 'Pacientes restantes',
        'template_required' => 'Campo de plantilla requerido',
        'patient_required' => 'El campo del paciente es obligatorio',
    ],

    'register' => [
        'hello' => '¡Hola!',
        'whoops' => '¡Ups!',
        'regards' => 'Saludos,',
        'if_having_trouble_text' => "Si tienes problemas al hacer clic en el botón \":actionText\", copia y pega la URL a continuación\n".
        'en tu navegador web: [:actionURL](:actionURL)',
    ],

    'custom_field' => [
        'custom_field' => 'Campo personalizado',
        'add_custom_field' => 'Agregar campo personalizado',
        'edit_custom_field' => 'Editar campo personalizado',
        'module_name' => 'Nombre del módulo',
        'field_type' => 'Tipo de campo',
        'field_name' => 'Nombre del campo',
        'grid' => 'Red',
        'value' => 'Valor',
        'seperated_by_comma' => 'Separada por coma',
        'is_reqired' => 'Es requerido',
        'input' => 'Aporte',
        'textarea' => 'área de texto',
        'checkbox' => 'Caja',
        'number' => 'Número',
        'dropdown' => 'Desplegable',
        'multi_select' => 'Selección múltiple',
        'date' => 'Date',
        'date_time' => 'Fecha y hora',
        'appointment' => 'Cita',
        'ipd_patient' => 'Paciente con ENI',
        'opd_patient' => 'Paciente con OPD',
        'patient' => 'Paciente',
        'value_must_be_greter_then' => 'Paciente',
        'select_module' => 'Seleccionar módulo',
        'select_field_type' => 'Seleccionar tipo de campo',
        'text' => 'Texto'
    ],

    'google_meet' => [
        'connect_calendar' => 'Conecta tu calendario de Google',
        'disconnect_google_calendar' => 'Desconecta tu calendario de Google',
        'sync_google_calendar' => 'Sincroniza tu calendario de Google',
        'validate_json_file' => 'Configure el archivo json de credenciales de Google Calendar',
        'google_calendar_connect' => 'Calendario de Google conectado correctamente',
        'google_calendar_add' => 'calendario agregado exitosamente',
        'google_calendar_update' => 'Calendario de Google actualizado correctamente.',
        'disconnect_or_reconnect' => 'Desconecta y vuelve a conectar tu calendario de Google.',
        'google_calendar_disconnect' => 'Calendario de Google desconectado',
        'select_google_calendar' => 'Seleccione sus calendarios (de Google Calendar) en los que desea crear los eventos',
        'platform_type' => 'Tipo de plataforma',
        'google_json_file' => 'Archivo Json de Google',
        'upload_json_file' => 'Cargue un archivo JSON.',
        'upload_file' => 'Por favor cargue un archivo.',
        'invalid_json_format' => 'Este formato no es válido, el formato válido es JSON.',
        'json_file_saved_successfully' => 'Archivo Json de Google Calendar guardado correctamente',
    ],

    'footer' => [
        'all_rights_reserved' => 'Reservados todos los derechos',
    ],

    'open_ai' => [
        'provide_prompt' => 'Proporcione información física para recibir aviso.',
        'open_ai_key_not_found' => 'No se encontró la clave API de OpenAI.',
        'repsonse_retrive_successfully' => 'Respuesta recuperada exitosamente.',
        'open_ai_key' => 'Abrir clave AI',
        'suggest_medicines' => 'Sugerir medicamentos',
    ],

    'schedule_weekday' => [
        'Monday' => 'Lunes',
        'Tuesday' => 'Martes',
        'Wednesday' => 'Miércoles',
        'Thursday' => 'Jueves',
        'Friday' => 'Viernes',
        'Saturday' => 'Sábado',
        'Sunday' => 'Domingo',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'LUN',
        'TUE' => 'MAR',
        'WED' => 'CASARSE',
        'THU' => 'JUE',
        'FRI' => 'VIE',
        'SAT' => 'SE SENTÓ',
        'SUN' => 'SOL',
    ],
];
