<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin' => 'Admins',
    'admins' => 'Admin',
    'roles' => 'Roles',
    'doctor_departments' => 'Doctor Departments',
    'nurses' => 'Nurses',
    'operations' => 'Operations',
    'doctors' => 'Doctors',
    'patients' => 'Patients',
    'lab_technicians' => 'Lab Technicians',
    'receptionists' => 'Receptionists',
    'pharmacists' => 'Pharmacists',
    'accountants' => 'Accountants',
    'appointments' => 'Appointments',
    'insurances' => 'Insurances',
    'investigation_reports' => 'Investigation Reports',
    'death_reports' => 'Death Reports',
    'birth_reports' => 'Birth Reports',
    'operation_reports' => 'Operation Reports',
    'medicine_categories' => 'Medicine Categories',
    'medicine_brands' => 'Medicine Brands',
    'medicines' => 'Medicines',
    'cases' => 'Cases',
    'case_handlers' => 'Case Handlers',
    'bed_types' => 'Bed Types',
    'beds' => 'Beds',
    'bed_assigns' => 'Bed Assigns',
    'packages' => 'Packages',
    'schedules' => 'Schedules',
    'schedule_label' => 'Schedule',
    'services' => 'Services',
    'payments' => 'Payments',
    'bills' => 'Bills',
    'employee_payrolls' => 'Employee Payrolls',
    'documents' => 'Documents',
    'document_types' => 'Document Types',
    'notice_boards' => 'Notice Boards',
    'settings' => 'Settings',
    'doctors_list' => 'Doctors List',
    'my_payrolls' => 'My Payrolls',
    'blood_banks' => 'Blood Banks',
    'blood_donors' => 'Blood Donors',
    'invoices' => 'Invoices',
    'patients_cases' => 'Patients Cases',
    'patients_case_details' => 'Patients Case Details',
    'account_manager' => 'Account Manager',
    'bed_management' => 'Bed Management',
    'blood_bank' => 'Blood Banks',
    'billing' => 'Billings',
    'case_manager' => 'Case Manager',
    'cms' => 'CMS',
    'front_cms_services' => 'Front CMS Services',
    'department' => 'Department',
    'departments' => 'Departments',
    'hospital_activities' => 'Hospital Activities',
    'advanced_payments' => 'Advance Payments',
    'patient_admissions' => 'Patient Admissions',
    'appointment_calendar' => 'Appoint. Calendar',
    'bed_mgt' => 'Bed Management',
    'reports' => 'Reports',
    'enquiries' => 'Enquiries',
    'mail' => 'Mail',
    'ambulances' => 'Ambulances',
    'ambulance_calls' => 'Ambulance Calls',
    'prescriptions' => 'Prescriptions',
    'hospital_charges' => 'Hospital Charges',
    'charge_categories' => 'Charge Categories',
    'charges' => 'Charges',
    'radiologies' => 'Radiology',
    'radiology_categories' => 'Radiology Category',
    'pathologies' => 'Pathology',
    'pathology_categories' => 'Pathology Category',
    'radiology_tests' => 'Radiology Tests',
    'doctor_opd_charges' => 'Doctor OPD Charges',
    'pathology_tests' => 'Pathology Tests',
    'expenses' => 'Expenses',
    'income' => 'Income',
    'finance' => 'Finances',
    'issued_items' => 'Issued Items',
    'ipd_patients' => 'IPD Patients',
    'ipd_opd' => 'IPD/OPD',
    'ipd_diagnosis' => 'Diagnosis',
    'ipd_consultant_register' => 'Consultant Instruction',
    'ipd_consultant_doctor' => 'Consultant Doctor',
    'ipd_charges' => 'Charges',
    'ipd_prescription' => 'Prescriptions',
    'ipd_timelines' => 'Timelines',
    'ipd_payment' => 'IPD Payment',
    'opd_patients' => 'OPD Patients',
    'opd_diagnosis' => 'OPD Diagnosis',
    'opd_timeline' => 'OPD Timeline',
    'call_logs' => 'Call Logs',
    'visitors' => 'Visitors',
    'front_office' => 'Front Office',
    'postal_receive' => 'Postal Receive',
    'postal_dispatch' => 'Postal Dispatch',
    'inventory' => 'Inventories',
    'items_categories' => 'Items Categories',
    'items' => 'Items',
    'items_stocks' => 'Item Stocks',
    'general' => 'General',
    'sidebar_setting' => 'Modules Setting',
    'currency_setting' => 'Currencies',
    'testimonials' => 'Testimonials',
    'blood_donations' => 'Blood Donations',
    'blood_issues' => 'Blood Issues',
    'live_consultations' => 'Live Consultations',
    'live_meetings' => 'Live Meetings',
    'live_meeting' => 'Live Meeting',
    'vaccinations' => 'Vaccinations',
    'vaccinated_patients' => 'Vaccinated Patients',
    'users' => 'Users',
    'front_settings' => 'Front Settings',
    'front_service' => 'Front Service',
    'about_us' => 'About Us',
    'make_an_appointment' => 'Make An Appointment',
    'patient_appointment' => 'Patient Appointment',
    'old_patient' => 'Old Patient',
    'new_patient' => 'New Patient',
    'available_slot' => 'Available Slot',
    'available_slots' => 'Available Slots',
    'contact_us' => 'Contact Us',
    'short_description' => 'Short Description',
    'icon' => 'Icon',
    'front_cms' => 'Front CMS',
    'facebook_url' => 'Facebook URL',
    'twitter_url' => 'Twitter URL',
    'instagram_url' => 'Instagram URL',
    'linkedIn_url' => 'LinkedIn URL',
    'hospital_schedule' => 'Hospital Schedule',
    'file_name' => 'File Name',
    'allow_file_type' => 'Allowed file types: png, jpg, jpeg.',
    'overview' => 'Overview',
    'no_data_available' => 'No data available in table',
    'valid' => 'Valid',
    'no_matching_records_found' => 'No matching records found',
    'select_applied_date' => 'Please select applied date',
    'select_instruction_date' => 'Please select instruction date',
    'report' => 'Report',
    'report_id' => 'Report ID',
    'yearly_income_expense_chart' => 'Yearly Income Expense Chart',
    'sms_mail' => 'SMS/Mail',
    'payment_gateways' => 'Payment Gateways',
    'stripe_key' => 'Stripe Key',
    'stripe_secret' => 'Stripe Secret',
    'paypal' => 'PayPal',
    'paypal_client_id' => 'PayPal Client ID',
    'paypal_secret' => 'PayPal Secret',
    'paypal_mode' => 'PayPal Mode',
    'razorpay' => 'Razorpay',
    'razorpay_key' => 'Razorpay Key',
    'razorpay_secret' => 'Razorpay Secret',
    'cash' => 'Cash',
    'cheque' => 'Cheque',
    'flutterwave' => 'Flutterwave',
    'flutterwave_public_key' => 'Flutterwave Public Key',
    'flutterwave_secret_key' => 'Flutterwave Secret Key',
    'phonepe' => 'PhonePe',
    'paystack' => 'Paystack',
    'paystack_public_key' => 'Paystack Public Key',
    'paystack_secret_key' => 'Paystack Secret Key',
    'phonepe_merchant_id' => 'Phonepe Merchant ID',
    'phonepe_merchant_user_id' => 'Phonepe Merchant User ID',
    'phonepe_env' => 'Phonepe Env',
    'phonepe_salt_key' => 'Phonepe Salt Key',
    'phonepe_salt_index' => 'Phonepe Salt Index',
    'phonepe_merchant_transaction_id' => 'Phonepe Merchant Transaction ID',

    'language' => [
        'Arabic' => 'Arabic',
        'Chinese' => 'Chinese',
        'English' => 'English',
        'French' => 'French',
        'German' => 'German',
        'Portuguese' => 'Portuguese',
        'Russian' => 'Russian',
        'Spanish' => 'Spanish',
        'Turkish' => 'Spanish',
    ],

    //roles
    'role' => [
        'new_role' => 'New Role',
        'edit_role' => 'Edit Role',
        'select_role' => 'Select Role',
    ],

    //user keys
    'user' => [
        'user' => 'User',
        'user_list' => 'User List',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'name' => 'Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'designation' => 'Designation',
        'gender' => 'Gender',
        'male' => 'Male',
        'female' => 'Female',
        'qualification' => 'Qualification',
        'dob' => 'Date Of Birth',
        'blood_group' => 'Blood Group',
        'select_blood_group' => 'Select Blood Group',
        'password' => 'Password',
        'password_confirmation' => 'Confirm Password',
        'address1' => 'Address 1',
        'address2' => 'Address 2',
        'city' => 'City',
        'zip' => 'Zip',
        'address_details' => 'Address Details',
        'address_not_found' => 'No Address details found',
        'education' => 'Education',
        'status' => 'Status',
        'edit_profile' => 'Edit Profile',
        'change_password' => 'Change Password',
        'logout' => 'Logout',
        'new_user' => 'New User',
        'edit_user' => 'Edit User',
        'user_details' => 'User Details',
        'email_verified_successfully' => 'Email Verified successfully.',
        'invalid_password' => 'Current password is invalid.',
        'validate_confirm_password' => 'The password and confirm password must be matched.',
        'validate_min_character_password' => 'Password must contain at least 6 characters.',
        'validate_image_type' => 'The image must be a file of type: jpg, jpeg, png.',
        'validate_image_size' => 'The document must be less than 10 mb',
        'validate_facebook_url' => 'Please enter a valid Facebook URL',
        'validate_twitter_url' => 'Please enter a valid Twitter URL',
        'validate_instagram_url' => 'Please enter a valid Instagram URL',
        'validate_linkedin_url' => 'Please enter a valid Linkedin URL',
        'phone_number_must_be_10_digits' => 'The phone number must be 10 digits long',
        'valid_email' => 'Please enter valid email',
    ],

    //common keys
    'common' => [
        'field_required' => 'field is Required.',
        'change' => 'Change',
        'change_profile' => 'Change Image',
        'is' => 'Is',
        'available_quantity_of' => 'The available quantity of',
        'result' => 'Result',
        'profile' => 'Profile',
        'status' => 'Status',
        'action' => 'Action',
        'save' => 'Save',
        'cancel' => 'Cancel',
        'canceled' => 'Canceled',
        'back' => 'Back',
        'created_on' => 'Created On',
        'last_updated' => 'Last Updated',
        'n/a' => 'N/A',
        'new' => 'New',
        'total' => 'Total',
        'add' => 'Add',
        'active' => 'Active',
        'name' => 'Name',
        'edit' => 'Edit',
        'detail' => 'Details',
        'delete' => 'Delete',
        'view' => 'View',
        'view_attachment' => 'View Attachment',
        'de_active' => 'Deactive',
        'description' => 'Description',
        'created_at' => 'Created On',
        'updated_at' => 'Last Updated',
        'is_available' => 'Is Available',
        'choose' => 'Choose',
        'yes' => 'Yes',
        'no' => 'No',
        'address' => 'Address',
        'export_to_excel' => 'Export to Excel',
        'reset' => 'Reset',
        'actions' => 'Actions',
        'filter_options' => 'Filter Options',
        'filter' => 'Filter',
        'user_details' => 'User',
        'no_data_available' => 'No data available in table',
        'confirm' => 'Confirm',
        'search' => 'Search',
        'status_updated_successfully' => 'Status updated successfully.',
        'saved_successfully' => 'saved successfully',
        'updated_successfully' => 'updated successfully',
        'deleted_successfully' => 'deleted successfully',
        'are_you_sure_want_to_delete_this' => 'Are you sure want to delete this ',
        'deleted' => 'Deleted',
        'has_been_deleted' => 'has been deleted.',
        'cant_be_deleted' => 'can\'t be deleted',
        'custom' => 'Custom',
        'apply' => 'Apply',
        'from' => 'From',
        'to' => 'To',
        'invalid_number' => 'Invalid number',
        'invalid_country_code' => 'Invalid country code',
        'too_short' => 'Too short',
        'too_long' => 'Too long',
        'not_found' => 'Not found',
        'previous' => 'Previous',
        'next' => 'Next',
        'ok' => 'Ok',
        'this_action_is_not_allowed_for_default_record' => 'This action is not allowed for default record.',
        'show' => 'Show',
        'something_wen_wrong' => 'Something went wrong',
        'cancelled_successfully' => 'cancelled successfully',
        'invalid_username_password' => 'Invalid username or password',
        'logged_in_successfully' => 'Logged in successfully.',
        'logout_successfully' => 'Logout successfully.',
        'we_cant_find_user' => 'We can\'t find user with this email address',
        'we_have_your_password_resetk_link' => 'We have e-mailed your password reset link!',
        'this_password_reset_token_is_invalid' => 'This password reset token is invalid',
        'password_reset_successfully' => 'Password reset successfully',
        'please_enter_correct_old_password' => 'please enter correct old password',
        'password_updated' => 'password updated',
        'doctor_scheduled' => 'Doctor Scheduled',
        'not_updated' => 'Not updated',
        'patient_registered_successfully' => 'Patient registered successfully',
        'appointment_confirmed_successfully' => 'Appointment confirmed successfully',
        'bed_assigned_successfully' => 'Bed Assigned Successfully',
        'username_and_password_required' => 'username and password required',
        'meeting_finished_or_cancelled' => 'This meeting is finished or cancelled',
        'alreay_exists' => 'Alreay exists.',
        'appointment_transaction' => 'Appointment Transaction'
      ],

    'hospital_schedules' => [
        'exists_doctor_schedule' => 'Some doctors have scheduled their days in given unchecked days, so are you sure you want to perform this operation?',
        'schedule_not_available' => 'Currently user not able to create a hospital schedule if hospital schedule is not available',
        'this_day_hospital_is_closed' => 'This Day Hospital is Closed.',
    ],

    'months' => [
        'jan' => 'January',
        'feb' => 'February',
        'mar' => 'March',
        'apr' => 'April',
        'may' => 'May',
        'jun' => 'June',
        'july' => 'July',
        'aug' => 'August',
        'sep' => 'September',
        'oct' => 'October',
        'nov' => 'November',
        'dec' => 'December',
    ],

    'weekdays' => [
        'sun' => 'SUN',
        'mon' => 'MON',
        'tue' => 'TUE',
        'wed' => 'WED',
        'thu' => 'THU',
        'fri' => 'FRI',
        'sat' => 'SAT',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'Receptionist',
        'receptionists' => 'Receptionists',
        'receptionist_details' => 'Receptionist Details',
        'new_receptionist' => 'New Receptionist',
        'edit_receptionist' => 'Edit Receptionist',
        'profile_must_be_image' => 'The profile image must be a image',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'Insurance',
        'insurances' => 'Insurances',
        'insurance_details' => 'Insurance Details',
        'new_insurance' => 'New Insurance',
        'edit_insurance' => 'Edit Insurance',
        'service_tax' => 'Service Tax',
        'insurance_no' => 'Insurance No',
        'insurance_code' => 'Insurance Code',
        'hospital_rate' => 'Hospital Rate',
        'discount' => 'Discount',
        'remark' => 'Remark',
        'disease_details' => 'Disease Details',
        'diseases_name' => 'Diseases Name',
        'diseases_charge' => 'Diseases charge',
        'total_amount' => 'Total Amount',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'Doctor Departments',
        'doctor_department' => 'Doctor Department',
        'doctor_department_details' => 'Doctor Department Details',
        'new_doctor_department' => 'New Doctor Department',
        'edit_doctor_department' => 'Edit Doctor Department',
        'title' => 'Title',
        'description' => 'Description',
        'doctor_field_required' => 'Doctor field is required'
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'Investigation Reports',
        'investigation_report' => 'Investigation Report',
        'investigation_report_details' => 'Investigation Report Details',
        'new_investigation_report' => 'New Investigation Report',
        'edit_investigation_report' => 'Edit Investigation Report',
        'patient' => 'Patient',
        'date' => 'Date',
        'title' => 'Title',
        'doctor' => 'Doctor',
        'description' => 'Description',
        'attachment' => 'Attachment',
        'birth_date_validation' => 'Investigation report date should not be smaller than patient birth date.',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'New Pharmacist',
        'edit_pharmacist' => 'Edit Pharmacist',
        'pharmacists' => 'Pharmacist',
        'pharmacist_details' => 'Pharmacist Details',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'Death Report',
        'death_reports' => 'Death Reports',
        'new_death_report' => 'New Death Report',
        'edit_death_report' => 'Edit Death Report',
        'death_report_details' => 'Death Report Details',
        'patient_name' => 'Patient Name',
        'case_id' => 'Case ID',
        'doctor_name' => 'Doctor Name',
        'date' => 'Date',
        'description' => 'Description',
        'cant_create_report_because_the_patient_has_been_dead' => 'Can\'t create report because the patient has been dead.',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Date should not be smaller than patient birth date.',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'Birth Report',
        'birth_reports' => 'Birth Reports',
        'birth_report_details' => 'Birth Report Details',
        'new_birth_report' => 'New Birth Report',
        'edit_birth_report' => 'Edit Birth Report',
        'patient_name' => 'Patient Name',
        'case_id' => 'Case ID',
        'doctor_name' => 'Doctor Name',
        'date' => 'Date',
        'description' => 'Description',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Date should not be smaller than patient birth date.',
        'patient_birth_date_not_found' => 'Patient Birth Date not found.',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'New Accountant',
        'edit_accountant' => 'Edit Accountant',
        'accountants' => 'Accountants',
        'accountant' => 'Accountant',
        'accountant_details' => 'Accountant Details',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'Employee Payroll',
        'employee_payrolls' => 'Employee Payrolls',
        'employee_payroll_details' => 'Employee Payroll Details',
        'new_employee_payroll' => 'New Employee Payroll',
        'edit_employee_payroll' => 'Edit Employee Payroll',
        'sr_no' => 'Sr No',
        'payroll_id' => 'Payroll ID',
        'month' => 'Month',
        'year' => 'Year',
        'role' => 'Role',
        'employee' => 'Employee',
        'basic_salary' => 'Basic Salary',
        'allowance' => 'Allowance',
        'deductions' => 'Deductions',
        'net_salary' => 'Net Salary',
        'paid' => 'Paid',
        'not_paid' => 'Unpaid',
        'employee_name' => 'Employee Name',
        'employees_list_not_found' => 'Employees List not found',
        'employee_payroll_deduction' => 'Deductions cannot be greater than Basic salary + Allowance',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'Operation Report',
        'operation_reports' => 'Operation Reports',
        'operation_report_details' => 'Operation Report Details',
        'new_operation_report' => 'New Operation Report',
        'edit_operation_report' => 'Edit Operation Report',
        'patient_name' => 'Patient Name',
        'case_id' => 'Case ID',
        'doctor_name' => 'Doctor Name',
        'date' => 'Date',
        'description' => 'Description',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Date should not be smaller than patient birth date.',
    ],

    // accounts keys
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'account_details' => 'Account Details',
        'new_account' => 'New Account',
        'edit_account' => 'Edit Account',
        'name' => 'Name',
        'description' => 'Description',
        'type' => 'Type',
        'status' => 'Status',
        'payments' => 'Payments',
        'credit' => 'Credit',
        'debit' => 'Debit',
    ],

    // invoices keys
    'invoice' => [
        'invoice_id' => 'Invoice ID',
        'invoice' => 'Invoice',
        'invoices' => 'Invoices',
        'invoice_details' => 'Invoice Details',
        'new_invoice' => 'New Invoice',
        'edit_invoice' => 'Edit Invoice',
        'patient' => 'Patient',
        'invoice_date' => 'Invoice Date',
        'amount' => 'Amount',
        'patient_id' => 'Patient ID',
        'discount' => 'Discount',
        'account_name' => 'Account Name',
        'description' => 'Description',
        'qty' => 'Qty',
        'price' => 'Price',
        'add' => 'Add',
        'sub_total' => 'Sub Total',
        'total' => 'Total Amount',
        'edit' => 'Edit',
        'hospital_address' => 'Hospital Address',
        'paid' => 'Paid',
        'not_paid' => 'UnPaid',
        'print_invoice' => 'Print Invoice',
        'invoice_date_field_required' => 'The invoice date field is required',
        'issue_for' => 'Issue For',
        'issue_from' => 'Issue From',
        'patient_overview' => 'PATIENT OVERVIEW',
        'in_percentage' => 'In Percentage',
    ],

    //nurses
    'nurse' => [
        'nurse' => 'Nurse',
        'new_nurse' => 'New Nurse',
        'edit_nurse' => 'Edit Nurse',
        'nurse_details' => 'Nurse Details',
        'phone_no' => 'Phone No',
        'birth_date' => 'Birth Date',
        'choose' => 'Choose',
    ],

    //patient
    'patient' => [
        'new_patient' => 'New Patient',
        'edit_patient' => 'Edit Patient',
        'patient_details' => 'Patient Details',
        'total_cases' => 'Total Cases',
        'total_admissions' => 'Total Admissions',
        'total_appointments' => 'Total Appointments',
        'select_one_patient' => 'Please select at least one patient',
        'patient_name_already_taken' => 'The patient name has already been taken',
        'patient_field_required' => 'The patient field is required',
    ],

    // payments keys
    'payment' => [
        'payment' => 'Payment',
        'payments' => 'Payments',
        'payment_details' => 'Payment Details',
        'new_payment' => 'New Payment',
        'edit_payment' => 'Edit Payment',
        'account_name' => 'Account Name',
        'payment_date' => 'Payment Date',
        'pay_to' => 'Pay To',
        'amount' => 'Amount',
        'account' => 'Account',
        'description' => 'Description',
        'payment_reports' => 'Payment Reports',
        'your_payment_is_successfully_completed' => 'Your Payment is successfully completed',
        'payment_failed' => 'Sorry! Payment is failed, Try again after some time',
        'flutterwave_not_support' => 'Flutterwave not supported this currency.',
        'phonepe_support_inr' => 'PhonePe only supported INR currency.',
        'paystack_support_zar' => 'Paystack only supported "USD","GHS","NGN","ZAR","KES" currency.',
        'paystack_token_expired' => 'The paystack token has expired. Please refresh the page and try again.',
        'currency_not_supported_paypal' => 'This currency is not supported by PayPal for making payments.',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'Advance Payment',
        'advanced_payments' => 'Advance Payments',
        'advanced_payment_details' => 'Advance Payment Details',
        'new_advanced_payment' => 'New Advance Payment',
        'edit_advanced_payment' => 'Edit Advance Payment',
        'patient' => 'Patient',
        'receipt_no' => 'Receipt No',
        'amount' => 'Amount',
        'date' => 'Date',
        'patient_name' => 'Patient Name',
    ],

    // beds keys
    'bed' => [
        'bed' => 'New Bed',
        'beds' => 'Beds',
        'bed_details' => 'Bed Details',
        'new_bed' => 'New Bed',
        'edit_bed' => 'Edit Bed',
        'new_bulk_bed' => 'New Bulk Bed',
        'name' => 'Name',
        'bed_type' => 'Bed Type',
        'charge' => 'Charge',
        'available' => 'Available',
        'not_available' => 'Not Available',
        'description' => 'Description',
        'add' => 'Add',
        'bed_id' => 'Bed ID',
        'select_bed_type' => 'Select Bed Type',
        'bed_charge' => 'Bed Charge',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'Bed Type',
        'bed_types' => 'Bed Types',
        'bed_type_details' => 'Bed Type Details',
        'new_bed_type' => 'New Bed Type',
        'edit_bed_type' => 'Edit Bed Type',
        'title' => 'Title',
        'description' => 'Description',
    ],

    'doctor' => [
        'new_doctor' => 'New Doctor',
        'edit_doctor' => 'Edit Doctor',
        'doctor_details' => 'Doctor Details',
        'specialist' => 'Specialist',
        'name' => 'Name',
        'doctor_name_already_taken' => 'The doctor\'s name has already been taken',
        'no_doctor_available' => 'No doctor Available at this moment',
        'appointment_charge' => 'Appointment Charge',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'Bed Assign',
        'bed_assigns' => 'Bed Assigns',
        'bed_assign_details' => 'Bed Assign Details',
        'new_bed_assign' => 'New Bed Assign',
        'edit_bed_assign' => 'Edit Bed Assign',
        'patient_name' => 'Patient Name',
        'bed_name' => 'Bed Name',
        'case_id' => 'Case ID',
        'assign_date' => 'Assign Date',
        'discharge_date' => 'Discharge Date',
        'bed' => 'Bed',
        'description' => 'Description',
        'assigned' => 'Assigned',
        'not_assigned' => 'Not Assigned',
        'ipd_patient_id' => 'IPD Patient ID',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'Bed Assign date should not be smaller than patient birth date.',
        'ipd_patient_department_field_required' => 'The IPD patient department field is required',
    ],

    // packages keys
    'package' => [
        'package' => 'Package',
        'packages' => 'Packages',
        'package_details' => 'Package Details',
        'new_package' => 'New Package',
        'edit_package' => 'Edit Package',
        'name' => 'Name',
        'description' => 'Description',
        'discount' => 'Discount',
        'total_amount' => 'Total Amount',
        'service' => 'Service',
        'qty' => 'Qty',
        'rate' => 'Rate',
        'amount' => 'Amount',
        'select_service' => 'Select Service',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'Print Bill',
        'bill_id' => 'Bill ID',
        'bill' => 'Bill',
        'bills' => 'Bills',
        'bill_details' => 'Bill Details',
        'new_bill' => 'New Bill',
        'edit_bill' => 'Edit Bill',
        'patient' => 'Patient',
        'bill_date' => 'Bill Date',
        'amount' => 'Amount',
        'admission_id' => 'Admission ID',
        'patient_name' => 'Patient Name',
        'patient_email' => 'Patient Email',
        'patient_cell_no' => 'Patient Cell No',
        'patient_gender' => 'Patient Gender',
        'patient_dob' => 'Patient DOB',
        'doctor_name' => 'Doctor Name',
        'admission_date' => 'Admission Date',
        'discharge_date' => 'Discharge Date',
        'package_name' => 'Package Name',
        'insurance_name' => 'Insurance Name',
        'total_days' => 'Total Days',
        'policy_no' => 'Policy No',
        'item_name' => 'Item Name',
        'qty' => 'Qty',
        'price' => 'Price',
        'add' => 'Add',
        'total_amount' => 'Total Amount',
        'edit' => 'Edit',
        'cell_no' => 'Cell No',
        'bill_summary' => 'Bill Summary',
        'generate_bill' => 'Generate Bill',
        'update_bill' => 'Update Bill',
        'calculate' => 'Calculate',
        'note_Bill' => 'Note: After adding charge you must need to re-generate Bill.',
        'manual_bill' => 'Manual Billing Payments',
        'transaction_date' => 'Transaction Date',
        'paymentrequest_sent' => 'Payment Request Sent successfully',
        'manually' => 'Manually',
        'stripe' => 'Stripe',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'are_you_sure' => 'Are you sure?',
        'complete_this_payment' => 'You want to complete this Payment!!',
        'session_id_required' => 'Session Id Required',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'Blood Donor',
        'blood_donors' => 'Blood Donors',
        'blood_donor_details' => 'Blood Donor Details',
        'new_blood_donor' => 'New Blood Donor',
        'edit_blood_donor' => 'Edit Blood Donor',
        'name' => 'Name',
        'age' => 'Age',
        'gender' => 'Gender',
        'blood_group' => 'Blood Group',
        'donation_date' => 'Donation Date',
        'last_donation_date' => 'Last Donation Date',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'Blood Bank',
        'blood_banks' => 'Blood Banks',
        'blood_bank_details' => 'Blood Bank Details',
        'new_blood_group' => 'New Blood Group',
        'edit_blood_group' => 'Edit Blood Group',
        'blood_group' => 'Blood Group',
        'remained_bags' => 'Remained Bags',
    ],

    //Case
    'case' => [
        'case' => 'Case',
        'case_date' => 'Case Date',
        'new_case' => 'New Case',
        'edit_case' => 'Edit Case',
        'case_details' => 'Case Details',
        'phone' => 'Phone',
        'fee' => 'Fee',
        'patient' => 'Patient',
        'doctor' => 'Doctor',
        'case_id' => 'Case ID',
        'date' => 'Date',
        'description' => 'Description',
        'case_date_should_not_be_smaller_than_patient_birth_date' => 'Case date should not be smaller than patient birth date',
    ],

    //services
    'service' => [
        'service' => 'Service',
        'new_service' => 'New Service',
        'edit_service' => 'Edit Service',
        'service_details' => 'Service Details',
        'quantity' => 'Quantity',
        'rate' => 'Rate',
        'given' => 'Given',
        'not_given' => 'Not Given',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'New Appointment',
        'edit_appointment' => 'Edit Appointment',
        'appointment_details' => 'Appointment Details',
        'calendar_view' => 'Calendar View',
        'patient_name' => 'Patient Name',
        'doctor_name' => 'Doctor Name',
        'department_name' => 'Department Name',
        'date' => 'Date',
        'doctor_department' => 'Doctor Department',
        'doctor_department_name' => 'Doctor Department Name',
        'doctor' => 'Doctor',
        'description' => 'Description',
        'patient' => 'Patient',
        'appointment_calendar' => 'Appointment Calendar',
        'appointment_list' => 'Appointment List',
        'completed' => 'Completed',
        'pending' => 'Pending',
        'available_slot' => 'Available Slot',
        'no_available' => 'Not Available',
        'today' => 'Today',
        'month' => 'Month',
        'week' => 'Week',
        'day' => 'Day',
        'opd_date' => 'Opd Date',
        'yesterday' => 'Yesterday',
        'this_week' => 'This Week',
        'last_7_days' => 'Last 7 days',
        'last_30_days' => 'Last 30 days',
        'this_month' => 'This month',
        'last_month' => 'Last month',
        'change_status' => 'Change status',
        'are_you_sure_want_to_change' => 'Are you sure want to change ',
        'changed_appointment' => 'Changed Appointment',
        'has_been_changed' => 'has been Changed.',
        'are_you_sure_want_to_cancel' => 'Are you sure want to cancel',
        'has_been_cancelled' => 'has been Cancelled.',
        'please_select_doctor_department' => 'Please select Doctor Department',
        'please_select_doctor' => 'Please select Doctor',
        'doctor_schedule_not_available_on_this_date' => 'Doctor Schedule not available this date.',
        'please_select_appointment_time_slot' => 'Please select appointment time slot',
        'patient_not_exists_or_status_is_not_active' => 'Patient not exists or status is not active.',
        'appointment_exists' => 'Appointment already exists',
        'old_patient_email_exists' => 'Email already exists, please select old patient.',
        'time' => 'Time',
    ],

    'case_handler' => [
        'case_handler' => 'Case Handler',
        'new_case_handler' => 'New Case Handler',
        'edit_case_handler' => 'Edit Case Handler',
        'case_handler_detail' => 'Case Handler Details',
    ],

    'lab_tech' => [
        'lab_technician' => 'Lab Technician',
        'new_lab_tech' => 'New Lab Technician',
        'edit_lab_tech' => 'Edit Lab Technician',
        'lab_tech_detail' => 'Lab Technician Details',
    ],

    'doc_type' => [
        'new_doc_type' => 'New Document Type',
        'edit_doc_type' => 'Edit Document Type',
        'name' => 'Name',
    ],

    'document' => [
        'document' => 'Document',
        'documents' => 'Documents',
        'new_document' => 'New Document',
        'edit_document' => 'Edit Document',
        'title' => 'Title',
        'document_type' => 'Document Type',
        'document_type_details' => 'Document Type Details',
        'patient' => 'Patient',
        'download' => 'Download',
        'select_patient' => 'Select Patient',
        'select_document_type' => 'Select Document Type',
        'uploaded_by' => 'Uploaded By',
        'document_detail' => 'Document Details',
        'notes' => 'Notes',
        'view' => 'View',
        'attachment' => 'Attachment',
        'validate_doc_type' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx, webp',
        'select_attachment' => 'Please select attachment.',
    ],

    'patient_admission' => [
        'patient_admission' => 'Patient Admission',
        'new_patient_admission' => 'New Patient Admission',
        'edit_patient_admission' => 'Edit Patient Admission',
        'details' => 'Patient Admission Details',
        'patient' => 'Patient',
        'patient_name' => 'Patient Name',
        'doctor' => 'Doctor',
        'doctor_name' => 'Doctor Name',
        'admission_date' => 'Admission Date',
        'discharge_date' => 'Discharge Date',
        'package' => 'Package',
        'package_name' => 'Package Name',
        'insurance' => 'Insurance',
        'insurance_name' => 'Insurance Name',
        'policy_no' => 'Policy No',
        'bed' => 'Bed',
        'agent_name' => 'Agent Name',
        'guardian_name' => 'Guardian Name',
        'guardian_relation' => 'Guardian Relation',
        'guardian_contact' => 'Guardian Contact',
        'guardian_address' => 'Guardian Address',
        'patient_admission_id' => 'Patient Admission ID',
        'admission_date_should_not_be_smaller_than_patient_birth_date' => 'Admission date should not be smaller than patient birth date',
        'Admission_field_required' => 'The Admission id field is required.'
    ],

    'setting' => [
        'app_name' => 'Application Name',
        'company_name' => 'Company Name',
        'app_logo' => 'Application Logo',
        'currency' => 'Currency',
        'address' => 'Hospital Address',
        'hospital_email' => 'Hospital Email',
        'hospital_phone' => 'Hospital Phone',
        'hospital_from_day' => 'Hospital Start Day',
        'hospital_from_time' => 'Hospital Start Time',
        'about_us' => 'About Us',
        'image_validation' => 'The image must be 90 x 60 pixels.',
        'favicon' => 'Favicon',
        'favicon_validation' => 'The image must be 34 x 34 pixels.',
        'social_details' => 'Social Details',
        'country_code' => 'Country Code',
        'default_language' => 'Default Language',
    ],

    'currency' => [
        'currency' => 'Currency',
        'new_currency' => 'New Currency',
        'edit_currency' => 'Edit Currency',
        'currency_name' => 'Currency Name',
        'currency_code' => 'Currency Code',
        'currency_icon' => 'Currency Icon',
        'add_currency_code_as_per_three_letter_iso_code' => 'Add currency code as per three-letter ISO code',
        'you_can_find_out_here' => 'you can find out here',
        'currency_setting_not_found' => 'Currency Setting not found',
    ],

    'schedule' => [
        'new' => 'New Schedule',
        'edit' => 'Edit Schedule',
        'details' => 'Schedule Details',
        'doctor_name' => 'Doctor Name',
        'select_doctor_name' => 'Select Doctor Name',
        'per_patient_time' => 'Per Patient Time',
        'serial_visibility' => 'Serial Visibility',
        'select_serial_visibility' => 'Select Serial Visibility',
        'available_on' => 'Available On',
        'available_from' => 'Available From',
        'available_to' => 'Available To',
        'sequential' => 'Sequential',
        'timestamp' => 'Timestamp',
        'schedule_time_select' => 'Please select per patient time',
        'schedule_time' => 'Available From time must be greater than hospital schedule time',
        'available_time_greater_than_zero' => 'Available From time must be greater than Zero',
        'available_to_time_greater_than_zero' => 'Available To time must be greater than Zero',
        'available_time_less_than_hospital_schedule_time' => 'Available To time must be less than hospital schedule time',
    ],

    'notice_board' => [
        'notice_board' => 'Notice Board',
        'new' => 'New Notice Board',
        'edit' => 'Edit Notice Board',
        'details' => 'Notice Board Details',
        'title' => 'Title',
        'description' => 'Description',
        'created_at' => 'Created At',
    ],

    'my_payroll' => [
        'my_payrolls' => 'My Payrolls',
        'basic_salary' => 'Basic Salary',
        'allowance' => 'Allowance',
        'deductions' => 'Deductions',
        'net_salary' => 'Net Salary',
    ],
    'medicine' => [
        'medicine' => 'Medicine',
        'medicine_category' => 'Medicine Category',
        'medicine_category_details' => 'Medicine Category Details',
        'medicines' => 'Medicines',
        'medicine_details' => 'Medicine Details',
        'new_medicine' => 'New Medicine',
        'new_medicine_category' => 'New Medicine Category',
        'edit_medicine_category' => 'Edit Medicine Category',
        'edit_medicine' => 'Edit Medicine',
        'name' => 'Name',
        'brand' => 'Brand',
        'selling_price' => 'Selling Price',
        'buying_price' => 'Buying Price',
        'category' => 'Category',
        'salt_composition' => 'Salt Composition',
        'side_effects' => 'Side Effects',
        'description' => 'Description',
        'category_id' => 'Category ID',
        'brand_name' => 'Brand Name',
        'medicine_brands' => 'Medicine Brands',
        'medicine_brands_details' => 'Medicine Brand Details',
        'new_brand' => 'New Brand',
        'new_medicine_brand' => 'New Medicine Brand',
        'edit_medicine_brand' => 'Edit Medicine Brand',
        'select_category' => 'Select Category',
        'select_brand' => 'Select Brand',
        'is_active' => 'Is active',
        'delete_medicine' => 'This medicine is already used in medicine bills, are you sure want to delete it?',
        'category_field_required' => 'The Category field is required',
        'brand_field_required' => 'The Brand  field is required.',
    ],

    'profile' => [
        'change_language' => 'Change Language',
        'language' => 'Language',
        'edit_profile' => 'Edit Profile',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'profile' => 'Profile',
    ],

    'dashboard' => [
        'dashboard' => 'Dashboard',
        'total_invoices' => 'Invoice Amount',
        'total_bills' => 'Bill Amount',
        'total_payments' => 'Payment Amount',
        'total_advance_payments' => 'Advance Payment Amount',
        'notice_boards' => 'Notice Boards',
        'title' => 'Title',
        'doctors' => 'Doctors',
        'available_beds' => 'Available Beds',
        'patients' => 'Patients',
        'income_and_expense_report' => 'Income and Expense Report',
        'income_and_expense_reports' => 'Income and Expense Reports',
        'no_enquiries_yet' => 'No Enquiries Yet',
        'no_notice_yet' => 'No Notice Yet',
        'total_appointment' => 'Total Appointments',
        'today_appointment' => 'Today Appointment',
        'total_meeting' => 'Total Meetings',
        'sum_of_ipd' => 'IPD due Amount',
        'recent_appointments' => 'Recent Appointments'
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'Name',
        'email' => 'Email',
        'contact' => 'Contact',
        'type' => 'Type',
        'message' => 'Message',
        'viewed_by' => 'Viewed By',
        'enquiry_details' => 'Enquiry Details',
        'read' => 'Read',
        'unread' => 'Unread',
        'not_viewed' => 'Not Viewed',
        'received_on' => 'Received On',
        'send_enquiry' => 'Send Enquiry',
        'enquiry_send_successfully' => 'Enquiry send successfully',
    ],

    'email' => [
        'to' => 'To',
        'subject' => 'Subject',
        'message' => 'Message',
        'attachment' => 'Attachment',
    ],

    'verification' => [
        'verify_your_email_address' => 'Verify Your Email Address',
        'verify_message' => 'Before proceeding, please check your email for a verification link.If you did not receive the email,',
        'another_verify_request' => 'click here to request another',
        'click_button_for_verify_email' => 'Please click the button below to verify your email address.',
        'further_action_required' => 'If you did not create an account, no further action is required.',
        'verify_email_address' => 'Verify Email Address',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'Ambulance',
        'ambulances' => 'Ambulances',
        'ambulance_details' => 'Ambulance Details',
        'vehicle_number' => 'Vehicle Number',
        'vehicle_model' => 'Vehicle Model',
        'year_made' => 'Year Made',
        'driver_name' => 'Driver Name',
        'driver_license' => 'Driver License',
        'driver_contact' => 'Driver Contact',
        'note' => 'Note',
        'vehicle_type' => 'Vehicle Type',
        'is_available' => 'Is Available',
        'new_ambulance' => 'New Ambulance',
        'edit_ambulance' => 'Edit Ambulance',
    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'Ambulance Call',
        'ambulance_calls' => 'Ambulance Calls',
        'ambulance_call_details' => 'Ambulance Call Details',
        'vehicle_model' => 'Vehicle Model',
        'patient' => 'Patient',
        'driver_name' => 'Driver Name',
        'date' => 'Date',
        'amount' => 'Amount',
        'new_ambulance_call' => 'New Ambulance Call',
        'edit_ambulance_call' => 'Edit Ambulance Call',
    ],

    // prescription keys
    'prescription' => [
        'prescription' => 'Prescription',
        'prescriptions' => 'Prescriptions',
        'prescription_details' => 'Prescription Details',
        'new_prescription' => 'New Prescription',
        'edit_prescription' => 'Edit Prescription',
        'patient' => 'Patient',
        'food_allergies' => 'Food Allergies',
        'tendency_bleed' => 'Tendency Bleed',
        'heart_disease' => 'Heart Disease',
        'high_blood_pressure' => 'High Blood Pressure',
        'diabetic' => 'Diabetic',
        'surgery' => 'Surgery',
        'accident' => 'Accident',
        'others' => 'Others',
        'medical_history' => 'Added At',
        'current_medication' => 'Current Medication',
        'female_pregnancy' => 'Female Pregnancy',
        'breast_feeding' => 'Breast Feeding',
        'health_insurance' => 'Health Insurance',
        'low_income' => 'Low Income',
        'reference' => 'Reference',
        'reference_id' => 'Reference ID',
        'physical_information' => 'Physical Information',
        'physical_information_name' => 'Physical Information Name',
        'physical_information_value' => 'Physical Information Value',
        'new_medicine' => 'New Medicine',
        'plus_rate' => 'Pulse Rate',
        'temperature' => 'Temperature',
        'problem_description' => 'Problem Description',
        'test' => 'Test',
        'advice' => 'Advice',
        'next_visit' => 'Next Visit',
        'time' => 'Time',
        'comment' => 'Comment',
        'problem' => 'Problem',
        'rx' => 'Rx',
        'medicine_name' => 'Medicine Name',
        'duration' => 'Duration',
        'days' => 'Days',
        'after_meal' => 'After Meal',
        'before_meal' => 'Before Meal',
        'year' => 'Year',
        'month' => 'Month',
        'no_data_available' => 'No Data Available',
    ],

    'charge_category' => [
        'charge_categories' => 'Charge Categories',
        'new_charge_category' => 'New Charge Category',
        'edit_charge_category' => 'Edit Charge Category',
        'charge_type' => 'Charge Type',
        'charge_category_details' => 'Charge Category Details',
    ],

    'charge' => [
        'new_charge' => 'New Charge',
        'edit_charge' => 'Edit Charge',
        'charge_details' => 'Charge Details',
        'charge_category' => 'Charge Category',
        'standard_charge' => 'Standard Charge',
        'code' => 'Code',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'Name',
        'radiology_categories' => 'Radiology Categories',
        'new_radiology_category' => 'New Radiology Category',
        'edit_radiology_category' => 'Edit Radiology Category',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'Pathology Categories',
        'new_pathology_category' => 'New Pathology Category',
        'edit_pathology_category' => 'Edit Pathology Category',
        'name' => 'Name',
        'select_charge_category' => 'Select Charge Category',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'Radiology Test',
        'new_radiology_test' => 'New Radiology Test',
        'edit_radiology_test' => 'Edit Radiology Test',
        'radiology_test_details' => 'Radiology Test Details',
        'test_name' => 'Test Name',
        'short_name' => 'Short Name',
        'test_type' => 'Test Type',
        'category_name' => 'Category Name',
        'subcategory' => 'Sub Category',
        'report_days' => 'Report Days',
        'charge_category' => 'Charge Category',
        'code' => 'Code',
        'standard_charge' => 'Standard Charge',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'doctor_opd_charge' => 'Doctor OPD Charge',
        'new_doctor_opd_charge' => 'New Doctor OPD Charge',
        'edit_doctor_opd_charge' => 'Edit Doctor OPD Charge',
        'doctor_name' => 'Doctor Name',
        'standard_charge' => 'Standard Charge',
        'doctor' => 'Doctor',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'Pathology Test',
        'new_pathology_test' => 'New Pathology Test',
        'edit_pathology_test' => 'Edit Pathology Test',
        'pathology_test_details' => 'Pathology Test Details',
        'test_name' => 'Test Name',
        'short_name' => 'Short Name',
        'test_type' => 'Test Type',
        'category_name' => 'Category Name',
        'unit' => 'Unit',
        'subcategory' => 'Sub Category',
        'method' => 'Method',
        'report_days' => 'Report Days',
        'charge_category' => 'Charge Category',
        'standard_charge' => 'Standard Charge',
    ],

    //expenses keys
    'expense' => [
        'expense' => 'Expense',
        'new_expense' => 'New Expense',
        'edit_expense' => 'Edit Expense',
        'expense_head' => 'Expense Head',
        'name' => 'Name',
        'date' => 'Date',
        'invoice_number' => 'Invoice Number',
        'amount' => 'Amount',
        'attachment' => 'Attachment',
        'description' => 'Description',
        'choose' => 'Choose',
        'download' => 'Download',
        'select_expense_head' => 'Select Expense Head',
        'expense_details' => 'Expense Details',
        'document_error' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'Incomes',
        'new_income' => 'New Income',
        'edit_income' => 'Edit Income',
        'income_head' => 'Income Head',
        'name' => 'Name',
        'date' => 'Date',
        'invoice_number' => 'Invoice Number',
        'amount' => 'Amount',
        'attachment' => 'Attachment',
        'description' => 'Description',
        'choose' => 'Choose',
        'download' => 'Download',
        'select_income_head' => 'Select Income Head',
        'income_details' => 'Income Details',
        'document_error' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Bed Status',
        'assigned_beds' => 'Assigned Beds',
        'available_beds' => 'Available Beds',
        'bed_name' => 'Bed Name',
        'patient_name' => 'Patient Name',
        'phone' => 'Phone',
        'admission_date' => 'Admission Date',
        'gender' => 'Gender',
    ],

    //Messages keys
    'message' => [
        'message' => 'Message',
        'messages' => 'Messages',
        'send_to' => 'Send To',
        'subject' => 'Subject',
        'new_message' => 'New Message',
        'messages_details' => 'Message Details',
        'sender_name' => 'Sender Name',
        'date' => 'Date',
        'select_user' => 'Select User',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'SMS',
        'new_sms' => 'New SMS',
        'send_to' => 'Send To',
        'phone_number' => 'Phone Number',
        'send_by' => 'Send By',
        'message' => 'Message',
        'sms_details' => 'SMS Details',
        'date' => 'Date',
        'send' => 'Send',
        'role' => 'Role',
        'send_sms_by_number_directly' => 'Send SMS by number directly',
        'only_user_with_registered_phone_will_display' => '(Only Users with a registered phone will display.)',
        'message_not_greater_than_160_characters' => 'The message may not be greater than 160 characters.',
        'set_credential' => 'Please set your credential',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'Diagnosis',
        'diagnosis_test' => 'Diagnosis Tests',
        'patient_diagnosis_test' => 'Patient Diagnosis Tests',
        'report_number' => 'Report number',
        'patient' => 'Patient',
        'doctor' => 'Doctor',
        'created_at' => 'Created at',
        'action' => 'Action',
        'new_patient_diagnosis_test' => 'New Patient Diagnosis Test',
        'edit_patient_diagnosis_test' => 'Edit Patient Diagnosis Test',
        'create_patient_diagnosis_test' => 'Create Patient Diagnosis Test',
        'patient_diagnosis_test_details' => 'Patient Diagnosis Test Details',
        'diagnosis_category' => 'Diagnosis Category',
        'add_other_diagnosis_property' => 'Add other diagnosis property',
        'other_diagnosis_property' => 'Other diagnosis property',
        'diagnosis_property_name' => 'Diagnosis Property Name',
        'diagnosis_property_value' => 'Diagnosis Property Value',
        'patient_name' => 'Patient name',
        'doctor_name' => 'Doctor name',
        'age' => 'Age',
        'height' => 'Height',
        'weight' => 'Weight',
        'average_glucose' => 'Average glucose',
        'fasting_blood_sugar' => 'Fasting Blood Sugar',
        'urine_sugar' => 'Urine Sugar',
        'blood_pressure' => 'Blood Pressure',
        'diabetes' => 'Diabetes',
        'cholesterol' => 'Cholesterol',
        'print_diagnosis_test' => 'Print Diagnosis Test',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'Diagnosis Category',
        'diagnosis_categories' => 'Diagnosis Categories',
        'new_diagnosis_category' => 'New Diagnosis Category',
        'description' => 'Description',
        'category_name' => 'Category name',
        'diagnosis_category_details' => 'Diagnosis Category Details',
        'edit_diagnosis_category' => 'Edit Diagnosis Category',
    ],

    // Operation Category
    'operation_category' => [
        'operation_category' => 'Operation Category',
        'operation_categories' => 'Operation Categories',
        'new_operation_category' => 'New Operation Category',
        'edit_operation_category' => 'Edit Operation Category',
        'operation_category_field_required' => 'Operation category field is required.',
    ],

    // Operation
    'operation' => [
        'operation' => 'Operation',
        'operation_field_required' => 'Operation field is required.',
        'select_operation_date' => 'Please select operation date.',
        'operation_date' => 'Operation Date',
        'operation_name' => 'Operation Name',
        'operation_category_name' => 'Operation category Name',
        'ot_technician' => 'OT Technician',
        'ot_assistant' => 'OT Assistant',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'Item Category',
        'item_categories' => 'Item Categories',
        'new_item_category' => 'New Item Category',
        'edit_item_category' => 'Edit Item Category',
        'name' => 'Name',
    ],

    'item' => [
        'item' => 'Item',
        'items' => 'Items',
        'new_item' => 'New Item',
        'edit_item' => 'Edit Item',
        'item_details' => 'Item Details',
        'name' => 'Name',
        'item_category' => 'Item Category',
        'unit' => 'Unit',
        'description' => 'Description',
        'available_quantity' => 'Available Quantity',
    ],

    'item_stock' => [
        'item_stock' => 'Item Stock',
        'item_stocks' => 'Item Stocks',
        'new_item_stock' => 'New Item Stock',
        'edit_item_stock' => 'Edit Item Stock',
        'item_stock_details' => 'Item Stock Details',
        'item_category' => 'Item Category',
        'item' => 'Item Name',
        'supplier_name' => 'Supplier Name',
        'store_name' => 'Store Name',
        'quantity' => 'Quantity',
        'purchase_price' => 'Purchase Price',
        'description' => 'Description',
        'attachment' => 'Attachment',
    ],

    'issued_item' => [
        'issued_item' => 'Issued Item',
        'issued_items' => 'Issued Items',
        'new_issued_item' => 'New Issued Item',
        'edit_issued_item' => 'Edit Issued Item',
        'issued_item_details' => 'Issued Items Details',
        'department_id' => 'User Type',
        'user_id' => 'Issue To',
        'issued_by' => 'Issue By',
        'issued_date' => 'Issue Date',
        'return_date' => 'Return Date',
        'item_category' => 'Item Category',
        'item' => 'Item',
        'quantity' => 'Quantity',
        'description' => 'Description',
        'available_quantity' => 'Available Quantity',
        'item_return' => 'Return Item',
        'item_returned' => 'Returned',
        'are_you_sure_want_to_return_this_item' => 'Are you sure want to return this item',
        'quantity_cannot_be_zero' => 'Quantity cannot be zero.',
        'quantity_must_be_less_than_available_quantity' => 'Quantity must be less than Available quantity.'
    ],

    'ipd_patient' => [
        'ipd_patient_in' => 'IPD - Patient In',
        'ipd_patient' => 'IPD Patient',
        'ipd_patients' => 'IPD Patients',
        'new_ipd_patient' => 'New IPD Patient',
        'edit_ipd_patient' => 'Edit IPD Patient',
        'ipd_patient_details' => 'IPD Patient Details',
        'patient_id' => 'Patient',
        'ipd_number' => 'IPD No',
        'height' => 'Height',
        'weight' => 'Weight',
        'bp' => 'Blood Pressure',
        'symptoms' => 'Symptoms',
        'notes' => 'Notes',
        'admission_date' => 'Admission Date',
        'case_id' => 'Case',
        'is_old_patient' => 'Is Old Patient',
        'doctor_id' => 'Doctor',
        'bed_type_id' => 'Bed Type',
        'bed_id' => 'Bed',
        'bill_status' => 'Bill Status',
        'the_case_field_is_required' => 'The case field is required.',
        'the_bed_field_is_required' => 'The bed field is required.',
        'the_bed_type_is_required' => 'The bed type field is required.',
        'charge_required' => 'Charge field Required.',
        'the_bed_field_has_a_duplicate_value' => 'The bed field has a duplicate value',
        'the_bed_already_taken' => 'The Bed :input has already been taken',
        'discharge' => 'Discharge',
        'net_amount' => 'Net Amount',
        'discharged' => 'Discharged',
        'not_dischared' => 'Not Discharged',
        'discharge_slip' => 'Discharge Slip',
        'print_discharge_slip' => 'Print Discharge Slip',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'Add Diagnosis',
        'edit_ipd_diagnosis' => 'Edit Diagnosis',
        'report_type' => 'Report Type',
        'report_date' => 'Report Date',
        'document' => 'Document',
        'description' => 'Description',
    ],

    'ipd_patient_consultant_register' => [
        'consultant_doctor' => 'Consultant Doctor',
        'consultant_instruction' => 'Consultant Instruction',
        'new_consultant_register' => 'Add Consultant Instruction',
        'edit_consultant_register' => 'Edit Consultant Instruction',
        'applied_date' => 'Applied Date',
        'doctor_id' => 'Doctor',
        'instruction' => 'Instruction',
        'instruction_date' => 'Instruction Date',
        'applied_date_or_Instruction_date_can_not_be_null' => 'Applied date or Instruction date can not be null',
        'assistant_consultant_1' => 'Assistant Consultant 1',
        'assistant_consultant_2' => 'Assistant Consultant 2',
        'anesthetist' => 'Anesthetist',
        'anesthesia_type' => 'Anesthesia Type',
        'instruction_field_is_required' => 'The instruction field is required.',
    ],

    'ipd_patient_charges' => [
        'new_charge' => 'Add Charges',
        'edit_charge' => 'Edit Charges',
        'date' => 'Date',
        'charge_type_id' => 'Charge Type',
        'charge_category_id' => 'Charge Category',
        'charge_id' => 'Code',
        'standard_charge' => 'Standard Charge',
        'applied_charge' => 'Applied Charge',
    ],

    'ipd_operation' => [
        'ipd_operation' => 'IPD operation',
        'ipd_operation_created_successfully' => 'IPD operation created successfully',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD No',
        'header_note' => 'Header Note',
        'footer_note' => 'Footer Note',
        'new_prescription' => 'Add Prescription',
        'edit_prescription' => 'Edit Prescription',
        'prescription_details' => 'Prescription Details',
        'category_id' => 'Medicine Category',
        'medicine_id' => 'Medicine',
        'dosage' => 'Dosage',
        'instruction' => 'Instruction',
        'print_prescription' => 'Print Prescription',
    ],

    'ipd_patient_timeline' => [
        'timeline' => 'Timeline',
        'new_ipd_timeline' => 'Add Timeline',
        'edit_ipd_timeline' => 'Edit Timeline',
        'title' => 'Title',
        'date' => 'Date',
        'description' => 'Description',
        'document' => 'Document',
        'visible_to_person' => 'Visible To Person',
        'no_timeline_found' => 'No TimeLine Found',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'Add IPD Payment',
        'edit_ipd_payment' => 'Edit IPD Payment',
        'payment_mode' => 'Payment Mode',
        'make_payment' => 'Make Payment',
    ],

    'ipd_bill' => [
        'paid_amount' => 'Paid Amount',
        'total_charges' => 'Total Charges',
        'gross_total' => 'Gross Total',
        'discount_in_percentage' => 'Discount In Percentage',
        'discount_in_number' => 'Discount In Number',
        'tax_in_percentage' => 'Tax In Percentage',
        'tax_in_number' => 'Tax In Number',
        'other_charges' => 'Other Charges',
        'net_payable_amount' => 'Net Payable Amount',
        'discharge_patient' => 'Discharge Patient',
    ],

    'opd_patient' => [
        'opd_patient_out' => 'OPD - Patient Out',
        'opd_patient' => 'OPD Patient',
        'opd_patients' => 'OPD Patients',
        'new_opd_patient' => 'New OPD Patient',
        'edit_opd_patient' => 'Edit OPD Patient',
        'opd_patient_details' => 'OPD Patient Details',
        'opd_number' => 'OPD No',
        'appointment_date' => 'Appointment Date',
        'visits' => 'Visits',
        'revisits' => 'Revisit',
        'total_visits' => 'Total Visits',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'Add Opd Payment',
        'edit_opd_payment' => 'Edit Opd Payment',
        'payment_mode' => 'Payment Mode',
        'make_payment' => 'Make Payment',
    ],

    'call_log' => [
        'call_log' => 'Call Log',
        'new' => 'New Call Log',
        'edit' => 'Edit Call Log',
        'name' => 'Name',
        'phone' => 'Phone',
        'received_on' => 'Received On',
        'follow_up_date' => 'Follow-Up Date',
        'note' => 'Note',
        'call_type' => 'Call Type',
        'incoming' => 'Incoming',
        'outgoing' => 'Outgoing',
    ],

    'visitor' => [
        'visitor' => 'Visitor',
        'new' => 'New Visitor',
        'edit' => 'Edit Visitor',
        'name' => 'Name',
        'purpose' => 'Purpose',
        'phone' => 'Phone',
        'id_card' => 'ID Card',
        'number_of_person' => 'Number Of Person',
        'date' => 'Date',
        'in_time' => 'In Time',
        'out_time' => 'Out Time',
        'note' => 'Note',
    ],

    'postal' => [
        'postal' => 'Postal',
        'new_receive' => 'New Receive',
        'new_dispatch' => 'New Dispatch',
        'dispatch' => 'Dispatch',
        'receive' => 'Receive',
        'edit_receive' => 'Edit Receive',
        'edit_dispatch' => 'Edit Dispatch',
        'to_title' => 'To Title',
        'from_title' => 'From Title',
        'reference_no' => 'Reference Number',
        'date' => 'Date',
        'address' => 'Address',
        'validate_from_title' => 'The from title is required',
        'validate_to_title' => 'The to title is required.',
    ],

    'testimonial' => [
        'testimonial' => 'Testimonial',
        'new_testimonial' => 'New Testimonial',
        'edit_testimonial' => 'Edit Testimonial',
        'testimonial_detail' => 'Testimonial Detail',
        'name' => 'Name',
        'description' => 'Description',
        'profile_error' => 'The document must be a file of type: jpeg, jpg, png.',
    ],

    'blood_donation' => [
        'blood_donation' => 'Blood Donation',
        'new_blood_donation' => 'New Blood Donation',
        'edit_blood_donation' => 'Edit Blood Donation',
        'donor_name' => 'Donor Name',
        'bags' => 'Bags',
        'last_donate_date' => 'Last donate date',
    ],

    'blood_issue' => [
        'blood_issue' => 'Blood Issue',
        'new_blood_issue' => 'New Blood Issue',
        'edit_blood_issue' => 'Edit Blood Issue',
        'issue_date' => 'Issue Date',
        'patient_name' => 'Patient Name',
        'doctor_name' => 'Doctor Name',
        'donor_name' => 'Donor Name',
        'amount' => 'Amount',
        'remarks' => 'Remarks',
    ],

    'notification' => [
        'all_notification_read_successfully' => 'All Notification Read successfully',
        'notification_read_successfully' => 'Notification Read successfully',
        'notifications' => 'Notifications',
        'mark_all_as_read' => 'Mark All As Read',
        'you_don`t_have_any_new_notification' => 'You don\'t have any new notification',
    ],

    'live_consultation' => [
        'live_consultation' => 'Live Consultancy',
        'new_live_consultation' => 'New Live Consultation',
        'consultation_title' => 'Consultation Title',
        'consultation_date' => 'Consultation Date',
        'consultation_duration_minutes' => 'Consultation Duration Minutes',
        'client_video' => 'Client Video',
        'host_video' => 'Host Video',
        'enable' => 'Enable',
        'disabled' => 'Disabled',
        'type' => 'Type',
        'type_number' => 'Type Number',
        'created_by' => 'Created By',
        'created_for' => 'Created For',
        'new_live_meeting' => 'New Live Meeting',
        'staff_list' => 'Staff List',
        'edit_live_consultation' => 'Edit Live Consultation',
        'duration' => 'Duration (in minutes)',
        'start_now' => 'Start Now',
        'join_now' => 'Join Now',
        'edit_live_meeting' => 'Edit Live Meeting',
        'add_credential' => 'Add Credential',
        'zoom_api_key' => 'Zoom Api Key',
        'zoom_api_secret' => 'Zoom API Secret',
        'join_meeting' => 'Join Meeting',
        'start_meeting' => 'Start Meeting',
        'generate_auth_credentials' => 'How to generate Auth Credentials ?',
        'user_zoom_credential_saved' => 'user Zoom Credential saved successfully.',
        'add_credentials_for_zoom_meeting' => 'Please, add credentials for zoom meeting.',
        'invalid_access_token' => 'Invalid access token.',
        'credentials_already_use' => 'Your zoom credentials are already in use',
        'connect_with_zoom' => 'You have to connect with zoom',
        'cannot_delete_meeting_in_progress' => 'Sorry, you cannot delete this meeting since it\'s in progress',
        'select_platform' => 'Select Platform',
    ],

    'vaccination' => [
        'vaccinations' => 'Vaccination',
        'new_vaccination' => 'New Vaccination',
        'edit_vaccination' => 'Edit Vaccination',
        'name' => 'Name',
        'manufactured_by' => 'Manufactured By',
        'brand' => 'Brand',
        'vaccinated' => 'Vaccinated',
    ],

    'vaccinated_patient' => [
        'vaccinated_patient' => 'Vaccinated Patient',
        'patient' => 'Patient',
        'vaccination' => 'Vaccination',
        'vaccination_name' => 'Vaccination Name',
        'serial_no' => 'Serial No',
        'does_no' => 'Dose No',
        'dose_given_date' => 'Dose Given Date',
        'description' => 'Description',
        'add_vaccinate_patient' => 'Add Vaccinated Patient',
        'new_vaccinate_patient' => 'New Vaccinated Patient',
        'edit_vaccinate_patient' => 'Edit Vaccinated Patient',
        'vaccine' => 'Vaccine',
        'vaccinate_patient' => 'Vaccinate Patient',
        'already_registered_dose' => 'The patient is already registered with same vaccine and dose no',
    ],

    'front_setting' => [
        'front_setting_details' => 'Front Setting Details',
        'about_us_details' => 'About Us Details',
        'appointment_details' => 'Appointment Details',
        'terms_condition_details' => 'T&C Details',
        'about_us_title' => 'Title',
        'about_us_mission' => 'Mission',
        'about_us_image' => 'Image',
        'about_us_description' => 'Description',
        'home_page_image' => 'Home Page Image',
        'home_page_title' => 'Home Page Title',
        'home_page_description' => 'Home Page Description',
        'home_page_box_title' => 'Home Page Box Title',
        'home_page_box_description' => 'Home Page Box Description',
        'home_page_experience' => 'Home Page Experience',
        'home_page_step_1_title' => 'Home Page Step 1 Title',
        'home_page_step_1_description' => 'Home Page Step 1 Description',
        'home_page_step_2_title' => 'Home Page Step 2 Title',
        'home_page_step_2_description' => 'Home Page Step 2 Description',
        'home_page_step_3_title' => 'Home Page Step 3 Title',
        'home_page_step_3_description' => 'Home Page Step 3 Description',
        'home_page_step_4_title' => 'Home Page Step 4 Title',
        'home_page_step_4_description' => 'Home Page Step 4 Description',
        'terms_conditions' => 'Terms & Conditions',
        'privacy_policy' => 'Privacy Policy',
        'home_page_certified_doctor_image' => 'Home Page Certified Doctor Image',
        'home_page_certified_doctor_text' => 'Home Page Certified Doctor Text',
        'home_page_certified_doctor_title' => 'Home Page Certified Doctor Title',
        'home_page_certified_doctor_description' => 'Home Page Certified Doctor Description',
        'home_page_certified_box_title' => 'Home Page Certified Box Title',
        'home_page_certified_box_description' => 'Home Page Certified Box Description',
        'the_terms_conditions_is_required' => 'The Terms & Conditions is required.',
        'the_privacy_policy_is_required' => 'The Privacy Policy is required.',
        'home_page_experience_required' => 'Home page experience field is not contain only white space',
        'home_page_title_required' => 'Home page title field is not contain only white space',
        'home_page_description_required' => 'Home page description field is not contain only white space',
        'home_page_box_required' => 'Home page box title field is not contain only white space',
        'home_page_box_descriptions_required' => 'Home page box descriptions field is not contain only white space',
        'home_page_certified_required' => 'Home page certified doctor text field is not contain only white space',
        'home_page_certified_title_required' => 'home page certified doctor Title field is not contain only white space',
        'home_page_certified_doctor_description_required' => 'Home page certified doctor description field is not contain only white space',
        'home_page_certified_box_title_required' => 'Home page certified box title field is not contain only white space',
        'home_page_certified_description_required' => 'Home page certified certified description field is not contain only white space',
        'home_page_step_title_required' => 'Home page step 1 title field is not contain only white space',
        'home_page_step_description_required' => 'Home page step 1 description field is not contain only white space',
        'home_page_step_two_title_required' => 'Home page step 2 title field is not contain only white space',
        'home_page_step_two_description_required' => 'Home page step 2 description field is not contain only white space',
        'home_page_step_three_title_required' => 'Home page step 3 title field is not contain only white space',
        'home_page_step_three_description_required' => 'Home page step 3 description field is not contain only white space',
        'home_page_step_four_title_required' => 'Home page step 4 title field is not contain only white space',
        'home_page_step_four_description_required' => 'Home page step 4 description field is not contain only white space',
        'about_us_title_required' => 'About us title field is not contain only white space',
        'about_us_description_required' => 'About us description field is not contain only white space',
        'about_us_mission_required' => 'About us mission field is not contain only white space',
    ],

    'change_password' => [
        'change_password' => 'Change Password',
        'current_password' => 'Current Password',
        'new_password' => 'New Password',
        'confirm_password' => 'Confirm Password',
    ],

    'front_services' => [
        'new_service' => 'New Service',
        'edit_service' => 'Edit Service',
        'select_icon_file' => 'Please select icon file',
    ],

    'web_home' => [
        'home' => 'Home',
        'services' => 'Services',
        'doctors' => 'Doctors',
        'about_us' => 'About Us',
        'contact' => 'Contact',
        'make_appointment' => 'Make Appointment',
        'working_hours' => 'Working Hours',
        'testimonials' => 'Testimonials',
        'terms_of_service' => 'Terms of Service',
        'privacy_policy' => 'Privacy Policy',
        'patients' => 'Patients',
        'years_experience' => 'Years Experience',
        'sign_up' => 'Sign Up',
        'available_doctors' => 'Available Doctors',
        'select_doctors' => 'Select Doctors',
        'contact_doctors' => 'Contact Doctor',
        'contact_hospital' => 'Contact Hospital',
        'easy_solutions' => 'Easy Solutions',
        '4_easy_step_and_get_the_world_best_treatment' => '4 Easy Step and Get the World Best Treatment',
        'book_an_appointment' => 'Book an Appointment',
        'select_doctor' => 'Select Doctor',
        'book_now' => 'Book Now',
        'patients_beds' => 'Patients Beds',
        'doctors_nurses' => 'Doctors & Nurses',
        'happy_patients' => 'Happy Patients',
        'book_appointment' => 'Book Appointment',
        'our_services' => 'Our Services',
        'we_offer_different_services_to_improve_your_health' => 'We Offer Different Services To Improve Your Health',
        'professional_doctors' => 'Professional Doctors',
        'we_are_experienced_healthcare_professionals' => 'We are Experienced Healthcare Professionals',
        'our_testimonials' => 'Our Testimonials',
        'what_our_patient_say_about_medical_treatments' => 'What Our Patients Say About Our Medical Treatments',
        'professional_details' => 'Professional Details'
    ],

    'web_password' => [
        'please_fill_all_the_required_fields' => 'Please fill all the required fields.',
        'password_and_confirm_password_not_match' => 'Password and Confirm password not match.',
    ],

    'web_contact' => [
        'call_today' => 'Call Today',
        'open_hours' => 'Open Hours',
        'our_location' => 'Our Location',
        'send_us_a_message' => 'Send Us a Message',
        'your_name' => 'Your Name',
        'your_email' => 'Your Email',
        'phone_number' => 'Phone Number',
        'select_enquiry' => 'Select Enquiry',
        'your_message' => 'Your Message',
        'send_message' => 'Send Message',
        'enter_your_name' => 'Enter your name',
        'enter_your_email' => 'Enter your email',
        'contact_no' => 'Contact No',
        'please_enter_your_phone_number' => 'Please enter your phone number',
        'write_your_message' => 'Write your message',
        'type_your_message' => 'Type your message',
    ],

    'web_menu' => [
        'about' => 'About',
        'our_features' => 'Our Features',
        'appointment' => 'Appointment',
        'working_hours' => 'Working Hours',
        'login' => 'Login',
        'useful_link' => 'Useful Link',
        'contact_information' => 'Contact Information',
        'copyright' => 'Copyright',
        'all_rights_reserved_by' => 'All Rights Reserved by',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'Make an Appointment',
        'call_now_and_get_a_free_consulting' => 'Call Now and Get a Free Consulting',
        'enter_your_first_name' => 'Enter your First Name',
        'enter_your_last_name' => 'Enter your Last Name',
        'enter_your_password' => 'Enter your Password',
        'enter_confirm_password' => 'Enter Confirm Password',
        'select_department' => 'Select Department',
        'select_doctor' => 'Select Doctor',
        'enter_description' => 'Enter Description',
        'select_time' => 'Select Date',
    ],

    'web_working_hours' => [
        'opening_hours' => 'Opening Hours',
        'no_yet_opening_hours' => 'No yet Opening Hours',
    ],
    'purchase_medicine' => [
        'purchase_number' => 'Purchase Number',
        'total' => 'Total',
        'discount' => 'Discount',
        'tax_amount' => 'Tax Amount',
        'net_amount' => 'Net Amount',
        'payment_mode' => 'Payment Mode',
        'payment_note' => 'Payment Note',
        'note' => 'Note',
        'purchase_medicine' => 'Purchase Medicine',
        'purchase_medicine_details' => 'Purchase Medicine Details',
        'purchase_medicine_overview' => 'Purchase Medicine Overview',
        'lot_no' => 'Lot no.',
        'tax' => 'Tax',
        'quantity' => 'Quantity',
        'amount' => 'Amount',
        'expiry_date' => 'Expiry Date',
        'other_details' => 'Other Details',
        'dose_duration' => 'Dose Duration',
        'medicine_purchased_successfully' => 'Medicine purchased successfully',
    ],
    'used_medicine' => [
        'used_medicine' => 'Used Medicine',
        'used_quantity' => 'Used Quantity',
        'used_at' => 'Used At',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Medicine Bills',
        'medicine_bill' => 'Medicine Bill',
        'add_medicine_bill' => 'Add Medicine Bill',
        'edit_medicine_bill' => 'Edit Medicine Bill',
        'medicine_bill_details' => 'Medicine Bill details',
        'dose_interval' => 'Dose Interval',
        'available_quantity' => 'The available quantity of',
        'is' => 'is',
        'prescription_not_found' => 'Prescription not found.',
        'medicine_not_selected' => 'Please select at least one medicine.',
        'duplicate_medicine' => 'Cannot add duplicate medicines.',
        'payment_status' => 'Payment Status',
        'sale_price' => 'Sale Price',
        'select_medicine' => 'Select Medicine',
        'update_quantity' => 'Update quantity should be less than previous quantity.',
        'net_amount_not_empty' => 'Net amount can not be empty.',
        'net_amount_not_zero' => 'Net amount can not be zero.',
        'medicine_required' => 'Medicine field is required.',
        'bill_number' => 'Bill Number',
        'tax_amount_not_zero_or_empty' => 'The tax amount can not be zero or empty.',
        'validate_discount' => 'The discount should be less than the total amount',
        'validate_tax' => 'Taxes should be less than 100%.',
        'quantity_cannot_be_zero' => 'Quantity cannot be zero or empty.',
        'lot_number' => 'Enter lot number',
        'sale_price' => 'Enter sale price',
        'purchase_price' => 'Enter purchase price',
        'validate_quantity' => 'Quantity should be greater than 0.',
        'quantity_required' => 'Please enter quantity.',
    ],

    // subscription plan
    'subscription_plans' => [
        'payment_type' => 'Choose Payment Type',
        'connect_with_zoom' => 'Connect With Zoom',
        'connected' => 'Connected',
        'select_ipd_patient' => 'Select IPD Patient',
    ],

    'holiday' => [
        'holiday' => 'Holiday',
        'add_holiday' => 'Add Holiday',
        'doctor_holiday' => 'Doctor Holidays',
        'service_category' => 'Service Category',
        'holiday_date' => 'Holiday Date',
        'reason' => 'Reason',
        'holiday_already_is_exist' => 'Holiday is already exist.',
        'doctor_holiday_create' => 'Doctor Holiday saved successfully.',
        'you_are_not_allow_to_record' => 'Seems, you are not allowed to access this record.',
        'appointment_exists' => 'Appointment exists You can\'t Take Holiday.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'Breaks',
        'lunch_break' => 'Break',
        'break_create' => 'Break saved successfully.',
        'break_update' => 'break updated successfully.',
        'add_break' => 'Add Break',
        'edit_break' => 'Edit Break',
        'break_already_is_exist' => 'Break is already exist.',
        'break_time_greater_than_zero' => 'Break From time must be greater than Zero',
        'break_to_time_greater_than_zero' => 'Break To time must be greater than Zero',
        'break_to_time_greater_than_from_time' => 'Break To time must be greater than Break From time.',
        'every_day' => 'Every Day',
        'single_day' => 'Single Day',
        'date_required' => 'Date field is Required.',
        'appointment_exists' => 'Appointment exists You Can\'t Take Break.',
    ],

    'new_change' => [
        'pathology_units' => 'Pathology Units',
        'pathology_unit' => 'Pathology Unit',
        'add_unit' => 'New Pathology Unit',
        'edit_unit' => 'Edit Pathology Unit',
        'pathology_unit_not_found' => 'Pathology Unit not found',
        'pathology_unit_cant_deleted' => 'Pathology Unit can\'t be deleted.',
        'pathology_parameter_not_found' => 'Pathology Parameter not found',
        'pathology_parameter_cant_deleted' => 'Pathology Parameter can\'t be deleted.',
        'pathology_parameter' => 'Pathology Parameter',
        'pathology_parameters' => 'Pathology Parameters',
        'add_parameter' => 'New Pathology Parameter',
        'edit_parameter' => 'Edit Pathology Parameter',
        'parameter_name_required' => 'Parameter Name field is required.',
        'patient_result_required' => 'Patient Result field is required.',
        'parameter_name' => 'Parameter Name',
        'patient_result' => 'Patient Result',
        'select_parameter_name' => 'Select Parameter Name',
        'reference_range' => 'Reference Range',
        'select_unit' => 'Select Unit',
        'print_pathology_test' => 'Print Pathology Test',
        'pathology_test_report' => 'Pathology Test Report',
    ],

    'patient_id_card' => [
        'id' => 'ID',
        'patient_id_card' => 'Patient Smart Cards',
        'new_patient_id_card_template' => 'New Patient Smart Card Template',
        'edit_patient_id_card_template' => 'Edit Patient Smart Card Template',
        'patient_id_card_template' => 'Smart Patient Card Templates',
        'color' => 'Color',
        'patient_unique_id' => 'Patient Unique ID',
        'new_patient_id_card' => 'New Patient Smart Card',
        'generate_patient_id_card' => 'Generate Patient Smart Cards',
        'template_id' => 'Template Name',
        'select_template' => 'Select Template',
        'select_type' => 'Type',
        'all_patient' => 'For All Patients',
        'one_patient' => 'Only One Patient',
        'remaining_patients' => 'Remaining Patients',
        'template_required' => 'Template field required',
        'patient_required' => 'Patient field is required',
    ],

    'register' => [
        'hello' => 'Hello!',
        'whoops' => 'Whoops!',
        'regards' => 'Regards,',
        'if_having_trouble_text' => "If you’re having trouble clicking the \":actionText\" button, copy and paste the URL below\n".
        'into your web browser: [:actionURL](:actionURL)',
    ],

    'custom_field' => [
        'custom_field' => 'Custom Field',
        'add_custom_field' => 'Add Custom Field',
        'edit_custom_field' => 'Edit Custom Field',
        'module_name' => 'Module Name',
        'field_type' => 'Field Type',
        'field_name' => 'Field Name',
        'grid' => 'Column Size',
        'value' => 'Value',
        'seperated_by_comma' => 'Seperated by Comma',
        'is_reqired' => 'Is Reqired',
        'input' => 'Input',
        'textarea' => 'Textarea',
        'checkbox' => 'Checkbox',
        'number' => 'Number',
        'dropdown' => 'Dropdown',
        'multi_select' => 'Multi select',
        'date' => 'Date',
        'date_time' => 'Date & time',
        'appointment' => 'Appointment',
        'ipd_patient' => 'IPD Patient',
        'opd_patient' => 'OPD Patient',
        'patient' => 'Patient',
        'value_must_be_greter_then' => 'Value must be greter then 1',
        'select_module' => 'Select Module',
        'select_field_type' => 'Select Field Type',
        'text' => 'Text',
        'toggle' => 'Toggle'
    ],

    'google_meet' => [
        'connect_calendar' => 'Connect Your Google Calendar',
        'disconnect_google_calendar' => 'Disconnect Your Google Calendar',
        'sync_google_calendar' => 'Sync Your Google Calendar',
        'validate_json_file' => 'Please set your google calendar credentials json file',
        'google_calendar_connect' => 'Google Calendar Connected Successfully',
        'google_calendar_add' => 'calendar added successfully',
        'google_calendar_update' => 'Google calender updated successfully.',
        'disconnect_or_reconnect' => 'Please disconnect and reconnect your google calendar',
        'google_calendar_disconnect' => 'Google calender disconnected',
        'select_google_calendar' => 'Select your calendars (from Google Calendar) in which you want to create the events',
        'platform_type' => 'Platform Type',
        'google_json_file' => 'Google Json File',
        'upload_json_file' => 'Please upload a JSON file.',
        'upload_file' => 'Please upload a file.',
        'invalid_json_format' => 'This format is not valid, valid format is JSON.',
        'json_file_saved_successfully' => 'Google Calendar Json File Saved Successfully',
    ],

    'footer' => [
        'all_rights_reserved' => 'All Rights Reserved',
    ],

    'open_ai' => [
        'provide_prompt' => 'Please Provide Physical Information for Prompt.',
        'open_ai_key_not_found' => 'OpenAI API key not found.',
        'repsonse_retrive_successfully' => 'Response retrieved successfully.',
        'open_ai_key' => 'Open AI Key',
        'suggest_medicines' => 'Suggest Medicines',
    ],

    'schedule_weekday' => [
        'Monday' => 'Monday',
        'Tuesday' => 'Tuesday',
        'Wednesday' => 'Wednesday',
        'Thursday' => 'Thursday',
        'Friday' => 'Friday',
        'Saturday' => 'Saturday',
        'Sunday' => 'Sunday',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'MON',
        'TUE' => 'TUE',
        'WED' => 'WED',
        'THU' => 'THU',
        'FRI' => 'FRI',
        'SAT' => 'SAT',
        'SUN' => 'SUN',
    ],
];
