<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - German Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin' => 'Admins',
    'admins' => 'Administratorin',
    'roles' => 'Rollen',
    'operations' => 'Operationen',
    'doctor_departments' => 'Arztabteilungen',
    'nurses' => 'Krankenschwestern',
    'doctors' => 'Ärztinnen',
    'patients' => 'Patientinnen',
    'lab_technicians' => 'Labortechniker',
    'receptionists' => 'Rezeptionistinnen',
    'pharmacists' => 'Apothekerinnen',
    'accountants' => 'Buchhalterinnen',
    'appointments' => 'Termine',
    'insurances' => 'Versicherungen',
    'investigation_reports' => 'Untersuchungsberichte',
    'death_reports' => 'Todesberichte',
    'birth_reports' => 'Geburtsberichte',
    'operation_reports' => 'Betriebsberichte',
    'medicine_categories' => 'Medizin Kategorien',
    'medicine_brands' => 'Medizinmarken',
    'medicines' => 'Medikamente',
    'cases' => 'Fälle',
    'case_handlers' => 'Fallbearbeiter',
    'bed_types' => 'Betttypen',
    'beds' => 'Betten',
    'bed_assigns' => 'Bett weist zu',
    'packages' => 'Pakete',
    'schedules' => 'Zeitpläne',
    'schedule_label' => 'Zeitplan',
    'services' => 'Dienstleistungen',
    'accounts' => 'Konten',
    'payments' => 'Zahlungen',
    'bills' => 'Rechnungen',
    'employee_payrolls' => 'Mitarbeiterabrechnungen',
    'documents' => 'Unterlagen',
    'document_types' => 'Dokumenttypen',
    'notice_boards' => 'Notiz Bretter',
    'settings' => 'die Einstellungen',
    'doctors_list' => 'Ärzte-Liste',
    'my_payrolls' => 'Meine Gehaltsabrechnungen',
    'blood_banks' => 'Blutbanken',
    'blood_donors' => 'Blutspender',
    'invoices' => 'Rechnungen',
    'patients_cases' => 'Patientenfälle',
    'patients_case_details' => 'Details zum Patientenfall',
    'account_manager' => 'Buchhalter',
    'bed_management' => 'Bettenverwaltung',
    'blood_bank' => 'Blutbank',
    'billing' => 'Abrechnung',
    'case_manager' => 'Fallmanager',
    'cms' => 'CMS',
    'department' => 'Abteilung',
    'departments' => 'Abteilungen',
    'hospital_activities' => 'Krankenhausaktivitäten',
    'advanced_payments' => 'Vorauszahlungen',
    'patient_admissions' => 'Patientenaufnahmen',
    'appointment_calendar' => 'Ernennen. Kalender',
    'bed_mgt' => 'Bettmanagement',
    'reports' => 'Berichte',
    'mail' => 'Mail',
    'enquiries' => 'Anfragen',
    'ambulances' => 'Ambulanzen',
    'ambulance_calls' => 'Krankenwagenanrufe',
    'prescriptions' => 'Rezepte',
    'hospital_charges' => 'Krankenhauskosten',
    'charge_categories' => 'Gebührenkategorien',
    'charges' => 'Gebühren',
    'radiologies' => 'Radiologie',
    'radiology_categories' => 'Radiologie Kategorie',
    'pathologies' => 'Pathologie',
    'pathology_categories' => 'Pathologie-Kategorie',
    'radiology_tests' => 'Radiologische Tests',
    'doctor_opd_charges' => 'Arzt OPD Gebühren',
    'pathology_tests' => 'Pathologie Tests',
    'expenses' => 'Kosten',
    'income' => 'Einkommen',
    'finance' => 'Finanzen',
    'inventory' => 'Inventar',
    'items_categories' => 'Artikel Kategorien',
    'items' => 'Artikel',
    'items_stocks' => 'Artikel Bestände',
    'issued_items' => 'Ausgestellte Artikel',
    'ipd_patients' => 'IPD-Patienten',
    'ipd_opd' => 'IPD/OPD',
    'ipd_diagnosis' => 'Diagnose',
    'ipd_consultant_register' => 'Anleitung des Beraters',
    'ipd_consultant_doctor' => 'Beratender Arzt',
    'ipd_charges' => 'Gebühren',
    'ipd_prescription' => 'Rezepte',
    'ipd_timelines' => 'Zeitleisten',
    'ipd_payment' => 'IPD-Zahlung',
    'opd_patients' => 'OPD-Patienten',
    'opd_diagnosis' => 'OPD-Diagnose',
    'opd_timeline' => 'OPD-Zeitleiste',
    'call_logs' => 'Anruflisten',
    'visitors' => 'Besucherinnen',
    'front_office' => 'Postversand',
    'postal_receive' => 'Postempfang',
    'postal_dispatch' => 'Postversand',
    'general' => 'Allgemeines',
    'sidebar_setting' => 'Moduleinstellungen',
    'currency_setting' => 'Währungen',
    'testimonials' => 'Referenzen',
    'blood_donations' => 'Blutspenden',
    'blood_issues' => 'Blutprobleme',
    'live_consultations' => 'Live-Konsultationen',
    'vaccinations' => 'Impfungen',
    'vaccinated_patients' => 'Geimpfte Patienten',
    'users' => 'Benutzer',
    'front_settings' => 'Fronteinstellungen',
    'front_service' => 'Frontdienst',
    'about_us' => 'Über uns',
    'make_an_appointment' => 'Termin vereinbaren',
    'patient_appointment' => 'Patiententermin',
    'old_patient' => 'Alter Patient',
    'new_patient' => 'Neuer Patient',
    'available_slot' => 'Verfügbarer Slot',
    'contact_us' => 'Kontaktieren Sie uns',
    'live_meetings' => 'Live-Meetings',
    'live_meeting' => 'Live-Meeting',
    'hospital_schedule' => 'Krankenhausplan',
    'front_cms' => 'Front cms',
    'front_cms_services' => 'Front-CMS-Dienste',
    'facebook_url' => 'Facebook URL',
    'twitter_url' => 'Twitter-URL',
    'instagram_url' => 'Instagram-URL',
    'linkedIn_url' => 'linkedIn-URL',
    'allow_file_type' => 'Erlaubte Dateitypen: png, jpg, jpeg.',
    'overview' => 'Überblick',
    'no_data_available' => 'Keine Daten in der Tabelle verfügbar',
    'file_name' => 'Dateiname',
    'icon' => 'Symbol',
    'short_description' => 'kurze Beschreibung',
    'valid' => 'Gültig',
    'no_matching_records_found' => 'Keine übereinstimmenden Aufzeichnungen gefunden',
    'select_applied_date' => 'Bitte wählen Sie das Bewerbungsdatum aus',
    'select_instruction_date' => 'Bitte wählen Sie das Unterrichtsdatum aus',
    'report' => 'Bericht',
    'report_id' => 'Berichts-ID',
    'yearly_income_expense_chart' => 'Jährliches Einnahmen-Ausgaben-Diagramm',
    'sms_mail' => 'SMS/Mail',
    'payment_gateways' => 'Zahlungsgateways',
    'stripe_key' => 'Stripe-Schlüssel',
    'stripe_secret' => 'Stripe-Geheimnis',
    'paypal' => 'PayPal',
    'paypal_client_id' => 'PayPal-Kunden-ID',
    'paypal_secret' => 'PayPal-Geheimnis',
    'paypal_mode' => 'PayPal-Modus',
    'razorpay' => 'Razorpay',
    'razorpay_key' => 'Razorpay-Schlüssel',
    'razorpay_secret' => 'Razorpay-Geheimnis',
    'cash' => 'Kasse',
    'cheque' => 'Überprüfen',
    'flutterwave' => 'Flatterwelle',
    'flutterwave_public_key' => 'Öffentlicher Flutterwave-Schlüssel',
    'flutterwave_secret_key' => 'Geheimer Flutterwave-Schlüssel',
    'phonepe' => 'Telefon Pe',
    'paystack' => 'Gehaltsstapel',
    'paystack_public_key' => 'Öffentlicher Paystack-Schlüssel',
    'paystack_secret_key' => 'Geheimer Paystack-Schlüssel',
    'phonepe_merchant_id' => 'Phonepe-Händler-ID',
    'phonepe_merchant_user_id' => 'Phonepe-Händler-Benutzer-ID',
    'phonepe_env' => 'Phonepe Env',
    'phonepe_salt_key' => 'Phonepe-Salzschlüssel',
    'phonepe_salt_index' => 'Phonepe-Salz-Index',
    'phonepe_merchant_transaction_id' => 'Phonepe-Händler-Transaktions-ID',

    'language' => [
        'Arabic' => 'Arabisch',
        'Chinese' => 'Chinesisch',
        'English' => 'Englisch',
        'French' => 'Französisch',
        'German' => 'Deutsch',
        'Portuguese' => 'Portugiesisch',
        'Russian' => 'Russisch',
        'Spanish' => 'Spanisch',
        'Turkish' => 'Türkisch',
    ],

    //roles
    'role' => [
        'new_role' => 'Neue Rolle',
        'edit_role' => 'Rolle bearbeiten',
        'select_role' => 'Wählen Sie Rolle aus',
    ],

    //user keys
    'user' => [
        'user' => 'Benutzer',
        'user_list' => 'Benutzerliste',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'name' => 'Name',
        'email' => 'Email',
        'phone' => 'Telefon',
        'designation' => 'Bezeichnung',
        'gender' => 'Geschlecht',
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'qualification' => 'Qualifikation',
        'dob' => 'Geburtsdatum',
        'blood_group' => 'Blutgruppe',
        'select_blood_group' => 'Wählen Sie Blutgruppe',
        'password' => 'Passwort',
        'password_confirmation' => 'Kennwort bestätigen',
        'address1' => 'Adresse 1',
        'address2' => 'Adresse 2',
        'city' => 'Stadt',
        'zip' => 'Postleitzahl',
        'address_details' => 'Adressen Details',
        'address_not_found' => 'Keine Adressdaten gefunden',
        'education' => 'Bildung',
        'status' => 'Status',
        'edit_profile' => 'Profil bearbeiten',
        'change_password' => 'Passwort ändern',
        'logout' => 'Ausloggen',
        'new_user' => 'Neuer Benutzer',
        'edit_user' => 'Benutzer bearbeiten',
        'user_details' => 'Nutzerdetails',
        'email_verified_successfully' => 'E-Mail erfolgreich verifiziert.',
        'invalid_password' => 'Aktuelles Passwort ist ungültig.',
        'validate_confirm_password' => 'Das Passwort und das Bestätigungspasswort müssen übereinstimmen.',
        'validate_min_character_password' => 'Das Passwort muss mindestens 6 Zeichen enthalten.',
        'validate_image_type' => 'Das Bild muss eine Datei vom Typ: jpg, jpeg oder png sein.',
        'validate_image_size' => 'Das Dokument muss kleiner als 10 MB sein.',
        'validate_facebook_url' => 'Bitte geben Sie eine gültige Facebook-URL ein.',
        'validate_twitter_url' => 'Bitte geben Sie eine gültige Twitter-URL ein.',
        'validate_instagram_url' => 'Bitte geben Sie eine gültige Instagram-URL ein.',
        'validate_linkedin_url' => 'Bitte geben Sie eine gültige LinkedIn-URL ein.',
        'phone_number_must_be_10_digits' => 'Die Telefonnummer muss 10 Ziffern lang sein',
        'valid_email' => 'Bitte eine gültige Email eingeben',
    ],

    //common keys
    'common' => [
        'field_required' => 'Feld ist erforderlich.',
        'change' => 'Ändern',
        'change_profile' => 'Bild ändern',
        'is' => 'Ist',
        'available_quantity_of' => 'Die verfügbare Menge von',
        'result' => 'Ergebnis',
        'profile' => 'Profil',
        'status' => 'Status',
        'action' => 'Aktion',
        'save' => 'speichern',
        'cancel' => 'Stornieren',
        'canceled' => 'Stornierened',
        'back' => 'Zurück',
        'created_on' => 'Erstellt am',
        'last_updated' => 'Zuletzt aktualisiert',
        'n/a' => 'N / A',
        'new' => 'Neu',
        'total' => 'Gesamt',
        'add' => 'Hinzufügen',
        'active' => 'Aktiv',
        'name' => 'Name',
        'edit' => 'Bearbeiten',
        'detail' => 'Einzelheiten',
        'delete' => 'Löschen',
        'view' => 'Aussicht',
        'view_attachment' => 'Anhang ansehen',
        'de_active' => 'Deaktivieren',
        'description' => 'Beschreibung',
        'created_at' => 'Erstellt am',
        'updated_at' => 'Zuletzt aktualisiert',
        'is_available' => 'Ist verfügbar',
        'choose' => 'Wählen',
        'yes' => 'Ja',
        'no' => 'Nein',
        'address' => 'Adresse',
        'export_to_excel' => 'Nach Excel exportieren',
        'reset' => 'Zurücksetzen',
        'actions' => 'Aktionen',
        'confirm' => 'Bestätigen Sie',
        'search' => 'Suche',
        'status_updated_successfully' => 'Status erfolgreich aktualisiert.',
        'saved_successfully' => 'Erfolgreich gespeichert.',
        'updated_successfully' => 'Erfolgreich geupdated',
        'deleted_successfully' => 'Erfolgreich gelöscht',
        'filter_options' => 'Filteroptionen',
        'are_you_sure_want_to_delete_this' => 'Möchten Sie dies wirklich löschen? ',
        'deleted' => 'Gelöscht',
        'has_been_deleted' => 'wurde gelöscht.',
        'cant_be_deleted' => 'kann nicht gelöscht werden',
        'custom' => 'Brauch',
        'apply' => 'anwenden',
        'from' => 'aus',
        'to' => 'Zu',
        'invalid_number' => 'Ungültige Nummer',
        'invalid_country_code' => 'Ungültiger Ländercode',
        'too_short' => 'Zu kurz',
        'too_long' => 'Zu lang',
        'not_found' => 'nicht gefunden',
        'previous' => 'Vorherige',
        'next' => 'Nächste',
        'ok' => 'OK',
        'this_action_is_not_allowed_for_default_record' => 'Diese Aktion ist für den Standarddatensatz nicht zulässig.',
        'show' => 'Zeigen',
        'something_wen_wrong' => 'Etwas ist schiefgelaufen',
        'cancelled_successfully' => 'Erfolgreich abgebrochen',
        'invalid_username_password' => 'Ungültiger Benutzername oder Passwort',
        'logged_in_successfully' => 'Erfolgreich angemeldet',
        'logout_successfully' => 'Erfolgreich abgemeldet',
        'we_cant_find_user' => 'Wir konnten keinen Benutzer mit dieser E-Mail-Adresse finden',
        'we_have_your_password_resetk_link' => 'Wir haben Ihnen den Link zum Zurücksetzen Ihres Passworts per E-Mail gesendet!',
        'this_password_reset_token_is_invalid' => 'Dieser Link zum Zurücksetzen des Passworts ist ungültig',
        'password_reset_successfully' => 'Passwort erfolgreich zurückgesetzt',
        'please_enter_correct_old_password' => 'Bitte geben Sie das korrekte alte Passwort ein',
        'password_updated' => 'Passwort aktualisiert',
        'doctor_scheduled' => 'Arzttermin vereinbart',
        'not_updated' => 'Nicht aktualisiert',
        'patient_registered_successfully' => 'Patient erfolgreich registriert',
        'appointment_confirmed_successfully' => 'Termin erfolgreich bestätigt',
        'bed_assigned_successfully' => 'Bett erfolgreich zugewiesen',
        'username_and_password_required' => 'Benutzername und Passwort erforderlich',
        'meeting_finished_or_cancelled' => 'Dieses Treffen wurde beendet oder abgesagt',
        'alreay_exists' => 'Existiert bereits.',
        'appointment_transaction' => 'Termintransaktion'
    ],

    'hospital_schedules' => [
        'exists_doctor_schedule' => 'Einige Ärzte haben ihre Tage in bestimmten ungeprüften Tagen geplant, also sind Sie sicher, dass Sie diese Operation durchführen möchten?',
        'schedule_not_available' => 'Aktuell kann der Benutzer keinen Krankenhausplan erstellen, wenn der Krankenhausplan nicht verfügbar ist.',
        'this_day_hospital_is_closed' => 'An diesem Tag ist das Krankenhaus geschlossen.',
    ],

    'months' => [
        'jan' => 'Januar',
        'feb' => 'Februar',
        'mar' => 'Marsch',
        'apr' => 'April',
        'may' => 'Kann',
        'jun' => 'Juni',
        'july' => 'Juli',
        'aug' => 'August',
        'sep' => 'September',
        'oct' => 'Oktober',
        'nov' => 'November',
        'dec' => 'Dezember',
    ],

    'weekdays' => [
        'sun' => 'SONNE',
        'mon' => 'MO',
        'tue' => 'DI',
        'wed' => 'HEIRATEN',
        'thu' => 'DO',
        'fri' => 'FR',
        'sat' => 'SA',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'Rezeptionistin',
        'receptionists' => 'Rezeptionistinnen',
        'receptionist_details' => 'Details zur Rezeption',
        'new_receptionist' => 'Neue Rezeptionistin',
        'edit_receptionist' => 'Empfangsdame bearbeiten',
        'profile_must_be_image' => 'Das Profilbild muss ein Bild sein',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'Versicherung',
        'insurances' => 'Versicherungen',
        'insurance_details' => 'Versicherungsdetails',
        'new_insurance' => 'Neue Versicherung',
        'edit_insurance' => 'Versicherung bearbeiten',
        'service_tax' => 'Servicesteuer',
        'insurance_no' => 'Versicherung Nr',
        'insurance_code' => 'Versicherungscode',
        'hospital_rate' => 'Krankenhauspreis',
        'discount' => 'Rabatt',
        'remark' => 'Anmerkung',
        'disease_details' => 'Krankheitsdetails',
        'diseases_name' => 'Name der Krankheit',
        'diseases_charge' => 'Krankheitsgebühr',
        'total_amount' => 'Gesamtmenge',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'Arztabteilungen',
        'doctor_department' => 'Arztabteilung',
        'doctor_department_details' => 'Details der Arztabteilung',
        'new_doctor_department' => 'Neue Arztabteilung',
        'edit_doctor_department' => 'Arztabteilung bearbeiten',
        'title' => 'Titel',
        'description' => 'Beschreibung',
        'doctor_field_required' => 'Das Feld „Arzt“ ist erforderlich'
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'Untersuchungsberichte',
        'investigation_report' => 'Untersuchungsbericht',
        'new_investigation_report' => 'Neuer Untersuchungsbericht',
        'investigation_report_details' => 'Untersuchungsbericht Details',
        'edit_investigation_report' => 'Untersuchungsbericht bearbeiten',
        'patient' => 'Geduldig',
        'date' => 'Datum',
        'title' => 'Titel',
        'doctor' => 'Ärztin',
        'description' => 'Beschreibung',
        'attachment' => 'Anhang',
        'birth_date_validation' => 'Das Datum des Untersuchungsberichts sollte nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'Neuer Apotheker',
        'edit_pharmacist' => 'Apotheker bearbeiten',
        'pharmacists' => 'Apothekerinnen',
        'pharmacist_details' => 'Apotheker Details',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'Todesbericht',
        'death_reports' => 'Todesberichte',
        'new_death_report' => 'Neuer Todesbericht',
        'edit_death_report' => 'Todesbericht bearbeiten',
        'death_report_details' => 'Details zum Todesbericht',
        'patient_name' => 'Patientenname',
        'case_id' => 'Fall-ID',
        'doctor_name' => 'Name des Arztes',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'cant_create_report_because_the_patient_has_been_dead' => 'Bericht kann nicht erstellt werden, da der Patient verstorben ist.',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Das Datum darf nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'Geburtsbericht',
        'birth_reports' => 'Geburtsberichte',
        'birth_report_details' => 'Geburtsbericht Details',
        'new_birth_report' => 'Neuer Geburtsbericht',
        'edit_birth_report' => 'Geburtsbericht bearbeiten',
        'patient_name' => 'Patientenname',
        'case_id' => 'Fall-ID',
        'doctor_name' => 'Name des Arztes',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Das Datum sollte nicht kleiner als das Geburtsdatum des Patienten sein.',
        'patient_birth_date_not_found' => 'Geburtsdatum des Patienten nicht gefunden.',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'Neuer Buchhalter',
        'edit_accountant' => 'Buchhalter bearbeiten',
        'accountants' => 'Buchhalterinnen',
        'accountant_details' => 'Buchhalter Details',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'Mitarbeiterabrechnung',
        'employee_payrolls' => 'Mitarbeiterabrechnungen',
        'employee_payroll_details' => 'Angaben zur Mitarbeiterabrechnung',
        'new_employee_payroll' => 'Neue Mitarbeiterabrechnung',
        'edit_employee_payroll' => 'Mitarbeiterabrechnung bearbeiten',
        'sr_no' => 'Sr. Nr',
        'payroll_id' => 'Gehaltsabrechnungs-ID',
        'month' => 'Monat',
        'year' => 'Jahr',
        'role' => 'Rolle',
        'employee' => 'Mitarbeiterin',
        'basic_salary' => 'Grundgehalt',
        'allowance' => 'Beihilfe',
        'deductions' => 'Abzüge',
        'net_salary' => 'Nettogehalt',
        'paid' => 'Bezahlt',
        'not_paid' => 'Unbezahlt',
        'employee_name' => 'Mitarbeitername',
        'employees_list_not_found' => 'Mitarbeiterliste nicht gefunden',
        'employee_payroll_deduction' => 'Abzüge dürfen nicht größer sein als Grundgehalt + Zulage',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'Betriebsbericht',
        'operation_reports' => 'Betriebsberichte',
        'operation_report_details' => 'Details zum Betriebsbericht',
        'new_operation_report' => 'Neuer Betriebsbericht',
        'edit_operation_report' => 'Betriebsbericht bearbeiten',
        'patient_name' => 'Patientenname',
        'case_id' => 'Fall-ID',
        'doctor_name' => 'Name des Arztes',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'data_should_not_be_smaller_than_patient_birth_date' => 'Das Datum darf nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    // accounts keys
    'account' => [
        'account' => 'Konto',
        'accounts' => 'Konten',
        'account_details' => 'Kontodetails',
        'new_account' => 'Neues Konto',
        'edit_account' => 'Konto bearbeiten',
        'name' => 'Name',
        'description' => 'Beschreibung',
        'type' => 'Art',
        'status' => 'Status',
        'payments' => 'Zahlungen',
        'credit' => 'Anerkennung',
        'debit' => 'Lastschrift',
    ],

    // invoices keys
    'invoice' => [
        'invoice_id' => 'Rechnungs-ID',
        'invoice' => 'Rechnung',
        'invoices' => 'Rechnungen',
        'invoice_details' => 'Rechnungs-Details',
        'new_invoice' => 'Neue Rechnung',
        'edit_invoice' => 'Rechnung bearbeiten',
        'patient' => 'Geduldig',
        'invoice_date' => 'Rechnungsdatum',
        'amount' => 'Menge',
        'patient_id' => 'Patienten ID',
        'discount' => 'Rabatt',
        'account_name' => 'Kontobezeichnung',
        'description' => 'Beschreibung',
        'qty' => 'Menge',
        'price' => 'Preis',
        'add' => 'Hinzufügen',
        'sub_total' => 'Zwischensumme',
        'total' => 'Gesamtmenge',
        'edit' => 'Bearbeiten',
        'hospital_address' => 'Krankenhausadresse',
        'paid' => 'Bezahlt',
        'not_paid' => 'Nicht bezahlt',
        'print_invoice' => 'Rechnung drucken',
        'invoice_date_field_required' => 'Das Feld Rechnungsdatum ist erforderlich',
        'issue_for' => 'Problem für',
        'issue_from' => 'Ausgabe von',
        'patient_overview' => 'PATIENTENÜBERSICHT',
        'in_percentage' => 'In Prozent',
    ],

    //nurses
    'nurse' => [
        'nurse' => 'Krankenschwester',
        'new_nurse' => 'Neue Krankenschwester',
        'edit_nurse' => 'Krankenschwester bearbeiten',
        'nurse_details' => 'Krankenschwester Details',
        'phone_no' => 'Telefonnummer',
        'birth_date' => 'Geburtsdatum',
        'choose' => 'Wählen',
    ],

    //patient
    'patient' => [
        'new_patient' => 'Neuer Patient',
        'edit_patient' => 'Patient bearbeiten',
        'patient_details' => 'Patientendetails',
        'total_cases' => 'Fälle insgesamt',
        'total_admissions' => 'Gesamtzulassungen',
        'total_appointments' => 'Termine insgesamt',
        'select_one_patient' => 'Bitte wählen Sie mindestens einen Patienten aus',
        'patient_name_already_taken' => 'Der Patientenname ist bereits vergeben',
        'patient_field_required' => 'Das Patientenfeld ist erforderlich',
    ],

    // payments keys
    'payment' => [
        'payment' => 'Zahlung',
        'payments' => 'Zahlungen',
        'payment_details' => 'Zahlungsdetails',
        'new_payment' => 'Neue Zahlung',
        'edit_payment' => 'Zahlung bearbeiten',
        'account_name' => 'Kontobezeichnung',
        'payment_date' => 'Zahlungsdatum',
        'pay_to' => 'Zahlen an',
        'amount' => 'Menge',
        'account' => 'Konto',
        'description' => 'Beschreibung',
        'payment_reports' => 'Zahlungsberichte',
        'your_payment_is_successfully_completed' => 'Ihre Zahlung wurde erfolgreich abgeschlossen',
        'payment_failed' => 'Entschuldigung! Die Zahlung ist fehlgeschlagen. Bitte versuchen Sie es später erneut',
        'flutterwave_not_support' => 'Flutterwave unterstützt diese Währung nicht.',
        'phonepe_support_inr' => 'PhonePe unterstützt nur die Währung INR.',
        'paystack_support_zar' => 'Paystack unterstützte nur die Währung "USD","GHS","NGN","ZAR","KES".',
        'paystack_token_expired' => 'Der Paystack-Token ist abgelaufen. Bitte aktualisieren Sie die Seite und versuchen Sie es erneut.',
        'currency_not_supported_paypal' => 'Diese Währung wird von PayPal für Zahlungen nicht unterstützt.',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'Vorauszahlung',
        'advanced_payments' => 'Vorauszahlungen',
        'advanced_payment_details' => 'Vorauszahlungsdetails',
        'new_advanced_payment' => 'Neue Vorauszahlung',
        'edit_advanced_payment' => 'Vorauszahlung bearbeiten',
        'patient' => 'Geduldig',
        'receipt_no' => 'Quittungsnr',
        'amount' => 'Menge',
        'date' => 'Datum',
        'patient_name' => 'Patientenname',
    ],

    // beds keys
    'bed' => [
        'bed' => 'Neues Bett',
        'beds' => 'Betten',
        'bed_details' => 'Bettdetails',
        'new_bed' => 'Neues Bett',
        'edit_bed' => 'Bett bearbeiten',
        'new_bulk_bed' => 'Neues Großbett',
        'name' => 'Name',
        'bed_type' => 'Betttyp',
        'charge' => 'Aufladen',
        'available' => 'Verfügbar',
        'not_available' => 'Nicht verfügbar',
        'description' => 'Beschreibung',
        'add' => 'Hinzufügen',
        'bed_id' => 'Bett Id',
        'select_bed_type' => 'Wählen Sie den Betttyp aus',
        'bed_charge' => 'Bettgebühr',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'Betttyp',
        'bed_types' => 'Betttypen',
        'bed_type_details' => 'Betttyp Details',
        'new_bed_type' => 'Neuer Betttyp',
        'edit_bed_type' => 'Betttyp bearbeiten',
        'title' => 'Titel',
        'description' => 'Beschreibung',
    ],

    'doctor' => [
        'new_doctor' => 'Neuer Doktor',
        'edit_doctor' => 'Doktor bearbeiten',
        'doctor_details' => 'Arzt Details',
        'specialist' => 'Spezialistin',
        'doctor_name_already_taken' => 'Der Name des Arztes ist bereits vergeben',
        'appointment_charge' => 'Termingebühr',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'Bett zuweisen',
        'bed_assigns' => 'Bett weist zu',
        'bed_assign_details' => 'Bed Assign Details',
        'new_bed_assign' => 'Neues Bett zuweisen',
        'edit_bed_assign' => 'Bett zuweisen zuweisen',
        'patient_name' => 'Patientenname',
        'bed_name' => 'Bettname',
        'case_id' => 'Fall-ID',
        'assign_date' => 'Datum zuweisen',
        'discharge_date' => 'Entlassungsdatum',
        'bed' => 'Bett',
        'description' => 'Beschreibung',
        'assigned' => 'Zugewiesen',
        'not_assigned' => 'Nicht zugeordnet',
        'ipd_patient_id' => 'IPD-Patienten-ID',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'Das Zuweisungsdatum sollte nicht kleiner als das Geburtsdatum des Patienten sein.',
        'ipd_patient_department_field_required' => 'Das Feld IPD-Patientenabteilung ist erforderlich',
    ],

    // packages keys
    'package' => [
        'package' => 'Paket',
        'packages' => 'Pakete',
        'package_details' => 'Paketdetails',
        'new_package' => 'Neues Paket',
        'edit_package' => 'Paket bearbeiten',
        'name' => 'Name',
        'description' => 'Beschreibung',
        'discount' => 'Rabatt',
        'total_amount' => 'Gesamtmenge',
        'service' => 'Bedienung',
        'qty' => 'Menge',
        'rate' => 'Bewertung',
        'amount' => 'Menge',
        'select_service' => 'Wählen Sie Service',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'Rechnung drucken',
        'bill_id' => 'Regnings id',
        'bill' => 'Rechnung',
        'bills' => 'Rechnungen',
        'bill_details' => 'Rechnungsdetails',
        'new_bill' => 'Neue Rechnung',
        'edit_bill' => 'Rechnung bearbeiten',
        'patient' => 'Geduldig',
        'bill_date' => 'Rechnungsdatum',
        'amount' => 'Menge',
        'admission_id' => 'Zulassungsausweis',
        'patient_name' => 'Patientenname',
        'patient_email' => 'Patienten-E-Mail',
        'patient_cell_no' => 'Patientenzelle Nr',
        'patient_gender' => 'Geschlecht des Patienten',
        'patient_dob' => 'Patienten DOB',
        'doctor_name' => 'Name des Arztes',
        'admission_date' => 'Aufnahmedatum',
        'discharge_date' => 'Entlassungsdatum',
        'package_name' => 'Paketnamen',
        'insurance_name' => 'Versicherungsname',
        'total_days' => 'Die Summe an Tagen',
        'policy_no' => 'Richtlinie Nr',
        'item_name' => 'Artikelname',
        'qty' => 'Menge',
        'price' => 'Preis',
        'add' => 'Hinzufügen',
        'total_amount' => 'Gesamtmenge',
        'edit' => 'Bearbeiten',
        'cell_no' => 'Zelle Nr',
        'bill_summary' => 'Rechnungszusammenfassung',
        'generate_bill' => 'Rechnung erstellen',
        'update_bill' => 'Rechnung aktualisieren',
        'calculate' => 'Berechnung',
        'manual_bill' => 'Manuelle Rechnungszahlungen',
        'transaction_date' => 'Transaktionsdatum',
        'paymentrequest_sent' => 'Zahlungsanforderung erfolgreich gesendet',
        'manually' => 'Manuell',
        'stripe' => 'Streifen',
        'approved' => 'Genehmigt',
        'rejected' => 'Abgelehnt',
        'are_you_sure' => 'Bist du sicher?',
        'complete_this_payment' => 'Sie möchten diese Zahlung manuell abschließen!!',
        'session_id_required' => 'Sitzungs-ID erforderlich',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'Blutspender',
        'blood_donors' => 'Blutspender',
        'blood_donor_details' => 'Blutspender Details',
        'new_blood_donor' => 'Neuer Blutspender',
        'edit_blood_donor' => 'Blutspender bearbeiten',
        'name' => 'Name',
        'age' => 'Alter',
        'gender' => 'Geschlecht',
        'blood_group' => 'Blutgruppe',
        'donation_date' => 'Spendendatum',
        'last_donation_date' => 'Letztes Spendendatum',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'Blutbank',
        'blood_banks' => 'Blutbanken',
        'blood_bank_details' => 'Details zur Blutbank',
        'new_blood_group' => 'Neue Blutgruppe',
        'edit_blood_group' => 'Blutgruppe bearbeiten',
        'blood_group' => 'Blutgruppe',
        'remained_bags' => 'Verbleibende Taschen',
    ],

    //Case
    'case' => [
        'case' => 'Fall',
        'case_date' => 'Falldatum',
        'new_case' => 'Neuer Fall',
        'edit_case' => 'Fall bearbeiten',
        'case_details' => 'Falldetails',
        'phone' => 'Telefon',
        'fee' => 'Gebühr',
        'patient' => 'Geduldig',
        'doctor' => 'Ärztin',
        'case_id' => 'Fall-ID',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'case_date_should_not_be_smaller_than_patient_birth_date' => 'Das Fall-Datum sollte nicht kleiner sein als das Geburtsdatum des Patienten',
    ],

    //services
    'service' => [
        'service' => 'Dienstleistung',
        'new_service' => 'Neuer Service',
        'edit_service' => 'Service bearbeiten',
        'service_details' => 'Servicedetails',
        'quantity' => 'Menge',
        'rate' => 'Bewertung',
        'given' => 'Gegeben',
        'not_given' => 'Nicht angegeben',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'Neuer Termin',
        'edit_appointment' => 'Termin bearbeiten',
        'appointment_details' => 'Termindetails',
        'calendar_view' => 'Kalenderansicht',
        'patient_name' => 'Patientenname',
        'doctor_name' => 'Name des Arztes',
        'department_name' => 'Abteilungsname',
        'date' => 'Datum',
        'doctor_department' => 'Arztabteilung',
        'doctor_department_name' => 'Name der Arztabteilung',
        'doctor' => 'Ärztin',
        'description' => 'Beschreibung',
        'patient' => 'Geduldig',
        'appointment_calendar' => 'Terminkalender',
        'appointment_list' => 'Terminliste',
        'completed' => 'Abgeschlossen',
        'pending' => 'steht aus',
        'available_slot' => 'Verfügbarer Slot',
        'no_available' => 'Nicht verfügbar',
        'today' => 'Heute',
        'month' => 'Monat',
        'week' => 'Woche',
        'day' => 'Tag',
        'opd_date' => 'Opd-Datum',
        'yesterday' => 'Gestern',
        'this_week' => 'In dieser Woche',
        'last_7_days' => 'Letzten 7 Tage',
        'last_30_days' => 'Letzte 30 Tage',
        'this_month' => 'Diesen Monat',
        'last_month' => 'Im vergangenen Monat',
        'change_status' => 'Status ändern',
        'are_you_sure_want_to_change' => 'Möchten Sie wirklich wechseln?',
        'changed_appointment' => 'Termin geändert',
        'has_been_changed' => 'wurde geändert.',
        'are_you_sure_want_to_cancel' => 'Sind Sie sicher, dass sie abbrechen wollen',
        'has_been_cancelled' => 'wurde abgebrochen.',
        'please_select_doctor_department' => 'Bitte wählen Sie die Arztabteilung aus',
        'please_select_doctor' => 'Bitte Arzt auswählen',
        'doctor_schedule_not_available_on_this_date' => 'Arztplan an diesem Datum nicht verfügbar.',
        'please_select_appointment_time_slot' => 'Bitte wählen Sie das Zeitfenster für den Termin aus',
        'patient_not_exists_or_status_is_not_active' => 'Patient not exists or status is not active.',
        'appointment_exists' => 'Patienten-E-Mail existiert bereits',
        'old_patient_email_exists' => 'E-Mail existiert bereits, bitte alten Patienten auswählen.',
        'time' => 'Zeit',
    ],

    'case_handler' => [
        'case_handler' => 'Fallbearbeiter',
        'new_case_handler' => 'Neuer Case Handler',
        'edit_case_handler' => 'Fallbearbeiter bearbeiten',
        'case_handler_detail' => 'Details zur Fallbearbeitung',
    ],

    'lab_tech' => [
        'lab_technician' => 'Labortechniker',
        'new_lab_tech' => 'Neuer Labortechniker',
        'edit_lab_tech' => 'Labortechniker bearbeiten',
        'lab_tech_detail' => 'Details zum Labortechniker',
    ],

    'doc_type' => [
        'new_doc_type' => 'Neuer Dokumenttyp',
        'edit_doc_type' => 'Dokumenttyp bearbeiten',
        'name' => 'Name',
    ],

    'document' => [
        'document' => 'Dokumentieren',
        'new_document' => 'Neues Dokument',
        'edit_document' => 'Dokument bearbeiten',
        'title' => 'Titel',
        'document_type' => 'Dokumentenart',
        'document_type_details' => 'Dokumenttypdetails',
        'patient' => 'Geduldig',
        'download' => 'Herunterladen',
        'select_patient' => 'Wählen Sie Patient',
        'select_document_type' => 'Wählen Sie Dokumenttyp',
        'document_detail' => 'Dokumentdetails',
        'notes' => 'Anmerkungen',
        'attachment' => 'Anhang',
        'uploaded_by' => 'Hochgeladen von',
        'document_detail' => 'Dokumentendetails',
        'notes' => 'Notizen',
        'view' => 'Ansehen',
        'attachment' => 'Anhang',
        'validate_doc_type' => 'Das Dokument muss eine Datei vom Typ: jpeg, jpg, png, pdf, doc, docx, webp sein',
        'select_attachment' => 'Bitte Anhang auswählen.',
    ],

    'patient_admission' => [
        'patient_admission' => 'Patientenaufnahme',
        'new_patient_admission' => 'Neue Patientenaufnahme',
        'edit_patient_admission' => 'Patientenaufnahme bearbeiten',
        'details' => 'Details zur Patientenaufnahme',
        'patient' => 'Geduldig',
        'patient_name' => 'Patientenname',
        'doctor' => 'Ärztin',
        'doctor_name' => 'Name des Arztes',
        'admission_date' => 'Aufnahmedatum',
        'discharge_date' => 'Entlassungsdatum',
        'package' => 'Paket',
        'package_name' => 'Paketnamen',
        'insurance' => 'Versicherung',
        'insurance_name' => 'Versicherungsname',
        'policy_no' => 'Richtlinie Nr',
        'bed' => 'Bett',
        'agent_name' => 'Agentenname',
        'guardian_name' => 'Name des Wächters',
        'guardian_relation' => 'Wächterbeziehung',
        'guardian_contact' => 'Guardian Kontakt',
        'guardian_address' => 'Wächteradresse',
        'patient_admission_id' => 'ID der Patientenaufnahme',
        'admission_date_should_not_be_smaller_than_patient_birth_date' => 'Das Aufnahmedatum darf nicht kleiner sein als das Geburtsdatum des Patienten',
        'Admission_field_required' => 'Das Feld „Zulassungs-ID“ ist erforderlich.'
    ],

    'setting' => [
        'app_name' => 'Anwendungsname',
        'company_name' => 'Firmenname',
        'app_logo' => 'App-Logo',
        'currency' => 'Aktuelle Währung',
        'address' => 'Krankenhausadresse',
        'hospital_email' => 'Krankenhaus-E-Mail',
        'hospital_phone' => 'Krankenhaus-Telefon',
        'hospital_from_day' => 'Krankenhaus ab Tag',
        'hospital_from_time' => 'Krankenhaus ab Uhrzeit',
        'about_us' => 'Über uns',
        'image_validation' => 'Das Bild muss eine Größe von 90 x 60 Pixel haben.',
        'favicon' => 'Favicon',
        'favicon_validation' => 'Das Bild muss eine Größe von 34 x 34 Pixel haben.',
        'social_details' => 'Soziale Details',
        'country_code' => 'Ländervorwahl',
        'default_language' => 'Standardsprache',
    ],

    'currency' => [
        'currency' => 'Währung',
        'new_currency' => 'Neue Währung',
        'edit_currency' => 'Währung bearbeiten',
        'currency_name' => 'Währungsname',
        'currency_code' => 'Währungscode',
        'currency_icon' => 'Währungssymbol',
        'add_currency_code_as_per_three_letter_iso_code' => 'Fügen Sie den Währungscode gemäß dem dreistelligen ISO-Code hinzu',
        'you_can_find_out_here' => 'das erfährst du hier',
        'currency_setting_not_found' => 'Währungseinstellung nicht gefunden',
    ],

    'schedule' => [
        'new' => 'Neue Terminplanung',
        'edit' => 'Zeitplan bearbeiten',
        'details' => 'Zeitplandetails',
        'doctor_name' => 'Name des Arztes',
        'select_doctor_name' => 'Wählen Sie den Namen des Arztes',
        'per_patient_time' => 'Pro Patientenzeit',
        'serial_visibility' => 'Serielle Sichtbarkeit',
        'select_serial_visibility' => 'Wählen Sie Serielle Sichtbarkeit',
        'available_on' => 'Verfügbar auf',
        'available_from' => 'Verfügbar ab',
        'available_to' => 'Verfügbar für',
        'sequential' => 'Sequentiell',
        'timestamp' => 'Zeitstempel',
        'schedule_time_select' => 'Bitte wählen Sie die Uhrzeit pro Patient aus',
        'schedule_time' => 'Verfügbare Uhrzeit muss größer sein als die Krankenhaus-Öffnungszeit',
        'available_time_greater_than_zero' => 'Verfügbare Uhrzeit muss größer als Null sein',
        'available_to_time_greater_than_zero' => 'Verfügbare bis Uhrzeit muss größer als Null sein',
        'available_time_less_than_hospital_schedule_time' => 'Verfügbare bis Uhrzeit muss kleiner sein als die Krankenhaus-Öffnungszeit',
    ],

    'notice_board' => [
        'notice_board' => 'Schild',
        'new' => 'Neues Schwarzes Brett',
        'edit' => 'Anschlagtafel bearbeiten',
        'details' => 'Anschlagtafel Details',
        'title' => 'Titel',
        'description' => 'Beschreibung',
        'created_at' => 'hergestellt in',
    ],

    'my_payroll' => [
        'my_payrolls' => 'Meine Gehaltsabrechnungen',
        'basic_salary' => 'Grundgehalt',
        'allowance' => 'Beihilfe',
        'deductions' => 'Abzüge',
        'net_salary' => 'Nettogehalt',
    ],

    'medicine' => [
        'medicine' => 'Medizin',
        'medicine_category' => 'Medizin Kategorie',
        'medicine_category_details' => 'Details zur Medikamentenkategorie',
        'medicines' => 'Medikamente',
        'medicine_details' => 'Medizin Details',
        'new_medicine' => 'Neue Medizin',
        'new_medicine_category' => 'Neue Medizin Kategorie',
        'edit_medicine_category' => 'Kategorie Medizin bearbeiten',
        'edit_medicine' => 'Medizin bearbeiten',
        'name' => 'Name',
        'brand' => 'Marke',
        'selling_price' => 'Verkaufspreis',
        'buying_price' => 'Kaufpreis',
        'category' => 'Kategorie',
        'salt_composition' => 'Salzzusammensetzung',
        'side_effects' => 'Nebenwirkungen',
        'description' => 'Beschreibung',
        'category_id' => 'Kategorie ID',
        'brand_name' => 'Markenname',
        'medicine_brands_details' => 'Details zur Medizinmarke',
        'new_brand' => 'Neue Marke',
        'new_medicine_brand' => 'Neue Medizinmarke',
        'edit_medicine_brand' => 'Medizinmarke bearbeiten',
        'medicine_brands' => 'Arzneimittelmarken',
        'medicine_brands_details' => 'Medikamentenmarken-Details',
        'new_brand' => 'Neue Marke',
        'new_medicine_brand' => 'Neue Medikamentenmarke',
        'edit_medicine_brand' => 'Medikamentenmarke bearbeiten',
        'select_category' => 'Kategorie auswählen',
        'select_brand' => 'Marke auswählen',
        'is_active' => 'Ist aktiv',
        'delete_medicine' => 'Dieses Medikament wird bereits in Medikamentenabrechnungen verwendet. Sind Sie sicher, dass Sie es löschen möchten?',
        'category_field_required' => 'Das Feld „Kategorie“ ist erforderlich',
        'brand_field_required' => 'Das Feld „Marke“ ist erforderlich.',
    ],

    'profile' => [
        'change_language' => 'Sprache ändern',
        'language' => 'Sprache',
        'edit_profile' => 'Profil bearbeiten',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'email' => 'Email',
        'phone' => 'Telefon',
        'profile' => 'Profil',
    ],

    'dashboard' => [
        'dashboard' => 'Instrumententafel',
        'total_invoices' => 'Rechnungsbetrag',
        'total_bills' => 'Rechnungsbetrag',
        'total_payments' => 'Zahlungsbetrag',
        'total_advance_payments' => 'Vorauszahlungsbetrag',
        'notice_boards' => 'Notiz Bretter',
        'title' => 'Titel',
        'doctors' => 'Ärztinnen',
        'available_beds' => 'Verfügbare Betten',
        'patients' => 'Patientinnen',
        'income_and_expense_report' => 'Einnahmen- und Ausgabenbericht',
        'income_and_expense_reports' => 'Einnahmen- und Ausgabenberichte',
        'no_enquiries_yet' => 'Noch keine Anfragen',
        'no_notice_yet' => 'Noch keine Ankündigung',
        'total_appointment' => 'Gesamtzahl der Termine',
        'today_appointment' => 'Heute Termin',
        'total_meeting' => 'Gesamtbesprechung',
        'sum_of_ipd' => 'IPD-fälliger Betrag',
        'recent_appointments' => 'Aktuelle Termine',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'Name',
        'email' => 'Email',
        'contact' => 'Kontakt',
        'type' => 'Art',
        'message' => 'Botschaft',
        'viewed_by' => 'Gesehen von',
        'enquiry_details' => 'Anfragedetails',
        'read' => 'Lesen',
        'unread' => 'Ungelesen',
        'not_viewed' => 'Nicht angezeigt',
        'received_on' => 'Eingegangen am',
        'send_enquiry' => 'Anfrage absenden',
        'enquiry_send_successfully' => 'Anfrage erfolgreich gesendet',
    ],

    'email' => [
        'to' => 'Zu',
        'subject' => 'Gegenstand',
        'message' => 'Botschaft',
        'attachment' => 'Anhänge',
    ],

    'verification' => [
        'verify_your_email_address' => 'Bestätige deine Email-Adresse.',
        'verify_message' => 'Bevor Sie fortfahren, überprüfen Sie bitte Ihre E-Mail auf einen Bestätigungslink. Wenn Sie die E-Mail nicht erhalten haben,',
        'another_verify_request' => 'Klicken Sie hier, um eine weitere anzufordern',
        'click_button_for_verify_email' => 'Bitte klicken Sie auf die Schaltfläche unten, um Ihre E-Mail-Adresse zu bestätigen.',
        'further_action_required' => 'Wenn Sie kein Konto erstellt haben, sind keine weiteren Maßnahmen erforderlich.',
        'verify_email_address' => 'Email Adresse bestätigen',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'Krankenwagen',
        'ambulances' => 'Ambulanzen',
        'ambulance_details' => 'Krankenwagen Details',
        'vehicle_number' => 'Fahrzeugnummer',
        'vehicle_model' => 'Fahrzeugmodell',
        'year_made' => 'Jahr gemacht',
        'driver_name' => 'Fahrername',
        'driver_license' => 'Führerschein',
        'driver_contact' => 'Fahrerkontakt',
        'note' => 'Note',
        'vehicle_type' => 'Fahrzeugtyp',
        'is_available' => 'Ist verfügbar',
        'new_ambulance' => 'Neuer Krankenwagen',
        'edit_ambulance' => 'Krankenwagen bearbeiten',
    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'Krankenwagenanruf',
        'ambulance_calls' => 'Krankenwagenanrufe',
        'ambulance_call_details' => 'Details zum Krankenwagenanruf',
        'vehicle_model' => 'Fahrzeugmodell',
        'patient' => 'Geduldig',
        'driver_name' => 'Fahrername',
        'date' => 'Datum',
        'amount' => 'Menge',
        'new_ambulance_call' => 'Neuer Krankenwagenanruf',
        'edit_ambulance_call' => 'Krankenwagenanruf bearbeiten',
    ],

    // prescription keys
    'prescription' => [
        'reference_id' => 'Referenz ID',
        'prescription' => 'Rezept',
        'prescriptions' => 'Rezepte',
        'prescription_details' => 'Rezeptdetails',
        'new_prescription' => 'Neues Rezept',
        'edit_prescription' => 'Rezept bearbeiten',
        'patient' => 'Geduldig',
        'food_allergies' => 'Essensallergien',
        'tendency_bleed' => 'Tendenz bluten',
        'heart_disease' => 'Herzkrankheit',
        'high_blood_pressure' => 'Bluthochdruck',
        'diabetic' => 'Diabetikerin',
        'surgery' => 'Chirurgie',
        'accident' => 'Unfall',
        'others' => 'Andere',
        'medical_history' => 'Hinzugefügt am',
        'current_medication' => 'Derzeitige Medikamente',
        'female_pregnancy' => 'Weibliche Schwangerschaft',
        'breast_feeding' => 'Stillen',
        'health_insurance' => 'Krankenversicherung',
        'low_income' => 'Niedriges Einkommen',
        'reference' => 'Referenz',
        'physical_information' => 'physikalische Informationen',
        'new_medicine' => 'neue Medizin',
        'plus_rate' => 'Impuls Tarif',
        'temperature' => 'Temperatur',
        'problem_description' => 'Problembeschreibung',
        'test' => 'Prüfung',
        'advice' => 'Rat',
        'next_visit' => 'nächster Besuch',
        'time' => 'Zeit',
        'comment' => 'Kommentar',
        'problem' => 'Problem',
        'rx' => 'Empfang',
        'medicine_name' => 'Medizinname',
        'duration' => 'Dauer',
        'year' => 'Jahr',
        'month' => 'Monat',
        'after_meal' => 'nach dem Essen',
        'before_meal' => 'vor dem Essen',
        'no_data_available' => 'keine Daten gefunden',
    ],

    'charge_category' => [
        'charge_categories' => 'Gebührenkategorien',
        'new_charge_category' => 'Neue Gebührenkategorie',
        'edit_charge_category' => 'Gebührenkategorie bearbeiten',
        'charge_type' => 'Ladungsart',
        'charge_category_details' => 'Details zur Gebührenkategorie',
    ],

    'charge' => [
        'new_charge' => 'Neue Gebühr',
        'edit_charge' => 'Gebühr bearbeiten',
        'charge_details' => 'Gebührendetails',
        'charge_category' => 'Gebührenkategorie',
        'standard_charge' => 'Normaltarif',
        'code' => 'Code',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'Name',
        'radiology_categories' => 'Neu',
        'new_radiology_category' => 'Neu Radiologie Kategorie',
        'edit_radiology_category' => 'Bearbeiten Radiologie Kategorie',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'Pathologiekategorien',
        'new_pathology_category' => 'Neue Pathologiekategorie',
        'edit_pathology_category' => 'Pathologiekategorie bearbeiten',
        'name' => 'Name',
        'select_charge_category' => 'Gebührenkategorie auswählen',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'Radiologische Tests',
        'new_radiology_test' => 'Neuer Radiologietest',
        'edit_radiology_test' => 'Radiologie-Test bearbeiten',
        'radiology_test_details' => 'Details zum Radiologietest',
        'test_name' => 'Prüfung Name',
        'short_name' => 'Kurz Name',
        'test_type' => 'Prüfung Art',
        'category_name' => 'Kategoriename',
        'subcategory' => 'Unterkategorie',
        'report_days' => 'Tage melden',
        'charge_category' => 'Gebührenkategorie',
        'code' => 'Code',
        'standard_charge' => 'Normaltarif',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'doctor_opd_charge' => 'OPD-Gebühr des Arztes',
        'new_doctor_opd_charge' => 'Neue Doktor-OPD-Gebühr',
        'edit_doctor_opd_charge' => 'Bearbeiten Sie die OPD-Gebühr für den Arzt',
        'new_opd_charge' => 'Neue OPD Gebühr',
        'doctor_name' => 'Name des Arztes',
        'standard_charge' => 'Normaltarif',
        'doctor' => 'Arzt',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'Pathologie Tests',
        'new_pathology_test' => 'Neu Pathologie Prüfung',
        'edit_pathology_test' => 'Bearbeiten Pathologie Prüfung',
        'pathology_test_details' => 'Pathologie Prüfung Details',
        'test_name' => 'Prüfung Name',
        'short_name' => 'Kurz Name',
        'test_type' => 'Prüfung Art',
        'category_name' => 'Kategorie Name',
        'unit' => 'Einheit',
        'subcategory' => 'Unterkategorie',
        'method' => 'Methode',
        'report_days' => 'Tage melden',
        'charge_category' => 'Gebührenkategorie',
        'standard_charge' => 'Normaltarif',

    ],

    //expenses keys
    'expense' => [
        'expense' => 'Aufwand',
        'new_expense' => 'Neue Ausgaben',
        'edit_expense' => 'Kosten bearbeiten',
        'expense_head' => 'Kosten Kopf',
        'name' => 'Name',
        'date' => 'Datum',
        'invoice_number' => 'Rechnungsnummer',
        'amount' => 'Menge',
        'attachment' => 'Anhang',
        'description' => 'Beschreibung',
        'choose' => 'Wählen',
        'download' => 'Herunterladen',
        'expense_details' => 'Aufwandsdetails',
        'select_expense_head' => 'Wählen Sie Expense Head',
        'document_error' => 'Das Dokument muss eine Dateityp sein: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'Einkommen',
        'new_income' => 'Neues Einkommen',
        'edit_income' => 'Einkommen bearbeiten',
        'income_head' => 'Einkommensleiter',
        'name' => 'Name',
        'date' => 'Datum',
        'invoice_number' => 'Rechnungsnummer',
        'amount' => 'Menge',
        'attachment' => 'Anhang',
        'description' => 'Beschreibung',
        'choose' => 'Wählen',
        'download' => 'Herunterladen',
        'income_details' => 'Einkommensdetails',
        'select_income_head' => 'Wählen Sie Income Head',
        'document_error' => 'Das Dokument muss eine Dateityp sein: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Bettstatus',
        'assigned_beds' => 'Zugewiesene Betten',
        'available_beds' => 'Verfügbare Betten',
        'bed_name' => 'Bettname',
        'patient_name' => 'Patienten name',
        'phone' => 'Telefon',
        'admission_date' => 'Aufnahmedatum',
        'gender' => 'Geschlecht',
    ],

    //Messages keys
    'message' => [
        'message' => 'Botschaft',
        'messages' => 'Mitteilungen',
        'send_to' => 'Senden an',
        'subject' => 'Gegenstand',
        'new_message' => 'Neue Nachricht',
        'messages_details' => 'Nachrichtendetails',
        'sender_name' => 'Absender',
        'date' => 'Datum',
        'select_user' => 'Wähle den Benutzer',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'SMS',
        'new_sms' => 'Neue SMS',
        'send_to' => 'Senden an',
        'phone_number' => 'Telefonnummer',
        'send_by' => 'Gesendet von',
        'message' => 'Botschaft',
        'sms_details' => 'SMS-Details',
        'date' => 'Datum',
        'send' => 'Senden',
        'role' => 'Rolle',
        'send_sms_by_number_directly' => 'Senden Sie SMS direkt nach Nummer',
        'only_user_with_registered_phone_will_display' => '(Es werden nur Benutzer mit einem registrierten Telefon angezeigt.)',
        'message_not_greater_than_160_characters' => 'Die Nachricht darf nicht mehr als 160 Zeichen enthalten.',
        'set_credential' => 'Bitte setzen Sie Ihre Anmeldeinformationen.',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'Diagnose',
        'diagnosis_test' => 'Diagnosetests',
        'patient_diagnosis_test' => 'Patientendiagnosetests',
        'report_number' => 'Berichtsnummer',
        'patient' => 'Geduldig',
        'doctor' => 'Arzt',
        'created_at' => 'Hergestellt in',
        'action' => 'Aktion',
        'new_patient_diagnosis_test' => 'Neuer Patientendiagnosetest',
        'edit_patient_diagnosis_test' => 'Patientendiagnosetest bearbeiten',
        'create_patient_diagnosis_test' => 'Erstellen Sie einen Patientendiagnosetest',
        'patient_diagnosis_test_details' => 'Details zum Patientendiagnosetest',
        'diagnosis_category' => 'Diagnosekategorie',
        'add_other_diagnosis_property' => 'Fügen Sie eine andere Diagnoseeigenschaft hinzu',
        'other_diagnosis_property' => 'Andere Diagnoseeigenschaft',
        'diagnosis_property_name' => 'Name der Diagnoseeigenschaft',
        'diagnosis_property_value' => 'Diagnoseeigenschaftswert',
        'patient_name' => 'Patientenname',
        'doctor_name' => 'Name des Arztes',
        'age' => 'Alter',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'average_glucose' => 'Durchschnittliche Glukose',
        'fasting_blood_sugar' => 'Blutzucker nüchtern',
        'urine_sugar' => 'Urin Zucker',
        'blood_pressure' => 'Blutdruck',
        'diabetes' => 'Diabetes',
        'cholesterol' => 'Cholesterin',
        'print_diagnosis_test' => 'Diagnosetest drucken',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'Diagnosekategorie',
        'diagnosis_categories' => 'Diagnosekategorie',
        'new_diagnosis_category' => 'Neue Diagnosekategorie',
        'description' => 'Beschreibung',
        'category_name' => 'Kategoriename',
        'diagnosis_category_details' => 'Details zur Diagnosekategorie',
        'edit_diagnosis_category' => 'Diagnosekategorie bearbeiten',
    ],

    // Operation Category
    'operation_category' => [
        'operation_category' => 'Betriebskategorie',
        'operation_categories' => 'Betriebskategorien',
        'new_operation_category' => 'Neue Operationskategorie',
        'edit_operation_category' => 'Kategorie bearbeiten',
        'operation_category_field_required' => 'Das Feld „Vorgangskategorie“ ist erforderlich.',
    ],

    // Operation
    'operation' => [
        'operation' => 'Betrieb',
        'operation_field_required' => 'Das Operationsfeld ist erforderlich.',
        'select_operation_date' => 'Bitte wählen Sie das Operationsdatum aus.',
        'operation_date' => 'Operationsdatum',
        'operation_name' => 'Operationsname',
        'operation_category_name' => 'Name der Vorgangskategorie',
        'ot_technician' => 'OT-Techniker',
        'ot_assistant' => 'OT-Assistent',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'Artikel kategorie',
        'item_categories' => 'Artikel kategorien',
        'new_item_category' => 'Neue Artikel kategorie',
        'edit_item_category' => 'Artikel kategorie bearbeiten',
        'name' => 'Name',
    ],

    'item' => [
        'item' => 'Artikel',
        'items' => 'Artikel',
        'new_item' => 'Neu Artikel',
        'edit_item' => 'Bearbeiten Artikel',
        'item_details' => 'Artikel Einzelheiten',
        'name' => 'Name',
        'item_category' => 'Artikel Kategorie',
        'unit' => 'Einheit',
        'description' => 'Beschreibung',
        'available_quantity' => 'Verfügbar Menge',
    ],

    'item_stock' => [
        'item_stock' => 'Artikel Lager',
        'item_stocks' => 'Artikel Bestände',
        'new_item_stock' => 'Neu Artikel Lager',
        'edit_item_stock' => 'Bearbeiten Artikel Lager',
        'item_stock_details' => 'Artikel Lager Details',
        'item_category' => 'Artikel Kategorie',
        'item' => 'Artikel',
        'supplier_name' => 'Lieferant Name',
        'store_name' => 'Geschäft Name',
        'quantity' => 'Menge',
        'purchase_price' => 'Kaufpreis',
        'description' => 'Beschreibung',
        'attachment' => 'Anhang',
    ],

    'issued_item' => [
        'issued_item' => 'Ausgestelltes Objekt',
        'issued_items' => 'Ausgestellte Artikel',
        'new_issued_item' => 'Neu ausgegebener Artikel',
        'edit_issued_item' => 'Ausgestelltes Element bearbeiten',
        'issued_item_details' => 'Details zu ausgegebenen Artikeln',
        'department_id' => 'Benutzertyp',
        'user_id' => 'Ausgabe an',
        'issued_by' => 'Problem durch',
        'issued_date' => 'Ausgabedatum',
        'return_date' => 'Rückflugdatum',
        'item_category' => 'Artikelkategorie',
        'item' => 'Artikel',
        'quantity' => 'Menge',
        'description' => 'Beschreibung',
        'available_quantity' => 'verfügbare Anzahl',
        'item_return' => 'Artikel zurückgeben',
        'item_returned' => 'Ist zurückgekommen',
        'are_you_sure_want_to_return_this_item' => 'Möchten Sie diesen Artikel wirklich zurückgeben?',
        'quantity_cannot_be_zero' => 'Die Menge darf nicht null sein.',
        'quantity_must_be_less_than_available_quantity' => 'Die Menge muss kleiner sein als die verfügbare Menge.',
    ],

    'ipd_patient' => [
        'ipd_patient_in' => 'IPD - Patientin',
        'ipd_patient' => 'IPD Patient',
        'ipd_patients' => 'IPD Patients',
        'new_ipd_patient' => 'Neuer IPD Patient',
        'edit_ipd_patient' => 'IPD-Patienten bearbeiten',
        'ipd_patient_details' => 'IPD Patient Einzelheiten',
        'patient_id' => 'Geduldig',
        'ipd_number' => 'IPD Nr',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'bp' => 'Blutdruck',
        'symptoms' => 'Symptome',
        'notes' => 'Anmerkungen',
        'admission_date' => 'Aufnahmedatum',
        'case_id' => 'Fall',
        'is_old_patient' => 'Ist alter Patient',
        'doctor_id' => 'Arzt',
        'bed_type_id' => 'Betttyp',
        'bed_id' => 'Bett',
        'bill_status' => 'Rechnungsstatus',
        'the_case_field_is_required' => 'Das Fallfeld ist erforderlich.',
        'the_bed_field_is_required' => 'Das Bettfeld ist erforderlich.',
        'the_bed_field_has_a_duplicate_value' => 'Das Bettfeld hat einen doppelten Wert',
        'the_bed_already_taken' => 'Die Bed :-Eingabe wurde bereits übernommen',
        'the_bed_type_is_required' => 'Das Feld „Bettentyp“ ist erforderlich.',
        'charge_required' => 'Kostenfeld erforderlich.',
        'discharge' => 'Entladung',
        'net_amount' => 'Netto-Betrag',
        'discharged' => 'Entladen',
        'not_dischared' => 'Nicht entlassen',
        'discharge_slip' => 'Entladeschein',
        'print_discharge_slip' => 'Entlassungsschein ausdrucken',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'Diagnose hinzufügen',
        'edit_ipd_diagnosis' => 'Diagnose bearbeiten',
        'report_type' => 'Berichtstyp',
        'report_date' => 'Berichtsdatum',
        'document' => 'Dokument',
        'description' => 'Beschreibung',
    ],

    'ipd_patient_consultant_register' => [
        'consultant_instruction' => 'Beraterinstruktion',
        'consultant_doctor' => 'Beratender Arzt',
        'new_consultant_register' => 'Berateranweisung hinzufügen',
        'edit_consultant_register' => 'Berateranweisung bearbeiten',
        'applied_date' => 'Angewandtes Datum',
        'doctor_id' => 'Arzt',
        'instruction' => 'Anweisung',
        'instruction_date' => 'Anweisungsdatum',
        'applied_date_or_Instruction_date_can_not_be_null' => 'Das Datum der Anwendung oder des Anweisungsdatums darf nicht leer sein',
        'assistant_consultant_1' => 'Assistenzberater 1',
        'assistant_consultant_2' => 'Assistenzberater 2',
        'anesthetist' => 'Anästhesist',
        'anesthesia_type' => 'Anästhesietyp',
        'instruction_field_is_required' => 'Das Anweisungsfeld ist erforderlich.',
    ],

    'ipd_patient_charges' => [
        'new_charge' => 'Gebühren hinzufügen',
        'edit_charge' => 'Gebühren bearbeiten',
        'date' => 'Datum',
        'charge_type_id' => 'Ladungsart',
        'charge_category_id' => 'Gebührenkategorie',
        'charge_id' => 'Code',
        'standard_charge' => 'Standardgebühr',
        'applied_charge' => 'Angewandte Gebühr',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD Nr',
        'header_note' => 'Header Hinweis',
        'footer_note' => 'Fußzeile Hinweis',
        'new_prescription' => 'Rezept hinzufügen',
        'edit_prescription' => 'Rezept bearbeiten',
        'prescription_details' => 'Rezeptdetails',
        'category_id' => 'Medizin Kategorie',
        'medicine_id' => 'Medizin',
        'dosage' => 'Dosierung',
        'instruction' => 'Anweisung',
        'print_prescription' => 'Rezept drucken',
    ],

    'ipd_patient_timeline' => [
        'timeline' => 'Zeitleiste',
        'new_ipd_timeline' => 'Timeline hinzufügen',
        'edit_ipd_timeline' => 'Timeline bearbeiten',
        'title' => 'Titel',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'document' => 'Dokument',
        'visible_to_person' => 'Für die Person sichtbar',
        'no_timeline_found' => 'Keine Zeitleiste gefunden',
    ],

    'ipd_operation' => [
        'ipd_operation' => 'IPD-Operation',
        'ipd_operation_created_successfully' => 'IPD-Operation erfolgreich erstellt',
        'operation_field_required' => 'Das Operationsfeld ist erforderlich.',
        'select_operation_date' => 'Bitte wählen Sie das Operationsdatum aus.'
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'Ipd-Zahlung hinzufügen',
        'edit_ipd_payment' => 'IPD-Zahlung bearbeiten',
        'payment_mode' => 'Zahlungsart',
        'make_payment' => 'Zahlung leisten',
    ],

    'ipd_bill' => [
        'paid_amount' => 'Bezahlte Menge',
        'total_charges' => 'Gesamte Gebühren',
        'gross_total' => 'Bruttosumme',
        'discount_in_percentage' => 'Rabatt in Prozent',
        'discount_in_number' => 'Discount In Number',
        'tax_in_percentage' => 'Steuer in Prozent',
        'tax_in_number' => 'Steuernummer',
        'other_charges' => 'Zusatzgebühren',
        'net_payable_amount' => 'Nettobetrag',
        'discharge_patient' => 'Patienten entlassen',
    ],

    'opd_patient' => [
        'opd_patient_out' => 'OPD – Patient aus',
        'opd_patient' => 'OPD Patient',
        'opd_patients' => 'OPD Patients',
        'new_opd_patient' => 'Neu OPD Patient',
        'edit_opd_patient' => 'Bearbeiten OPD Patient',
        'opd_patient_details' => 'OPD Patienten details',
        'opd_number' => 'OPD Nein',
        'appointment_date' => 'Termin',
        'visits' => 'Besuche',
        'revisits' => 'Wiederholen',
        'total_visits' => 'Gesamtzahl der Besuche',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'Opd Payment hinzufügen',
        'edit_opd_payment' => 'Opd Payment bearbeiten',
        'payment_mode' => 'Zahlungsart',
        'make_payment' => 'Zahlung leisten',
    ],

    'call_log' => [
        'call_log' => 'Anrufliste',
        'new' => 'Neues Anrufprotokoll',
        'edit' => 'Anrufliste bearbeiten',
        'name' => 'Name',
        'phone' => 'Telefon',
        'received_on' => 'Eingegangen am',
        'follow_up_date' => 'Follow-up-Termin',
        'note' => 'Hinweis',
        'call_type' => 'Anrufart',
        'incoming' => 'Eingehend',
        'outgoing' => 'Ausgehend',
    ],

    'visitor' => [
        'visitor' => 'Besucherin',
        'new' => 'Neuer Besucher',
        'edit' => 'Besucher bearbeiten',
        'name' => 'Name',
        'purpose' => 'Zweck',
        'phone' => 'Telefon',
        'id_card' => 'Ausweis',
        'number_of_person' => 'Anzahl von Personen',
        'date' => 'Datum',
        'in_time' => 'Rechtzeitig',
        'out_time' => 'aus der Zeit',
        'note' => 'Hinweis',
    ],

    'postal' => [
        'postal' => 'Post',
        'new_receive' => 'Neu empfangen',
        'new_dispatch' => 'Neuer Versand',
        'dispatch' => 'Versand',
        'receive' => 'Erhalten',
        'edit_receive' => 'Empfangen bearbeiten',
        'edit_dispatch' => 'Versand bearbeiten',
        'to_title' => 'Zum Titel',
        'from_title' => 'Aus dem Titel',
        'reference_no' => 'Referenznummer',
        'date' => 'Datum',
        'address' => 'Adresse',
        'validate_from_title' => 'Der Absendertitel ist erforderlich.',
        'validate_to_title' => 'Der Empfängertitel ist erforderlich.',
    ],

    'testimonial' => [
        'testimonial' => 'Zeugnis',
        'new_testimonial' => 'Neu Zeugnis',
        'edit_testimonial' => 'Testimonial bearbeiten',
        'testimonial_detail' => 'Testimonial-Details',
        'name' => 'Name',
        'description' => 'Beschreibung',
        'profile_error' => 'Das Dokument muss eine Datei vom Typ sein: jpeg, jpg, png.',
    ],

    'blood_donation' => [
        'blood_donation' => 'Blutspende',
        'new_blood_donation' => 'Neue Blutspende',
        'edit_blood_donation' => 'Blutspende bearbeiten',
        'donor_name' => 'Name des Spenders',
        'bags' => 'Taschen',
        'last_donate_date' => 'Letztes Spendendatum',
    ],

    'blood_issue' => [
        'blood_issue' => 'Blutproblem',
        'new_blood_issue' => 'Neues Blutproblem',
        'edit_blood_issue' => 'Blutproblem bearbeiten',
        'issue_date' => 'Ausgabedatum',
        'patient_name' => 'Patientenname',
        'doctor_name' => 'Name des Arztes',
        'donor_name' => 'Name des Spenders',
        'amount' => 'Menge',
        'remarks' => 'Bemerkungen',
    ],

    'notification' => [
        'all_notification_read_successfully' => 'Alle Benachrichtigungen wurden erfolgreich gelesen',
        'notification_read_successfully' => 'Benachrichtigung wurde erfolgreich gelesen',
        'notifications' => 'Benachrichtigungen',
        'mark_all_as_read' => 'Markiere alle als gelesen',
        'you_don`t_have_any_new_notification' => 'Sie haben keine neue Benachrichtigung',
    ],

    'live_consultation' => [
        'live_consultation' => 'Live-Beratung',
        'new_live_consultation' => 'Neue Live-Beratung',
        'consultation_title' => 'Beratungstitel',
        'consultation_date' => 'Beratungsdatum',
        'consultation_duration_minutes' => 'Beratungsdauer (in Minuten)',
        'client_video' => 'Kunden-Video',
        'host_video' => 'Host-Video',
        'enable' => 'Aktivieren',
        'disabled' => 'Deaktiviert',
        'type' => 'Typ',
        'type_number' => 'Typ-Nummer',
        'created_by' => 'Erstellt von',
        'created_for' => 'Erstellt für',
        'new_live_meeting' => 'Neues Live-Meeting',
        'staff_list' => 'Mitarbeiterliste',
        'edit_live_consultation' => 'Live-Beratung bearbeiten',
        'duration' => 'Dauer (in Minuten)',
        'start_now' => 'Jetzt starten',
        'join_now' => 'Jetzt beitreten',
        'edit_live_meeting' => 'Live-Meeting bearbeiten',
        'add_credential' => 'Anmeldeinformation hinzufügen',
        'zoom_api_key' => 'Zoom API-Schlüssel',
        'zoom_api_secret' => 'Zoom API-Geheimnis',
        'join_meeting' => 'Meeting beitreten',
        'start_meeting' => 'Meeting starten',
        'generate_auth_credentials' => 'Wie Authentifizierungsanmeldeinformationen generieren?',
        'user_zoom_credential_saved' => 'Zoom-Anmeldeinformationen des Benutzers erfolgreich gespeichert.',
        'add_credentials_for_zoom_meeting' => 'Bitte fügen Sie Anmeldeinformationen für das Zoom-Meeting hinzu.',
        'credentials_already_use' => 'Ihre Zoom-Zugangsdaten werden bereits verwendet',
        'connect_with_zoom' => 'Sie müssen eine Verbindung mit Zoom herstellen',
        'cannot_delete_meeting_in_progress' => 'Leider können Sie diese Besprechung nicht löschen, da sie noch läuft',
        'select_platform' => 'Wählen Sie Plattform aus',
    ],

    'vaccination' => [
        'vaccinations' => 'Impfungen',
        'new_vaccination' => 'Neue Impfung',
        'edit_vaccination' => 'Impfung bearbeiten',
        'name' => 'Name',
        'manufactured_by' => 'Hergestellt von',
        'brand' => 'Marke',
        'vaccinated' => 'Geimpft',
    ],

    'vaccinated_patient' => [
        'vaccinated_patient' => 'Geimpfter Patient',
        'patient' => 'Geduldig',
        'vaccination' => 'Impfung',
        'serial_no' => 'Seriennummer',
        'does_no' => 'Dosis Nr',
        'dose_given_date' => 'Dosis gegebenes Datum',
        'description' => 'Beschreibung',
        'add_vaccinate_patient' => 'Impfpatienten hinzufügen',
        'new_vaccinate_patient' => 'Neuer Impfpatient',
        'edit_vaccinate_patient' => 'Impfpatienten bearbeiten',
        'vaccine' => 'Impfstoff',
        'vaccinate_patient' => 'Patienten impfen',
        'already_registered_dose' => 'Der Patient ist bereits mit demselben Impfstoff und derselben Dosis registriert.',
    ],

    'front_setting' => [
        'about_us_title' => 'Titel',
        'about_us_mission' => 'Mission',
        'about_us_image' => 'Bild',
        'about_us_description' => 'Beschreibung',
        'about_us_details' => 'Über uns Details',
        'appointment_details' => 'Termindetails',
        'terms_condition_details' => 'AGB-Details',
        'front_setting_details' => 'Fronteinstellungsdetail',
        'home_page_image' => 'Startseitenbild',
        'home_page_title' => 'Titel der Homepage',
        'home_page_description' => 'Homepage-Beschreibung',
        'home_page_box_title' => 'Titel der Homepage-Box',
        'home_page_box_description' => 'Beschreibung des Startseitenfelds',
        'home_page_experience' => 'Homepage-Erfahrung',
        'home_page_step_1_title' => 'Startseite Schritt 1 Titel',
        'home_page_step_1_description' => 'Startseite Schritt 1 Beschreibung',
        'home_page_step_2_title' => 'Startseite Schritt 2 Titel',
        'home_page_step_2_description' => 'Startseite Schritt 2 Beschreibung',
        'home_page_step_3_title' => 'Startseite Schritt 3 Titel',
        'home_page_step_3_description' => 'Startseite Schritt 3 Beschreibung',
        'home_page_step_4_title' => 'Startseite Schritt 4 Titel',
        'home_page_step_4_description' => 'Startseite Schritt 4 Beschreibung',
        'terms_conditions' => 'Terms & Bedingungen',
        'privacy_policy' => 'Datenschutz-Bestimmungen',
        'home_page_certified_doctor_image' => 'Startseite Zertifizierter Arzt Bild',
        'home_page_certified_doctor_text' => 'Homepage Zertifizierter Arzt Text',
        'home_page_certified_doctor_title' => 'Homepage Zertifizierter Arzt Titel',
        'home_page_certified_doctor_description' => 'Startseite Zertifizierter Arzt Beschreibung',
        'home_page_certified_box_title' => 'Homepage Zertifizierte Box Titlen',
        'home_page_certified_box_description' => 'Startseite Zertifizierte Box Beschreibung',
        'the_terms_conditions_is_required' => 'Die Nutzungsbedingungen sind erforderlich.',
        'the_privacy_policy_is_required' => 'Die Datenschutzrichtlinie ist erforderlich.',
        'home_page_experience_required' => 'Das Feld "Erfahrung auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_title_required' => 'Das Feld "Titel der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_description_required' => 'Das Feld "Beschreibung der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_box_required' => 'Das Feld "Titel des Startseiten-Box" darf nicht nur Leerzeichen enthalten',
        'home_page_box_descriptions_required' => 'Das Feld "Beschreibungen des Startseiten-Box" darf nicht nur Leerzeichen enthalten',
        'home_page_certified_required' => 'Das Feld "Zertifizierter Arzt Text auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_certified_title_required' => 'Das Feld "Titel des zertifizierten Arztes auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_certified_doctor_description_required' => 'Das Feld "Beschreibung des zertifizierten Arztes auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_certified_box_title_required' => 'Das Feld "Titel des zertifizierten Box auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_certified_description_required' => 'Das Feld "Beschreibung des zertifizierten Arztes im zertifizierten Feld auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_title_required' => 'Das Feld "Titel der Schritt 1 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_description_required' => 'Das Feld "Beschreibung des Schritt 1 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_two_title_required' => 'Das Feld "Titel des Schritt 2 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_two_description_required' => 'Das Feld "Beschreibung des Schritt 2 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_three_title_required' => 'Das Feld "Titel des Schritt 3 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_three_description_required' => 'Das Feld "Beschreibung des Schritt 3 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_four_title_required' => 'Das Feld "Titel des Schritt 4 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'home_page_step_four_description_required' => 'Das Feld "Beschreibung des Schritt 4 auf der Startseite" darf nicht nur Leerzeichen enthalten',
        'about_us_title_required' => 'Das Feld "Titel Über uns" darf nicht nur Leerzeichen enthalten',
        'about_us_description_required' => 'Das Feld "Beschreibung Über uns" darf nicht nur Leerzeichen enthalten',
        'about_us_mission_required' => 'Das Feld "Mission Über uns" darf nicht nur Leerzeichen enthalten',
    ],

    'change_password' => [
        'change_password' => 'Kennwort ändern',
        'current_password' => 'Jetziges Passwort',
        'new_password' => 'Neues Kennwort',
        'confirm_password' => 'Kennwort bestätigen',
    ],

    'front_services' => [
        'new_service' => 'Neuer Dienst',
        'edit_service' => 'Dienst bearbeiten',
        'select_icon_file' => 'Bitte wählen Sie die Symboldatei aus',
    ],

    'web_home' => [
        'home' => 'Heim',
        'services' => 'Dienstleistungen',
        'doctors' => 'Ärztinnen',
        'about_us' => 'Über uns',
        'contact' => 'Kontakt',
        'make_appointment' => 'Einen Termin machen',
        'working_hours' => 'Arbeitszeit',
        'testimonials' => 'Referenzen',
        'terms_of_service' => 'Nutzungsbedingungen',
        'privacy_policy' => 'Datenschutz-Bestimmungen',
        'patients' => 'Patientinnen',
        'years_experience' => 'Jahre Erfahrung',
        'sign_up' => 'Anmeldung',
        'available_doctors' => 'Verfügbare Ärzte',
        'select_doctors' => 'Ärzte auswählen',
        'contact_doctors' => 'Arzt kontaktieren',
        'contact_hospital' => 'Krankenhaus kontaktieren',
        'easy_solutions' => 'Einfache Lösungen',
        '4_easy_step_and_get_the_world_best_treatment' => '4 einfache Schritte und erhalten Sie die beste Behandlung der Welt',
        'book_an_appointment' => 'Vereinbare einen Termin',
        'select_doctor' => 'Arzt auswählen',
        'book_now' => 'buchen Sie jetzt',
        'patients_beds' => 'Patientenbetten',
        'doctors_nurses' => 'Ärzte & Krankenschwestern',
        'happy_patients' => 'Glückliche Patienten',
        'book_appointment' => 'Einen Termin verabreden',
        'our_services' => 'Unsere Dienstleistungen',
        'we_offer_different_services_to_improve_your_health' => 'Wir bieten verschiedene Dienstleistungen an, um Ihre Gesundheit zu verbessern',
        'professional_doctors' => 'Professionelle Ärzte',
        'we_are_experienced_healthcare_professionals' => 'Wir sind erfahrene Gesundheitsexperten',
        'our_testimonials' => 'Unsere Erfahrungsberichte',
        'what_our_patient_say_about_medical_treatments' => 'Was unsere Patienten über unsere medizinischen Behandlungen sagen',
        'professional_details' => 'Professionelle Details',
    ],

    'web_password' => [
        'please_fill_all_the_required_fields' => 'Bitte füllen Sie alle Pflichtfelder aus.',
        'password_and_confirm_password_not_match' => 'Passwort und Passwort bestätigen stimmen nicht überein.',
    ],

    'web_contact' => [
        'call_today' => 'Ruf heute an',
        'open_hours' => 'Öffnungszeiten',
        'our_location' => 'unsere Position',
        'send_us_a_message' => 'Schick uns eine Nachricht',
        'your_name' => 'Dein Name',
        'your_email' => 'Deine E-Mail',
        'phone_number' => 'Telefonnummer',
        'select_enquiry' => 'Anfrage auswählen',
        'your_message' => 'Ihre Nachricht',
        'send_message' => 'Nachricht senden',
        'enter_your_name' => 'Gib deinen Namen ein',
        'enter_your_email' => 'Geben sie ihre E-Mail Adresse ein',
        'contact_no' => 'Kontakt Nr',
        'please_enter_your_phone_number' => 'Bitte geben sie ihre Telefonnummer ein',
        'write_your_message' => 'Schreibe deine Nachricht',
        'type_your_message' => 'Geben Sie Ihre Nachricht ein',
    ],

    'web_menu' => [
        'about' => 'Über',
        'our_features' => 'Unsere Funktionen',
        'appointment' => 'Termin',
        'working_hours' => 'Arbeitszeit',
        'login' => 'Anmeldung',
        'useful_link' => 'Nützlicher Link',
        'contact_information' => 'Kontaktinformationen',
        'copyright' => 'Urheberrechte ©',
        'all_rights_reserved_by' => 'Alle Rechte vorbehalten von',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'Einen Termin machen',
        'call_now_and_get_a_free_consulting' => 'Rufen Sie jetzt an und lassen Sie sich kostenlos beraten',
        'enter_your_first_name' => 'Geben Sie Ihren Vornamen ein',
        'enter_your_last_name' => 'Geben Sie Ihren Nachnamen ein',
        'enter_your_password' => 'Geben Sie Ihr Passwort ein',
        'enter_confirm_password' => 'Geben Sie das Kennwort zur Bestätigung ein',
        'select_department' => 'Abteilung auswählen',
        'select_doctor' => 'Arzt auswählen',
        'enter_description' => 'Beschreibung eingeben',
        'select_time' => 'Wählen Sie Zeit',
    ],

    'web_working_hours' => [
        'opening_hours' => 'Öffnungszeiten',
        'no_yet_opening_hours' => 'Noch keine Öffnungszeiten',
    ],

    'purchase_medicine' => [
        'purchase_number' => 'Kaufnummer',
        'total' => 'Gesamt',
        'discount' => 'Rabatt',
        'tax_amount' => 'Steuerbetrag',
        'net_amount' => 'Netto-Betrag',
        'payment_mode' => 'Zahlungsart',
        'payment_note' => 'Zahlungshinweis',
        'note' => 'Note',
        'purchase_medicine' => 'Kaufen Sie Medikamente',
        'purchase_medicine_details' => 'Details zum Kauf von Medikamenten',
        'purchase_medicine_overview' => 'Übersicht über den Kauf von Arzneimitteln',
        'lot_no' => 'Lot-Nr.',
        'tax' => 'Steuer',
        'quantity' => 'Menge',
        'amount' => 'Menge',
        'expiry_date' => 'Verfallsdatum',
        'other_details' => 'Andere Details',
        'dose_duration' => 'Dosisdauer',
        'medicine_purchased_successfully' => 'Medikament erfolgreich gekauft',
    ],

    'used_medicine' => [
        'used_medicine' => 'Gebrauchte Medizin',
        'used_quantity' => 'Gebrauchte Menge',
        'used_at' => 'Verwendet bei',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Medikamentenabrechnungen',
        'medicine_bill' => 'Medikamentenabrechnung',
        'add_medicine_bill' => 'Medikamentenabrechnung hinzufügen',
        'edit_medicine_bill' => 'Medikamentenabrechnung bearbeiten',
        'medicine_bill_details' => 'Details zur Medikamentenabrechnung',
        'dose_interval' => 'Dosisintervall',
        'available_quantity' => 'Die verfügbare Menge von',
        'is' => 'ist',
        'prescription_not_found' => 'Rezept nicht gefunden.',
        'medicine_not_selected' => 'Bitte wählen Sie mindestens ein Medikament aus.',
        'duplicate_medicine' => 'Doppelte Medikamente können nicht hinzugefügt werden.',
        'payment_status' => 'Zahlungsstatus',
        'sale_price' => 'Verkaufspreis',
        'select_medicine' => 'Medikament auswählen',
        'update_quantity' => 'Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge.',
        'net_amount_not_empty' => 'Der Netto-Betrag darf nicht leer sein.',
        'net_amount_not_zero' => 'Der Netto-Betrag darf nicht null sein.',
        'tax_amount_not_zero_or_empty' => 'Der Steuerbetrag darf nicht null oder leer sein.',
        'medicine_required' => 'Das Medikamentenfeld ist erforderlich.',
        'bill_number' => 'Rechnungsnummer',
        'validate_discount' => 'Der Rabatt sollte kleiner sein als der Gesamtbetrag',
        'validate_tax' => 'Die Steuern sollten weniger als 100% sein.',
        'quantity_cannot_be_zero' => 'Die Menge darf nicht null oder leer sein.',
        'lot_number' => 'Lot-Nummer eingeben',
        'sale_price' => 'Verkaufspreis eingeben',
        'purchase_price' => 'Einkaufspreis eingeben',
        'validate_quantity' => 'Die Menge sollte größer als 0 sein.',
        'quantity_required' => 'Bitte geben Sie die Menge ein.',
    ],

    'new_change' => [
        'pathology_units' => 'Pathologische Einheiten',
        'pathology_unit' => 'Abteilung für Pathologie',
        'add_unit' => 'Neue Abteilung für Pathologie',
        'edit_unit' => 'Abteilung Pathologie bearbeiten',
        'pathology_unit_not_found' => 'Pathologieeinheit nicht gefunden',
        'pathology_unit_cant_deleted' => 'Die Pathologieeinheit kann nicht gelöscht werden.',
        'pathology_parameter_not_found' => 'Pathologieparameter nicht gefunden',
        'pathology_parameter_cant_deleted' => 'Der Pathologieparameter kann nicht gelöscht werden.',
        'pathology_parameter' => 'Pathologieparameter',
        'pathology_parameters' => 'Pathologische Parameter',
        'add_parameter' => 'Neuer Pathologieparameter',
        'edit_parameter' => 'Pathologieparameter bearbeiten',
        'parameter_name_required' => 'Das Feld „Parametername“ ist erforderlich.',
        'patient_result_required' => 'Das Feld „Patientenergebnis“ ist erforderlich.',
        'parameter_name' => 'Parametername',
        'patient_result' => 'Patientenergebnis',
        'select_parameter_name' => 'Wählen Sie Parametername',
        'reference_range' => 'Referenzbereich',
        'select_unit' => 'Wählen Sie Einheit',
        'print_pathology_test' => 'Pathologietest drucken',
        'pathology_test_report' => 'Pathologischer Testbericht',
    ],
    'subscription_plans' => [
        'payment_type' => 'Zahlungsart auswählen',
        'connect_with_zoom' => 'Mit Zoom verbinden',
        'connected' => 'Verbunden',
    ],

    'holiday' => [
        'holiday' => 'Feiertag',
        'add_holiday' => 'Feiertag hinzufügen',
        'doctor_holiday' => 'Arztferien',
        'service_category' => 'Dienstleistungskategorie',
        'holiday_date' => 'Feiertagsdatum',
        'reason' => 'Grund',
        'holiday_already_is_exist' => 'Feiertag existiert bereits.',
        'doctor_holiday_create' => 'Arztferien erfolgreich gespeichert.',
        'you_are_not_allow_to_record' => 'Sie haben anscheinend keinen Zugriff auf diesen Datensatz.',
        'appointment_exists' => 'Termin vorhanden Sie können keinen Urlaub nehmen.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'Pausen',
        'lunch_break' => 'Pause',
        'break_create' => 'Pause erfolgreich gespeichert.',
        'break_update' => 'Pause erfolgreich aktualisiert.',
        'add_break' => 'Pause hinzufügen',
        'edit_break' => 'Pause bearbeiten',
        'break_already_is_exist' => 'Pause existiert bereits.',
        'break_time_greater_than_zero' => 'Die Pausenzeit muss größer als Null sein.',
        'break_to_time_greater_than_zero' => 'Die Pause bis-Zeit muss größer als Null sein.',
        'break_to_time_greater_than_from_time' => 'Die Pause bis-Zeit muss größer sein als die Pause von-Zeit.',
        'select_ipd_patient' => 'Wählen Sie IPD-Patient aus',
        'date_required' => 'Das Datumsfeld ist erforderlich.',
        'appointment_exists' => 'Es gibt einen Termin. Sie können keine Pause machen.',
    ],

    'patient_id_card' => [
        'id' => 'AUSWEIS',
        'patient_id_card' => 'Patienten-Smartcards',
        'new_patient_id_card_template' => 'Neue Patienten-Smartcard-Vorlage',
        'edit_patient_id_card_template' => 'Bearbeiten Sie die Patienten-Smartcard-Vorlage',
        'patient_id_card_template' => 'Patienten-Smartcard-Vorlage',
        'color' => 'Farbe',
        'patient_unique_id' => 'Eindeutige Patienten-ID',
        'new_patient_id_card' => 'Neue Patienten-Smartcard',
        'generate_patient_id_card' => 'Generieren Sie eine Patienten-Smartcard',
        'template_id' => 'Vorlagenname',
        'select_template' => 'Vorlage auswählen',
        'select_type' => 'Typ auswählen',
        'all_patient' => 'Für alle Patienten',
        'one_patient' => 'Nur für einen Patienten',
        'remaining_patients' => 'Verbleibende Patienten',
        'template_required' => 'Vorlagenfeld erforderlich',
        'patient_required' => 'Patientenfeld ist erforderlich',
    ],

    'register' => [
        'hello' => 'Hallo!',
        'whoops' => 'Hoppla!',
        'regards' => 'Freundliche Grüße,',
        'if_having_trouble_text' => "Wenn Sie Probleme beim Klicken auf die Schaltfläche \":actionText\" haben, kopieren Sie die URL unten\n".
        'und fügen Sie sie in Ihren Webbrowser ein: [:actionURL](:actionURL)',
    ],

    'custom_field' => [
        'custom_field' => 'Benutzerdefiniertes Feld',
        'add_custom_field' => 'Benutzerdefiniertes Feld hinzufügen',
        'edit_custom_field' => 'Benutzerdefiniertes Feld bearbeiten',
        'module_name' => 'Modulname',
        'field_type' => 'Feldtyp',
        'field_name' => 'Feldname',
        'grid' => 'Raster',
        'value' => 'Wert',
        'seperated_by_comma' => 'Getrennt durch Komma',
        'is_reqired' => 'Ist erforderlich',
        'input' => 'Eingabe',
        'textarea' => 'Textarea',
        'checkbox' => 'Checkbox',
        'number' => 'Nummer',
        'dropdown' => 'Dropdown',
        'multi_select' => 'Mehrfachauswahl',
        'date' => 'Datum',
        'date_time' => 'Terminzeit',
        'appointment' => 'Termin',
        'ipd_patient' => 'IPD-Patient',
        'opd_patient' => 'OPD-Patient',
        'patient' => 'Patient',
        'value_must_be_greter_then' => 'Wert muss größer als 1 sein',
        'select_module' => 'Modul auswählen',
        'select_field_type' => 'Feldtyp auswählen',
        'text' => 'Text'
    ],

    'google_meet' => [
        'connect_calendar' => 'Verbinden Sie Ihren Google-Kalender',
        'disconnect_google_calendar' => 'Trennen Sie Ihren Google-Kalender',
        'sync_google_calendar' => 'Synchronisieren Sie Ihren Google-Kalender',
        'validate_json_file' => 'Bitte legen Sie die JSON-Datei mit Ihren Google-Kalender-Anmeldeinformationen fest',
        'google_calendar_connect' => 'Google Kalender erfolgreich verbunden',
        'google_calendar_add' => 'Kalender erfolgreich hinzugefügt',
        'google_calendar_update' => 'Google-Kalender erfolgreich aktualisiert.',
        'disconnect_or_reconnect' => 'Bitte trennen Sie die Verbindung zu Ihrem Google-Kalender und verbinden Sie ihn erneut',
        'google_calendar_disconnect' => 'Verbindung zum Google-Kalender getrennt',
        'select_google_calendar' => 'Wählen Sie Ihre Kalender (aus Google Kalender) aus, in denen Sie die Ereignisse erstellen möchten',
        'platform_type' => 'Plattformtyp',
        'google_json_file' => 'Google Json-Datei',
        'upload_json_file' => 'Bitte laden Sie eine JSON-Datei hoch.',
        'upload_file' => 'Bitte laden Sie eine Datei hoch.',
        'invalid_json_format' => 'Dieses Format ist ungültig. Das gültige Format ist JSON.',
        'json_file_saved_successfully' => 'Google Kalender-JSON-Datei erfolgreich gespeichert',
    ],

    'footer' => [
        'all_rights_reserved' => 'Alle Rechte vorbehalten',
    ],

    'open_ai' => [
        'provide_prompt' => 'Bitte geben Sie umgehend physische Informationen an.',
        'open_ai_key_not_found' => 'OpenAI-API-Schlüssel nicht gefunden.',
        'repsonse_retrive_successfully' => 'Antwort erfolgreich abgerufen.',
        'open_ai_key' => 'Öffnen Sie den AI-Schlüssel',
        'suggest_medicines' => 'Schlagen Sie Medikamente vor',
    ],

    'schedule_weekday' => [
        'Monday' => 'Montag',
        'Tuesday' => 'Dienstag',
        'Wednesday' => 'Mittwoch',
        'Thursday' => 'Donnerstag',
        'Friday' => 'Freitag',
        'Saturday' => 'Samstag',
        'Sunday' => 'Sonntag',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'MO',
        'TUE' => 'DI',
        'WED' => 'HEIRATEN',
        'THU' => 'DO',
        'FRI' => 'FR',
        'SAT' => 'SA',
        'SUN' => 'SONNE',
    ],
];
