<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Support\Carbon;

/**
 * Class ItemCategory
 *
 * @version August 26, 2020, 8:12 am UTC
 *
 * @property string $name
 *
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory query()
 *
 * @mixin \Eloquent
 *
 * @property int $id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ItemCategory whereUpdatedAt($value)
 */
class ItemCategory extends Model
{
    public static $rules = [
        'name' => 'required|unique:item_categories,name',
    ];

    public $table = 'item_categories';

    public $fillable = [
        'name',
    ];

    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
    ];
}
